/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.util.Vector;

public class JCVector
extends Vector {
    public JCVector(int n) {
        super(n, 10);
    }

    public JCVector(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (e != null && e instanceof Vector) {
                    JCVector jCVector = new JCVector((Vector)e);
                    this.addElement(jCVector);
                    continue;
                }
                this.addElement(vector.elementAt(i));
            }
        }
    }

    public JCVector() {
        super(1, 10);
    }

    public JCVector(Object[] objectArray) {
        this.copyFrom(objectArray);
    }

    public synchronized void add(Object object) {
        if (!this.contains(object)) {
            this.addElement(object);
        }
    }

    public boolean equals(JCVector jCVector) {
        if (jCVector == null || this.elementCount != jCVector.size()) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(this.elementData[i] == null ? jCVector.elementData[i] != null : !this.elementData[i].equals(jCVector.elementData[i]))) continue;
            return false;
        }
        return true;
    }

    public final synchronized void removeElementsAt(int n, int n2) {
        for (int i = n; i < n + n2 && n < this.elementCount; ++i) {
            this.removeElementAt(n);
        }
    }

    public synchronized void setElementAt(int n, Object object) {
        if (object != null) {
            if (this.elementCount < n + 1) {
                this.setSize(n + 1);
            }
            this.elementData[n] = object;
        } else if (n < this.elementCount) {
            this.elementData[n] = null;
        }
    }

    public final synchronized void setMinSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
            this.elementCount = n;
        }
    }

    public void strip() {
        int n;
        for (n = this.elementCount - 1; n >= 0 && this.elementData[n] == null; --n) {
        }
        this.elementCount = n + 1;
        this.trimToSize();
    }

    public Object[] getArrayCopy() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public final synchronized void copyFrom(Object[] objectArray) {
        if (objectArray == null) {
            this.removeAllElements();
        } else {
            this.ensureCapacity(objectArray.length);
            this.elementCount = objectArray.length;
            System.arraycopy(objectArray, 0, this.elementData, 0, objectArray.length);
        }
    }

    public final synchronized Object getFirst() {
        return this.elementCount > 0 ? this.elementData[0] : null;
    }

    public final synchronized Object getLast() {
        return this.elementCount > 0 ? this.elementData[this.elementCount - 1] : null;
    }
}

