/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JRemind
extends Frame
implements ActionListener {
    public JRemind jr;
    private Button next;
    private Button prev;
    private JRemindData[] dataarray = new JRemindData[20];
    private int pos;
    private int numofrecords = 0;
    private boolean exitonnoevents;
    private boolean showall;
    private int notice;
    private Label date;
    private Label event;
    private Label years;
    private String datafile = new String();

    public static void main(String[] stringArray) {
        JRemind jRemind = new JRemind(stringArray);
    }

    JRemind(String[] stringArray) {
        this.setTitle("JRemind 1.0");
        this.setupWindow();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.readCfgFile("jremind.cfg");
        this.pos = 0;
        this.prev.setEnabled(false);
        if (this.datafile == null) {
            try {
                this.datafile = stringArray[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.datafile = null;
            }
        }
        if (this.datafile == null) {
            this.event.setText("No datafile specified, please read the docs.");
            this.next.setEnabled(false);
        } else {
            this.ReadData(this.datafile);
            if (this.numofrecords == 0) {
                if (this.exitonnoevents) {
                    System.exit(0);
                }
                this.event.setText("No events Coming up");
                this.next.setEnabled(false);
            } else {
                this.setData(this.dataarray[this.pos]);
                if (this.numofrecords == 1) {
                    this.next.setEnabled(false);
                }
            }
        }
        this.pack();
        this.setVisible(true);
    }

    private void readCfgFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = new String();
            String string3 = new String();
            block11: while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "=", false);
                string3 = stringTokenizer.nextToken();
                switch (string3.charAt(0)) {
                    case 'n': {
                        this.notice = Integer.parseInt(stringTokenizer.nextToken());
                        continue block11;
                    }
                    case 's': {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n != 1) continue block11;
                        this.showall = true;
                        continue block11;
                    }
                    case 'e': {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n != 1) continue block11;
                        this.exitonnoevents = true;
                        continue block11;
                    }
                    case 'l': {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
                        this.setLocation(Integer.parseInt(stringTokenizer2.nextToken()), Integer.parseInt(stringTokenizer2.nextToken()));
                        continue block11;
                    }
                    case 'd': {
                        this.datafile = stringTokenizer.nextToken();
                        continue block11;
                    }
                }
                System.out.println(string2 + "\n is an invalid config line.  It will be igored.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File Not Found, setting defaults");
            this.setCfgDefaults();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception occured, setting defaults");
            this.setCfgDefaults();
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Error in parsing cfgfile, please be sure its formated right.\nSetting Defaults");
            this.setCfgDefaults();
        }
    }

    private void setCfgDefaults() {
        this.notice = 15;
        this.exitonnoevents = false;
        this.showall = false;
        this.datafile = null;
    }

    private void setData(JRemindData jRemindData) {
        this.date.setText(jRemindData.getMonth() + "-" + jRemindData.getDay() + "-" + jRemindData.getYear());
        this.event.setText(jRemindData.getEvent());
        if (jRemindData.getYearsOld() == 0 || jRemindData.getYear() == 0) {
            this.years.setText("");
        } else {
            this.years.setText("is " + jRemindData.getYearsOld() + " years in the making");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Next") {
            if (this.pos < 21) {
                if (this.dataarray[this.pos + 1] == null) {
                    System.out.println("Out of data");
                } else {
                    ++this.pos;
                    this.setData(this.dataarray[this.pos]);
                    if (this.dataarray[this.pos + 1] == null) {
                        this.next.setEnabled(false);
                    }
                    if (!this.prev.isEnabled()) {
                        this.prev.setEnabled(true);
                    }
                    this.repaint();
                }
            }
        } else if (this.pos > 0) {
            --this.pos;
            this.setData(this.dataarray[this.pos]);
            if (!this.next.isEnabled()) {
                this.next.setEnabled(true);
            }
            if (this.pos == 0) {
                this.prev.setEnabled(false);
            }
            this.repaint();
        }
    }

    public void addNewDataRecord(int n, int n2, int n3, int n4, String string) {
        this.dataarray[this.numofrecords] = new JRemindData(n, n2, n3, n4, string);
        ++this.numofrecords;
    }

    public void ReadData(String string) {
        String string2 = new String();
        String string3 = new String();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            GregorianCalendar gregorianCalendar3 = (GregorianCalendar)gregorianCalendar.clone();
            gregorianCalendar3.add(5, this.notice);
            while ((string2 = bufferedReader.readLine()) != null && (string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "-", false);
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                gregorianCalendar2.set(gregorianCalendar.get(1), n - 1, n2);
                if (gregorianCalendar2.get(6) < gregorianCalendar.get(6)) {
                    gregorianCalendar2.roll(1, true);
                }
                if (this.showall) {
                    this.addNewDataRecord(n2, n, n3, 0, string3);
                    continue;
                }
                if (!gregorianCalendar2.after(gregorianCalendar) || !gregorianCalendar2.before(gregorianCalendar3)) continue;
                this.addNewDataRecord(n2, n, n3, gregorianCalendar2.get(1) - n3, string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File Not Found");
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("IO Exception occured");
            System.exit(1);
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Error in parsing datafile, please be sure its formated right");
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error in parsing date line, please be sure its formated right");
            System.exit(1);
        }
    }

    private void setupWindow() {
        this.date = new Label();
        this.event = new Label();
        this.years = new Label();
        this.date.setAlignment(1);
        this.event.setAlignment(1);
        this.years.setAlignment(1);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)this.date, "North");
        panel.add((Component)this.event, "Center");
        panel.add((Component)this.years, "South");
        this.add((Component)panel, "North");
        Panel panel2 = new Panel();
        this.next = new Button("Next");
        this.prev = new Button("Prev");
        this.next.addActionListener(this);
        this.prev.addActionListener(this);
        panel2.add(this.next);
        panel2.add(this.prev);
        this.add((Component)panel2, "South");
    }
}

