/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager.spi;

import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import javax.transaction.TransactionManager;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.util.Messages;

public final class JNDIENCTransactionManagerFactory
implements TransactionManagerFactory {
    private static final String TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";
    private static final String NAME = "jndi";

    public String getName() {
        return NAME;
    }

    public TransactionManager getTransactionManager(JdoConf jdoConf) throws TransactionManagerAcquireException {
        TransactionManager transactionManager;
        Properties properties = new Properties();
        TransactionDemarcation demarcation = jdoConf.getTransactionDemarcation();
        Enumeration parameters = demarcation.getTransactionManager().enumerateParam();
        while (parameters.hasMoreElements()) {
            Param param = (Param)parameters.nextElement();
            properties.put(param.getName(), param.getValue());
        }
        Object objectFound = null;
        String jndiENC = properties.getProperty("jndiEnc", TRANSACTION_MANAGER_NAME);
        try {
            objectFound = new InitialContext().lookup(jndiENC);
            transactionManager = (TransactionManager)objectFound;
        }
        catch (ClassCastException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToCastToManager", objectFound.getClass().getName()), ex);
        }
        catch (NoInitialContextException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", jndiENC), ex);
        }
        catch (NameNotFoundException ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", jndiENC), ex);
        }
        catch (Exception ex) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", jndiENC), ex);
        }
        if (transactionManager == null) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.failToGetManager", jndiENC));
        }
        return transactionManager;
    }
}

