/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfo;
import org.exolab.castor.util.Messages;

public class PersistenceInfoGroup {
    LockEngine[] engines;

    public PersistenceInfoGroup(LockEngine[] engines) {
        this.engines = engines;
    }

    public PersistenceInfo getPersistenceInfo(Class type) throws ClassNotPersistenceCapableException {
        ClassMolder molder = null;
        int i = 0;
        while (i < this.engines.length && molder == null) {
            molder = this.engines[i++].getClassMolderWithDependent(type);
        }
        if (molder == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", type.getName()));
        }
        if (molder.isDependent()) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classIsDependent", type.getName(), molder.getDepends().getName()));
        }
        return new PersistenceInfo(this.engines[--i], molder);
    }

    public LockEngine getLockEngine() {
        if (this.engines != null && this.engines.length >= 1) {
            return this.engines[0];
        }
        return null;
    }
}

