/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Time
extends DateTimeBase {
    private static final String TIME_FORMAT_MILLI = "HH:mm:ss.SSS";
    private static final String TIME_FORMAT_NO_MILLI = "HH:mm:ss";
    private static final int HOUR_FLAG = 31;
    private static final int MINUTE_FLAG = 15;
    private static final int SECOND_FLAG = 7;
    private static final int MILLI_FLAG = 3;
    private static final int TIMEZONE_FLAG = 1;
    private static final String BAD_TIME = "Bad Time format: ";

    public Time() {
    }

    public Time(short[] values) {
        this.setValues(values);
    }

    public Time(long l) {
        if (l > 86400000L) {
            throw new IllegalArgumentException("Bad Time: the long value can't represent more than 24h.");
        }
        this.setHour((short)(l / 3600000L));
        this.setMinute((short)((l %= 3600000L) / 60000L));
        this.setSecond((short)((l %= 60000L) / 1000L), (short)(l % 1000L));
    }

    public Time(String time) throws ParseException {
        this();
        Time.parseTimeInternal(time, this);
    }

    public void setValues(short[] values) {
        if (values.length != 4) {
            throw new IllegalArgumentException("Time#setValues: not the right number of values");
        }
        this.setHour(values[0]);
        this.setMinute(values[1]);
        this.setSecond(values[2], values[3]);
    }

    public short[] getValues() {
        short[] result = null;
        result = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli()};
        return result;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat df = null;
        String temp = this.toString();
        df = temp.indexOf(46) > 0 ? new SimpleDateFormat(TIME_FORMAT_MILLI) : new SimpleDateFormat(TIME_FORMAT_NO_MILLI);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(temp);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isNegative()) {
            result.append('-');
        }
        if (this.getHour() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getHour());
        result.append(':');
        if (this.getMinute() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMinute());
        result.append(':');
        if (this.getSeconds() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getSeconds());
        if (this.getMilli() != 0) {
            result.append('.');
            if (this.getMilli() < 100) {
                result.append('0');
                if (this.getMilli() < 10) {
                    result.append('0');
                }
            }
            result.append(this.getMilli());
        }
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Time.parseTime(str);
    }

    public static Time parseTime(String str) throws ParseException {
        Time result = new Time();
        return Time.parseTimeInternal(str, result);
    }

    private static Time parseTimeInternal(String str, Time result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must notbe null.");
        }
        if (result == null) {
            result = new Time();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            ++idx;
            result.setNegative();
        }
        boolean hasNumber = false;
        boolean has2Digits = false;
        short currentNumber = 0;
        short savedNumber = 0;
        int flags = 31;
        block7: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case ':': {
                    if (!has2Digits) {
                        throw new ParseException(BAD_TIME + str + "\nAn hour field must have 2 digits.", idx);
                    }
                    if (flags == 31) {
                        result.setHour(currentNumber);
                        flags = 15;
                    } else if (flags == 15) {
                        result.setMinute(currentNumber);
                        flags = 7;
                    } else if (flags == 3) {
                        result.setSecond(savedNumber, currentNumber);
                    } else if (flags == 1) {
                        savedNumber = currentNumber;
                        currentNumber = 0;
                        flags = 0;
                    } else {
                        throw new ParseException(BAD_TIME + str + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", idx);
                    }
                    hasNumber = false;
                    has2Digits = false;
                    continue block7;
                }
                case '.': {
                    if (flags != 7) {
                        throw new ParseException(BAD_TIME + str + "\n'.'" + "is wrongly placed.", idx);
                    }
                    savedNumber = currentNumber;
                    currentNumber = 0;
                    hasNumber = false;
                    has2Digits = false;
                    flags = 3;
                    continue block7;
                }
                case 'Z': {
                    if (flags != 7 && flags != 3) {
                        throw new ParseException(BAD_TIME + str + "\n'Z'" + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    continue block7;
                }
                case '-': {
                    if (flags != 7 && flags != 3) {
                        throw new ParseException(BAD_TIME + str + "\n'-'" + "is wrongly placed.", idx);
                    }
                    if (flags == 7) {
                        result.setSecond(currentNumber, (short)0);
                    } else if (flags == 3) {
                        result.setSecond(savedNumber, currentNumber);
                    }
                    result.setUTC();
                    result.setZoneNegative(true);
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block7;
                }
                case '+': {
                    if (flags != 7 && flags != 3) {
                        throw new ParseException(BAD_TIME + str + "\n'+'" + "is wrongly placed.", idx);
                    }
                    if (flags == 7) {
                        result.setSecond(currentNumber, (short)0);
                    } else if (flags == 3) {
                        result.setSecond(savedNumber, currentNumber);
                    }
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block7;
                }
            }
            if ('0' <= ch && ch <= '9') {
                if (hasNumber) {
                    if (flags == 3) {
                        if (has2Digits) {
                            currentNumber = (short)(currentNumber + (ch - 48));
                            continue;
                        }
                        currentNumber = (short)(currentNumber + 10 * (ch - 48));
                        has2Digits = true;
                        continue;
                    }
                    currentNumber = (short)(currentNumber * 10 + (ch - 48));
                    has2Digits = true;
                    continue;
                }
                hasNumber = true;
                if (flags == 3) {
                    currentNumber = (short)(100 * (ch - 48));
                    continue;
                }
                currentNumber = (short)(ch - 48);
                continue;
            }
            throw new ParseException(str + ": Invalid character: " + ch, idx);
        }
        if (flags != 7 && flags != 3 && flags != 0) {
            throw new ParseException(BAD_TIME + str + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", idx);
        }
        if (flags == 7) {
            result.setSecond(currentNumber, (short)0);
        } else if (flags == 3) {
            result.setSecond(savedNumber, currentNumber);
        } else if (flags == 0) {
            if (currentNumber != -1) {
                result.setZone(savedNumber, currentNumber);
            } else {
                throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
            }
        }
        return result;
    }

    public short getCentury() {
        String err = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(err);
    }

    public short getYear() {
        String err = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(err);
    }

    public short getMonth() {
        String err = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }

    public short getDay() {
        String err = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(err);
    }

    public void setCentury(short century) {
        String err = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(err);
    }

    public void getYear(short year) {
        String err = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(err);
    }

    public void getMonth(short month) {
        String err = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }

    public void getDay(short day) {
        String err = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(err);
    }
}

