/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.labels;

import com.mayastudios.ixml.labels.LabelsLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LabelGroup {
    public static final Locale NEUTRAL_LOCALE = new Locale("", "", "");
    public final String mf_strGroupPrefix;
    private final Locale mf_oBaseLocale;
    private final List<LabelsLoader.RawLabel> mf_oBaseLocaleList;
    private final List<LabelsLoader.RawLabel> mf_oNeutralLocaleList;
    private Locale m_oCurrentLocale = NEUTRAL_LOCALE;
    private List<LabelsLoader.RawLabel> m_oCurrentLocaleList = null;

    public LabelGroup(String p_strGroupPrefix, Locale p_oBaseLocale) throws LocaleLoadException {
        if (p_oBaseLocale == null) {
            throw new IllegalArgumentException("You must specify a base locale.");
        }
        this.mf_strGroupPrefix = p_strGroupPrefix;
        this.mf_oBaseLocale = p_oBaseLocale;
        this.mf_oBaseLocaleList = this._loadLabels(p_oBaseLocale);
        if (this.mf_oBaseLocaleList == null) {
            throw new NoBaseLocaleException();
        }
        this.mf_oNeutralLocaleList = this._loadLabels(NEUTRAL_LOCALE);
        this._insertNeutralLocaleList(this.mf_oBaseLocaleList);
    }

    public static boolean areLanguagesEqual(Locale p_oLocaleOne, Locale p_oLocaleTwo) {
        return p_oLocaleOne.getLanguage().equals(p_oLocaleTwo.getLanguage());
    }

    protected abstract InputStream getLabelsFile(Locale var1);

    protected abstract InputStream getNeutralLabelsFile();

    protected InputStream getLabelsFile(String p_strBaseName, Locale p_oLabelsLocale) {
        return this.getClass().getResourceAsStream(String.format("%s_%s.xml", p_strBaseName, p_oLabelsLocale.getLanguage().toLowerCase()));
    }

    void setCurrentLocale(Locale p_oNewLocale) throws LocaleLoadException {
        if (p_oNewLocale == null) {
            throw new IllegalArgumentException("You must specify a locale.");
        }
        if (LabelGroup.areLanguagesEqual(p_oNewLocale, this.m_oCurrentLocale)) {
            return;
        }
        if (LabelGroup.areLanguagesEqual(p_oNewLocale, this.mf_oBaseLocale)) {
            this.m_oCurrentLocaleList = this.mf_oBaseLocaleList;
        } else {
            this.m_oCurrentLocaleList = this._loadLabels(p_oNewLocale);
            this._insertNeutralLocaleList(this.m_oCurrentLocaleList);
        }
        this.m_oCurrentLocale = p_oNewLocale;
    }

    private List<LabelsLoader.RawLabel> _loadLabels(Locale p_oLocale) throws LocaleLoadException {
        try {
            InputStream oStream = p_oLocale.getLanguage().length() == 0 ? this.getNeutralLabelsFile() : this.getLabelsFile(p_oLocale);
            if (oStream == null) {
                return null;
            }
            return LabelsLoader.loadLabels(oStream);
        }
        catch (Exception oException) {
            throw new LocaleLoadException(oException);
        }
    }

    private void _insertNeutralLocaleList(List<LabelsLoader.RawLabel> p_oList) {
        if (this.mf_oNeutralLocaleList == null) {
            return;
        }
        p_oList.addAll(0, this.mf_oNeutralLocaleList);
    }

    List<LabelsLoader.RawLabel> getBaseLocaleList() {
        return this.mf_oBaseLocaleList;
    }

    List<LabelsLoader.RawLabel> getCurrentLocaleList() {
        return this.m_oCurrentLocaleList;
    }

    public static class NoBaseLocaleException
    extends LocaleLoadException {
        public NoBaseLocaleException() {
            super((Exception)null);
        }
    }

    public static class LocaleLoadException
    extends Exception {
        public LocaleLoadException(Exception p_oBaseException) {
            super(p_oBaseException);
        }
    }
}

