/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.launcher.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyJniClassLoader
extends ClassLoader {
    private static final String CLASS_PATH_PROPERTY_NAME = "java.class.path";
    private static final String[] CLASS_PATH = EasyJniClassLoader.initializeClassPath();
    private final String m_className = this.getClass().getName();
    private static ArrayList<String> additionalLibPaths = new ArrayList();

    public EasyJniClassLoader(ClassLoader p_oParentClassLoader) {
        super(p_oParentClassLoader);
        String value = System.getProperty("java.library.addpath");
        if (value != null) {
            String[] paths = value.split(Pattern.quote(System.getProperty("path.separator")));
            EasyJniClassLoader.addCustomLibraryPath(paths);
        }
    }

    private static String[] initializeClassPath() {
        String ldpath = System.getProperty(CLASS_PATH_PROPERTY_NAME);
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    @Override
    protected synchronized Class<?> loadClass(String p_strClassName, boolean p_bResolveClass) throws ClassNotFoundException {
        Class<?> oLoadClass = this.m_className.equals(p_strClassName) ? this.getClass() : this.findLoadedClass(p_strClassName);
        if (oLoadClass == null) {
            if (p_strClassName.startsWith("java.") || p_strClassName.startsWith("javax.") || p_strClassName.startsWith("com.sun.") || p_strClassName.startsWith("sun.") || p_strClassName.startsWith("sunw.")) {
                return this.getParent().loadClass(p_strClassName);
            }
            InputStream oInStream = null;
            String strFilename = p_strClassName.replace('.', File.separatorChar) + ".class";
            String strJarFilename = p_strClassName.replace('.', '/') + ".class";
            for (String strClassPath : CLASS_PATH) {
                File oClassPathFile = new File(strClassPath);
                if (!oClassPathFile.exists()) continue;
                if (oClassPathFile.isDirectory()) {
                    try {
                        oInStream = new FileInputStream(strClassPath + File.separatorChar + strFilename);
                        break;
                    }
                    catch (FileNotFoundException oException) {
                        continue;
                    }
                }
                try {
                    JarFile oFile = new JarFile(strClassPath);
                    ZipEntry oEntry = oFile.getEntry(strJarFilename);
                    if (oEntry == null) continue;
                    oInStream = oFile.getInputStream(oEntry);
                    break;
                }
                catch (IOException oException) {
                    // empty catch block
                }
            }
            if (oInStream == null) {
                return this.getParent().loadClass(p_strClassName);
            }
            int i = p_strClassName.lastIndexOf(46);
            if (i != -1) {
                String pkgname = p_strClassName.substring(0, i);
                Package pkg = this.getPackage(pkgname);
                if (pkg != null) {
                    if (pkg.isSealed()) {
                        throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                    }
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            }
            ByteArrayOutputStream oBuffer = new ByteArrayOutputStream(4096);
            byte[] abyBuffer = new byte[4096];
            try {
                int iReadBytes;
                while ((iReadBytes = oInStream.read(abyBuffer)) != -1) {
                    oBuffer.write(abyBuffer, 0, iReadBytes);
                }
                byte[] data = oBuffer.toByteArray();
                oLoadClass = this.defineClass(p_strClassName, data, 0, data.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(p_strClassName);
            }
        }
        if (p_bResolveClass) {
            this.resolveClass(oLoadClass);
        }
        return oLoadClass;
    }

    @Override
    protected String findLibrary(String p_strLibname) {
        if (additionalLibPaths.isEmpty()) {
            return null;
        }
        String strLibName = System.mapLibraryName(p_strLibname);
        for (String strPath : additionalLibPaths) {
            File oLibraryFile = new File(strPath, strLibName);
            if (!oLibraryFile.isFile()) continue;
            return oLibraryFile.getAbsolutePath();
        }
        return null;
    }

    public static void addCustomLibraryPath(String ... p_additionalLibPaths) {
        for (String libPath : p_additionalLibPaths) {
            if (libPath == null || additionalLibPaths.contains(libPath)) continue;
            additionalLibPaths.add(libPath);
        }
    }

    public static boolean checkClassLoader() {
        return EasyJniClassLoader.checkClassLoader(Thread.currentThread());
    }

    public static boolean checkClassLoader(Thread p_thread) {
        return p_thread.getContextClassLoader() instanceof EasyJniClassLoader;
    }
}

