/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt;

import com.mayastudios.ixml.labels.LabelsCore;
import com.mayastudios.mscl.mwt.ExceptionDlg;
import com.mayastudios.mscl.mwt.widgets.CLinkText;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MessageBox {
    private static final String LINK_TEXT = "Show attached exception";
    private static final String DIALOG_HEADER = "An exception was attached to the message. It's displayed below.";
    public static final MessageBoxProps DEFAULT_PROPS = new MessageBoxProps("Show attached exception", "An exception was attached to the message. It's displayed below.");
    private static final int MIN_BUTTON_WIDTH = 75;

    private MessageBox() {
    }

    public static void showInfoDlg(Window window, String string, String string2, EIcon eIcon) {
        MessageBox.showInfoDlg(window, string, string2, eIcon, DEFAULT_PROPS);
    }

    public static void showInfoDlg(Window window, String string, String string2, EIcon eIcon, MessageBoxProps messageBoxProps) {
        MessageBox.showInfoDlg(window, string, string2, eIcon, null, messageBoxProps);
    }

    public static void showInfoDlg(Window window, String string, String string2, EIcon eIcon, Throwable throwable) {
        MessageBox.showInfoDlg(window, string, string2, eIcon, throwable, DEFAULT_PROPS);
    }

    public static void showInfoDlg(Window window, String string, String string2, EIcon eIcon, Throwable throwable, MessageBoxProps messageBoxProps) {
        MessageBox.showOptionDlg(window, string, string2, eIcon, EOptionButtons.OK, throwable, messageBoxProps);
    }

    public static EButton showOptionDlg(Window window, String string, String string2, EIcon eIcon, EOptionButtons eOptionButtons) {
        return MessageBox.showOptionDlg(window, string, string2, eIcon, eOptionButtons, DEFAULT_PROPS);
    }

    public static EButton showOptionDlg(Window window, String string, String string2, EIcon eIcon, EOptionButtons eOptionButtons, MessageBoxProps messageBoxProps) {
        return MessageBox.showOptionDlg(window, string, string2, eIcon, eOptionButtons, null, messageBoxProps);
    }

    public static EButton showOptionDlg(Window window, String string, String string2, EIcon eIcon, EOptionButtons eOptionButtons, Throwable throwable) {
        return MessageBox.showOptionDlg(window, string, string2, eIcon, eOptionButtons, throwable, DEFAULT_PROPS);
    }

    public static EButton showOptionDlg(Window window, String string, String string2, EIcon eIcon, EOptionButtons eOptionButtons, Throwable throwable, MessageBoxProps messageBoxProps) {
        Object object;
        EButton[] eButtonArray = eOptionButtons.m_aeButtons;
        JOptionPane jOptionPane = new JOptionPane(new CCustomContent(string, throwable, messageBoxProps), eIcon._getMessageType(), -1, null, (Object[])eButtonArray, (Object)eButtonArray[0]);
        Component[] componentArray = jOptionPane.getComponents();
        if (componentArray.length == 2 && componentArray[1] instanceof JPanel) {
            componentArray = ((JPanel)componentArray[1]).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                object = componentArray[i];
                if (!(object instanceof Button) && !(object instanceof JButton)) continue;
                Dimension dimension = ((Component)object).getPreferredSize();
                if (dimension.width < 75) {
                    dimension.width = 75;
                }
                ((Component)object).setMinimumSize(dimension);
                ((Component)object).setPreferredSize(dimension);
            }
        }
        JDialog jDialog = jOptionPane.createDialog(window, string2);
        jOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        object = jOptionPane.getValue();
        if (object != null) {
            for (int i = 0; i < eButtonArray.length; ++i) {
                if (!eButtonArray[i].equals(object)) continue;
                return eOptionButtons.m_aeButtons[i];
            }
        }
        return EButton.CLOSED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappedText {
        private final String[] mf_astrLines;
        private final int mf_iLineHeight;
        private final int mf_iWidth;

        public WrappedText(String string, Font font, Graphics graphics, int n, boolean bl) {
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            FontMetrics fontMetrics2 = bl ? graphics.getFontMetrics(font.deriveFont(1)) : null;
            this.mf_iLineHeight = fontMetrics.getHeight();
            if (bl) {
                string = string.replace("<", "&lt;").replace(">", "&gt;");
            }
            String[] stringArray = string.split("\n");
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            Bold bold = bl ? new Bold() : null;
            for (String string2 : stringArray) {
                int n3 = WrappedText._wrapLine(string2, n, fontMetrics, fontMetrics2, vector, bold);
                n2 = Math.max(n3, n2);
            }
            this.mf_astrLines = vector.toArray(new String[vector.size()]);
            this.mf_iWidth = n2;
        }

        private static int _wrapLine(String string, int n, FontMetrics fontMetrics, FontMetrics fontMetrics2, Vector<String> vector, Bold bold) {
            String[] stringArray = string.split(" ");
            int n2 = fontMetrics.charWidth(' ');
            StringBuilder stringBuilder = new StringBuilder(Math.min(150, string.length()));
            int n3 = 0;
            int n4 = 0;
            for (String string2 : stringArray) {
                int n5;
                if (bold != null) {
                    String[] stringArray2 = string2.split("\\[b\\]");
                    boolean bl = string2.endsWith("[b]");
                    n5 = -1;
                    string2 = "";
                    for (String string3 : stringArray2) {
                        if (n5 == -1) {
                            n5 = 0;
                        } else {
                            string2 = string2 + (bold.m_bIsBold ? "</b>" : "<b>");
                            bold.m_bIsBold = !bold.m_bIsBold;
                        }
                        string2 = string2 + string3;
                        if (!bold.m_bIsBold) {
                            n5 += fontMetrics.stringWidth(string3);
                            continue;
                        }
                        n5 += fontMetrics2.stringWidth(string3);
                    }
                    if (bl) {
                        string2 = string2 + (bold.m_bIsBold ? "</b>" : "<b>");
                        bold.m_bIsBold = !bold.m_bIsBold;
                    }
                } else {
                    n5 = fontMetrics.stringWidth(string2);
                }
                if (n3 + n5 + n2 >= n) {
                    if (n3 != 0) {
                        vector.add(stringBuilder.toString());
                        if (n3 > n4) {
                            n4 = n3;
                        }
                        stringBuilder = new StringBuilder(Math.min(150, string.length()));
                    }
                    stringBuilder.append(string2);
                    n3 = n5;
                    continue;
                }
                if (n3 == 0) {
                    stringBuilder.append(string2);
                    n3 += n5;
                    continue;
                }
                stringBuilder.append(" " + string2);
                n3 += n2 + n5;
            }
            vector.add(stringBuilder.toString());
            n4 = Math.max(n3, n4);
            return n4;
        }

        public int getLineCount() {
            return this.mf_astrLines.length;
        }

        public int getLineHeight() {
            return this.mf_iLineHeight;
        }

        public int getWidth() {
            return this.mf_iWidth;
        }

        public int getHeight() {
            return this.mf_iLineHeight * this.mf_astrLines.length;
        }

        public String[] getLines() {
            return this.mf_astrLines;
        }

        private static class Bold {
            public boolean m_bIsBold = false;

            private Bold() {
            }
        }
    }

    private static class MultilineLabel
    extends JComponent {
        private boolean m_bInitialized = false;
        private String m_strText = null;
        private ETextAlignment m_eAlignment = ETextAlignment.START;
        private WrappedText m_oWrappedText = null;
        private int m_iMaxWidth = Short.MAX_VALUE;
        private JLabel mf_oLabel = new JLabel();

        public MultilineLabel() {
            this(null);
        }

        public MultilineLabel(String string) {
            this(string, Short.MAX_VALUE);
        }

        public MultilineLabel(int n) {
            this("", n);
        }

        public MultilineLabel(String string, int n) {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add(this.mf_oLabel);
            this.m_strText = string;
            this.setMaxWidth(n);
        }

        public void setText(String string) {
            this.m_strText = string;
            this._updateWrappedText();
        }

        public void setOpaque(boolean bl) {
            super.setOpaque(bl);
            this.mf_oLabel.setOpaque(bl);
        }

        public String getText() {
            return this.m_strText;
        }

        public void setMaxWidth(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Invalid maximum width: " + n);
            }
            this.m_iMaxWidth = n;
            this._updateWrappedText();
        }

        private WrappedText _getWrappedText() {
            if (!this.m_bInitialized) {
                this._updateWrappedText();
            }
            return this.m_oWrappedText;
        }

        private void _updateWrappedText() {
            String string;
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            this.m_bInitialized = true;
            if (this.m_strText == null || this.m_strText.trim().length() == 0 || this.m_iMaxWidth == 0) {
                this.m_oWrappedText = null;
                this.mf_oLabel.setText(null);
                return;
            }
            this.m_oWrappedText = new WrappedText(this.m_strText, this.mf_oLabel.getFont(), graphics, this.m_iMaxWidth, true);
            StringBuilder stringBuilder = new StringBuilder(this.m_strText.length() + this.m_oWrappedText.getLineCount() * 4 + 100);
            switch (this.m_eAlignment) {
                case CENTER: {
                    string = "center";
                    break;
                }
                case END: {
                    if (this.getComponentOrientation().isLeftToRight()) {
                        string = "right";
                        break;
                    }
                    string = "left";
                    break;
                }
                default: {
                    string = this.getComponentOrientation().isLeftToRight() ? "left" : "right";
                }
            }
            stringBuilder.append("<html><p align=\"").append(string).append("\">");
            for (String string2 : this.m_oWrappedText.getLines()) {
                stringBuilder.append(string2).append("<br>");
            }
            this.mf_oLabel.setText(stringBuilder.toString());
        }

        public void setPreferredSize(Dimension dimension) {
            if (dimension != null) {
                this.setMaxWidth(dimension.width);
            }
            super.setPreferredSize(dimension);
        }

        public Dimension getPreferredSize() {
            WrappedText wrappedText = this._getWrappedText();
            if (this.isPreferredSizeSet() || wrappedText == null) {
                return super.getPreferredSize();
            }
            return new Dimension(this.m_oWrappedText.getWidth(), this.m_oWrappedText.getHeight());
        }

        public void setTextAlignment(ETextAlignment eTextAlignment) {
            this.m_eAlignment = eTextAlignment;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ETextAlignment {
            START,
            CENTER,
            END;

        }
    }

    private static class CCustomContent
    extends JPanel
    implements CLinkText.IClickListener {
        private final MessageBoxProps mf_oProps;
        private final Throwable mf_oException;

        public CCustomContent(String string, Throwable throwable, MessageBoxProps messageBoxProps) {
            this.mf_oException = throwable;
            this.mf_oProps = messageBoxProps;
            super.setLayout(new BorderLayout());
            super.add((Component)new MultilineLabel(string, messageBoxProps.mf_iMaxWidth), "Center");
            if (throwable != null) {
                JPanel jPanel = new JPanel();
                CLinkText cLinkText = new CLinkText(messageBoxProps.mf_strLinkText);
                cLinkText.setListener(this);
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)cLinkText, "Before");
                Dimension dimension = cLinkText.getPreferredSize();
                dimension.height += 30;
                jPanel.setPreferredSize(dimension);
                super.add((Component)jPanel, "Last");
            }
        }

        public void clickPerformed(CLinkText cLinkText) {
            Container container;
            for (container = this.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
            }
            new ExceptionDlg((JDialog)container, this.mf_oProps.mf_strDialogHeader, this.mf_oProps.mf_strLinkText, this.mf_oException);
        }
    }

    public static class MessageBoxProps {
        public static final int MAX_WIDTH = 500;
        public final String mf_strLinkText;
        public final String mf_strDialogHeader;
        public final int mf_iMaxWidth;

        public MessageBoxProps(String string, String string2) {
            this(string, string2, 500);
        }

        public MessageBoxProps(String string, String string2, int n) {
            this.mf_strLinkText = string;
            this.mf_strDialogHeader = string2;
            this.mf_iMaxWidth = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EOptionButtons {
        OK(new EButton[]{EButton.OK}),
        OK_CANCEL(new EButton[]{EButton.OK, EButton.CANCEL}),
        YES_NO(new EButton[]{EButton.YES, EButton.NO}),
        YES_NO_CANCEL(new EButton[]{EButton.YES, EButton.NO, EButton.CANCEL}),
        RETRY_IGNORE_CANCEL(new EButton[]{EButton.RETRY, EButton.IGNORE, EButton.CANCEL});

        private final EButton[] m_aeButtons;

        private EOptionButtons(EButton[] eButtonArray) {
            this.m_aeButtons = eButtonArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EButton {
        CLOSED("", ""),
        OK("Text.OK", "OK"),
        CANCEL("Text.Cancel", "Cancel"),
        YES("Text.Yes", "Yes"),
        NO("Text.No", "No"),
        RETRY("Text.Retry", "Retry"),
        IGNORE("Text.Ignore", "Ignore");

        private final String mf_strLabel;
        private final String mf_strAlternativeText;

        private EButton(String string2, String string3) {
            this.mf_strLabel = string2;
            this.mf_strAlternativeText = string3;
        }

        public String toString() {
            String string = LabelsCore.getNullable((String)this.mf_strLabel, (Object[])new Object[0]);
            if (string == null) {
                return this.mf_strAlternativeText;
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EIcon {
        NONE,
        ERROR,
        WARNING,
        INFORMATION,
        QUESTION;


        private int _getMessageType() {
            switch (this) {
                case NONE: {
                    return -1;
                }
                case ERROR: {
                    return 0;
                }
                case WARNING: {
                    return 2;
                }
                case INFORMATION: {
                    return 1;
                }
                case QUESTION: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        }
    }
}

