/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.tablelayout;

import com.mayastudios.mscl.mwt.tablelayout.ABaseCell;
import com.mayastudios.mscl.mwt.tablelayout.ABaseRow;
import com.mayastudios.mscl.mwt.tablelayout.ArrangeHelper;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowAutoGlue;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowAutoHeight;
import com.mayastudios.mscl.mwt.tablelayout.CInternalRowFixedHeight;
import com.mayastudios.mscl.mwt.tablelayout.IArrangeInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;

class CLayoutManager
implements LayoutManager2 {
    private final Container mf_oLayoutedContainer;
    private final Vector<ABaseRow> mf_oRowList = new Vector();
    private final Insets mf_oMargin = new Insets(0, 0, 0, 0);

    CLayoutManager(Container container, int n, int n2, int n3, int n4) {
        assert (container != null);
        assert (container.getComponentCount() == 0);
        this.mf_oLayoutedContainer = container;
        this.setMargins(n, n2, n3, n4);
    }

    void setMargins(int n, int n2, int n3, int n4) {
        this.mf_oMargin.top = n2;
        this.mf_oMargin.left = n;
        this.mf_oMargin.bottom = n4;
        this.mf_oMargin.right = n3;
    }

    void addNewRow(ABaseRow aBaseRow) {
        this.mf_oRowList.add(aBaseRow);
    }

    void addNewCell(Component component, ABaseCell aBaseCell) {
        this.mf_oLayoutedContainer.add(component, aBaseCell);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        ABaseCell aBaseCell;
        if (component == null) {
            throw new NullPointerException("The added component must not be null.");
        }
        if (object instanceof ABaseCell) {
            aBaseCell = (ABaseCell)object;
            aBaseCell.setAttachedElement(component);
            if (this.mf_oRowList.size() == 0) {
                this.addNewRow(new CInternalRowAutoHeight());
            }
        } else {
            throw new IllegalArgumentException("Invalid constrained added! You must CTableLayout.addCell to add new components.");
        }
        this.mf_oRowList.lastElement().addCell(aBaseCell);
    }

    public void removeLayoutComponent(Component component) {
        Iterator<ABaseRow> iterator = this.mf_oRowList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().removeCell(component)) continue;
            return;
        }
        throw new IllegalArgumentException("Component does not belong to this layout manager");
    }

    private final void _checkContainer(Container container) {
        if (container != this.mf_oLayoutedContainer) {
            throw new IllegalStateException("This LayoutManager2 instance cannot be shared between multiply containers!");
        }
    }

    public void setPreferredSize(Dimension dimension) {
        this.mf_oLayoutedContainer.setPreferredSize(dimension);
    }

    public Dimension preferredLayoutSize(Container container) {
        this._checkContainer(container);
        Dimension dimension = new Dimension(0, 0);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        this._checkContainer(container);
        Dimension dimension = new Dimension(0, 0);
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this._checkContainer(container);
        Insets insets = container.getInsets();
        int n = container.getWidth() - (insets.left + insets.right) - (this.mf_oMargin.left + this.mf_oMargin.right);
        int n2 = container.getHeight() - (insets.top + insets.bottom) - (this.mf_oMargin.top + this.mf_oMargin.bottom);
        if (n == 0 || n2 == 0) {
            return;
        }
        this._layoutRows(insets.top + this.mf_oMargin.top, n2);
        Iterator<ABaseRow> iterator = this.mf_oRowList.iterator();
        Rectangle rectangle = new Rectangle();
        while (iterator.hasNext()) {
            ABaseRow aBaseRow = iterator.next();
            rectangle.setBounds(insets.left + this.mf_oMargin.left, aBaseRow.getPreLayoutPosition(), n, aBaseRow.getPreLayoutSize());
            aBaseRow.layoutCells(rectangle);
        }
    }

    private void _layoutRows(int n, int n2) {
        int n3 = 0;
        Vector<IArrangeInfo> vector = new Vector<IArrangeInfo>();
        Vector<IArrangeInfo> vector2 = new Vector<IArrangeInfo>();
        Vector<IArrangeInfo> vector3 = new Vector<IArrangeInfo>();
        for (ABaseRow aBaseRow : this.mf_oRowList) {
            aBaseRow.invalidateCellBoundaries();
            int n4 = aBaseRow.getPreferredHeight();
            aBaseRow.setPreLayout(0, n4);
            n3 += n4;
            switch (aBaseRow.getType()) {
                case AUTO_HEIGHT_ROW: {
                    vector2.add((CInternalRowAutoHeight)aBaseRow);
                    break;
                }
                case AUTO_GLUE_ROW: {
                    vector.add((CInternalRowAutoGlue)aBaseRow);
                    break;
                }
                case FIXED_HEIGHT_ROW: {
                    vector3.add((CInternalRowFixedHeight)aBaseRow);
                }
            }
        }
        if (n2 > n3 && vector.size() > 0) {
            ArrangeHelper.expandElements(vector, n2 - n3);
        } else if (n2 < n3) {
            int n5 = n3 - n2;
            if (vector.size() > 0) {
                n5 = ArrangeHelper.shrinkElements(vector, n5);
            }
            if (n5 > 0 && vector2.size() > 0) {
                n5 = ArrangeHelper.shrinkElements(vector2, n5);
            }
            if (n5 > 0 && vector3.size() > 0) {
                n5 = ArrangeHelper.shrinkElements(vector3, n5);
            }
        }
        int n6 = n;
        for (ABaseRow aBaseRow : this.mf_oRowList) {
            int n7 = aBaseRow.getPreLayoutSize();
            aBaseRow.setPreLayout(n6, n7);
            n6 += n7;
        }
    }
}

