/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.flexlayout;

import com.mayastudios.ixml.document.comp.flexlayout.FlexArranger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.LinkedList;

public class FlexLayout
implements LayoutManager2 {
    public static final int DEFAULT_CELL_SPACING = 7;
    private final boolean mf_bIsVerticalLayout;
    private final int mf_iCellSpacing;
    private final LinkedList<FlexArrangeHelper> mf_oComponentList = new LinkedList();

    public FlexLayout(boolean p_bIsVerticalLayout) {
        this(p_bIsVerticalLayout, 7);
    }

    public FlexLayout(boolean p_bIsVerticalLayout, int p_iCellSpacing) {
        this.mf_bIsVerticalLayout = p_bIsVerticalLayout;
        this.mf_iCellSpacing = p_iCellSpacing;
    }

    public boolean isVerticalLayout() {
        return this.mf_bIsVerticalLayout;
    }

    public void addLayoutComponent(Component p_oComponent, Object p_oFlexValue) {
        int iFlexValue = 0;
        int iSpacing = this.mf_iCellSpacing;
        if (p_oFlexValue != null) {
            if (p_oFlexValue instanceof Integer) {
                iFlexValue = Math.max((Integer)p_oFlexValue, 0);
            } else if (p_oFlexValue instanceof FlexConstraint) {
                FlexConstraint oFlexConstraint = (FlexConstraint)p_oFlexValue;
                iFlexValue = Math.max(oFlexConstraint.mf_iFlexValue, 0);
                iSpacing = oFlexConstraint.mf_iSpacing;
            } else {
                throw new IllegalArgumentException("Only \"Integer\" and \"FlexConstraint\" instances are allowed as constraints.");
            }
        }
        FlexArrangeHelper oConstraint = new FlexArrangeHelper(p_oComponent, iFlexValue, iSpacing);
        this.mf_oComponentList.add(oConstraint);
    }

    public void removeLayoutComponent(Component p_oComponent) {
        int iIndex = 0;
        for (FlexArrangeHelper oConstraint : this.mf_oComponentList) {
            if (oConstraint.mf_oComponent == p_oComponent) {
                this.mf_oComponentList.remove(iIndex);
                return;
            }
            ++iIndex;
        }
    }

    public float getLayoutAlignmentX(Container p_oLayoutedContainer) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container p_oLayoutedContainer) {
        return 0.0f;
    }

    public void invalidateLayout(Container p_oLayoutedContainer) {
    }

    public Dimension minimumLayoutSize(Container p_oLayoutedContainer) {
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        FlexArrangeHelper oLastConstraint = this.mf_oComponentList.getLast();
        for (FlexArrangeHelper oConstraint : this.mf_oComponentList) {
            Dimension oCompSize = oConstraint.mf_oComponent.getMinimumSize();
            if (this.mf_bIsVerticalLayout) {
                oSize.width = Math.max(oSize.width, oCompSize.width);
                if (oConstraint != oLastConstraint) {
                    oSize.height += oConstraint.mf_iSpacing;
                }
                oSize.height += oCompSize.height;
                continue;
            }
            if (oConstraint != oLastConstraint) {
                oSize.width += oConstraint.mf_iSpacing;
            }
            oSize.width += oCompSize.width;
            oSize.height = Math.max(oSize.height, oCompSize.height);
        }
        oSize.width += oInsets.left + oInsets.right;
        oSize.height += oInsets.top + oInsets.bottom;
        return oSize;
    }

    public Dimension preferredLayoutSize(Container p_oLayoutedContainer) {
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        FlexArrangeHelper oLastConstraint = this.mf_oComponentList.getLast();
        for (FlexArrangeHelper oConstraint : this.mf_oComponentList) {
            Dimension oCompSize = oConstraint.mf_oComponent.getPreferredSize();
            if (this.mf_bIsVerticalLayout) {
                oSize.width = Math.max(oSize.width, oCompSize.width);
                if (oConstraint != oLastConstraint) {
                    oSize.height += oConstraint.mf_iSpacing;
                }
                oSize.height += oCompSize.height;
                continue;
            }
            if (oConstraint != oLastConstraint) {
                oSize.width += oConstraint.mf_iSpacing;
            }
            oSize.width += oCompSize.width;
            oSize.height = Math.max(oSize.height, oCompSize.height);
        }
        oSize.width += oInsets.left + oInsets.right;
        oSize.height += oInsets.top + oInsets.bottom;
        return oSize;
    }

    public Dimension maximumLayoutSize(Container p_oLayoutedContainer) {
        Dimension oSize = new Dimension();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        FlexArrangeHelper oLastConstraint = this.mf_oComponentList.getLast();
        if (this.mf_bIsVerticalLayout) {
            oSize.width = Short.MAX_VALUE;
        } else {
            oSize.height = Short.MAX_VALUE;
        }
        for (FlexArrangeHelper oConstraint : this.mf_oComponentList) {
            Dimension oCompSize = oConstraint.mf_oComponent.getMaximumSize();
            if (this.mf_bIsVerticalLayout) {
                oSize.width = Math.min(oSize.width, oCompSize.width);
                if (oConstraint != oLastConstraint) {
                    oSize.height += oConstraint.mf_iSpacing;
                }
                oSize.height += oCompSize.height;
                if (oCompSize.height < Short.MAX_VALUE && oSize.height < Short.MAX_VALUE) continue;
                oSize.height = Short.MAX_VALUE;
                continue;
            }
            oSize.height = Math.min(oSize.height, oCompSize.height);
            if (oConstraint != oLastConstraint) {
                oSize.width += oConstraint.mf_iSpacing;
            }
            oSize.width += oCompSize.width;
            if (oCompSize.width < Short.MAX_VALUE && oSize.width < Short.MAX_VALUE) continue;
            oSize.width = Short.MAX_VALUE;
        }
        if (oSize.width < Short.MAX_VALUE) {
            oSize.width += oInsets.left + oInsets.right;
        }
        if (oSize.height < Short.MAX_VALUE) {
            oSize.height += oInsets.top + oInsets.bottom;
        }
        return oSize;
    }

    public void layoutContainer(Container p_oLayoutedContainer) {
        int iSize;
        FlexArranger.FlexAdditionalLayoutInfo oInfo;
        Dimension oSize = p_oLayoutedContainer.getSize();
        Insets oInsets = p_oLayoutedContainer.getInsets();
        if (this.mf_bIsVerticalLayout) {
            oInfo = new FlexArranger.FlexAdditionalLayoutInfo(oInsets, oSize.width - oInsets.left - oInsets.right);
            iSize = oSize.height - oInsets.top - oInsets.bottom;
        } else {
            oInfo = new FlexArranger.FlexAdditionalLayoutInfo(oInsets, oSize.height - oInsets.top - oInsets.bottom);
            iSize = oSize.width - oInsets.left - oInsets.right;
        }
        if (iSize <= 0 || oInfo.mf_iOtherDimSize <= 0) {
            return;
        }
        FlexArranger.sizeElements(this.mf_oComponentList, iSize, oInfo);
    }

    public void addLayoutComponent(String p_strName, Component p_oComponent) {
    }

    private class FlexArrangeHelper
    implements FlexArranger.IFlexArrangable {
        public final Component mf_oComponent;
        public final int mf_iFlexValue;
        public final int mf_iSpacing;

        public FlexArrangeHelper(Component p_oComponent, int p_iFlexValue, int p_iSpacing) {
            this.mf_oComponent = p_oComponent;
            this.mf_iFlexValue = p_iFlexValue;
            this.mf_iSpacing = p_iSpacing;
        }

        public int getFlexValue() {
            return this.mf_iFlexValue;
        }

        public int getSpacing() {
            return this.mf_iSpacing;
        }

        public int getMinimumSize() {
            Dimension oSize = this.mf_oComponent.getMinimumSize();
            return FlexLayout.this.mf_bIsVerticalLayout ? oSize.height : oSize.width;
        }

        public int getPreferredSize() {
            Dimension oSize = this.mf_oComponent.getPreferredSize();
            return FlexLayout.this.mf_bIsVerticalLayout ? oSize.height : oSize.width;
        }

        public int getMaximumSize() {
            Dimension oSize = this.mf_oComponent.getMaximumSize();
            return FlexLayout.this.mf_bIsVerticalLayout ? oSize.height : oSize.width;
        }

        public void setBounds(int p_iPos, int p_iSize, FlexArranger.FlexAdditionalLayoutInfo p_oInfo) {
            if (FlexLayout.this.mf_bIsVerticalLayout) {
                this.mf_oComponent.setBounds(p_oInfo.mf_oInsets.left, p_oInfo.mf_oInsets.top + p_iPos, p_oInfo.mf_iOtherDimSize, p_iSize);
            } else {
                this.mf_oComponent.setBounds(p_oInfo.mf_oInsets.left + p_iPos, p_oInfo.mf_oInsets.top, p_iSize, p_oInfo.mf_iOtherDimSize);
            }
        }
    }

    public static class FlexConstraint {
        public final int mf_iFlexValue;
        public final int mf_iSpacing;

        public FlexConstraint(int p_iFlexValue, int p_iSpacing) {
            this.mf_iFlexValue = p_iFlexValue;
            this.mf_iSpacing = p_iSpacing;
        }
    }
}

