/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling.objectcontainer;

import com.mayastudios.fred.client.exceptions.CFredAbortException;
import com.mayastudios.fred.client.exceptions.CModelException;
import com.mayastudios.fred.client.filehandling.objectcontainer.ARootXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class CXMLHandler
extends CSimpleDefaultHandler {
    private ARootXMLObjectContainer<?> m_oRootContainer;
    private final int mf_iFileVersion;
    private AXMLObjectContainer m_oCurContainer = null;

    CXMLHandler(ARootXMLObjectContainer<?> aRootXMLObjectContainer, int n) {
        this.m_oRootContainer = aRootXMLObjectContainer;
        this.mf_iFileVersion = n;
    }

    @Override
    public void startElement(String string, Attributes attributes) throws SAXException {
        if (this.m_oCurContainer == null) {
            if (this.m_oRootContainer == null) {
                throw new SAXException("Second root node? This is not valid!");
            }
            this.m_oCurContainer = this.m_oRootContainer;
            if (!this.m_oRootContainer.getXMLTagName().equals(string)) {
                throw new SAXException(String.format("Root tag with name \"%s\" expected but found: \"%s\"", this.m_oRootContainer.getXMLTagName(), string));
            }
        } else {
            AXMLObjectContainer<?> aXMLObjectContainer = this.m_oCurContainer.newChildContainer(string, this.mf_iFileVersion);
            if (aXMLObjectContainer == null) {
                throw new CModelException("Unexpected child tag: " + string);
            }
            aXMLObjectContainer.setParentContainer(this.m_oCurContainer);
            this.m_oCurContainer = aXMLObjectContainer;
        }
        this.m_oCurContainer.m_oObject = this.m_oCurContainer.createContainedObject(attributes, this.mf_iFileVersion);
    }

    @Override
    public void endElement(String string) throws SAXException {
        AXMLObjectContainer<?> aXMLObjectContainer = this.m_oCurContainer.getParentContainer();
        this.m_oCurContainer.completeContainedObject(this.mf_iFileVersion);
        if (aXMLObjectContainer != null) {
            aXMLObjectContainer.childContainerCompleted(string, this.m_oCurContainer.getContainedObject(), this.mf_iFileVersion);
        } else {
            this.m_oRootContainer = null;
        }
        this.m_oCurContainer = aXMLObjectContainer;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.m_oCurContainer.foundCharacters(new String(cArray, n, n2), this.mf_iFileVersion);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        throw CXMLHandler.createAbortException(sAXParseException, "fatal error");
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        throw CXMLHandler.createAbortException(sAXParseException, "error");
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        throw CXMLHandler.createAbortException(sAXParseException, "warning");
    }

    private static CFredAbortException createAbortException(SAXParseException sAXParseException, String string) {
        String string2 = String.format("Severity: %s%nSystemID: %s%nPublicID: %s%nLine:     %,d%nColumn:   %,d%n%s", string, sAXParseException.getSystemId(), sAXParseException.getPublicId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
        return new CFredAbortException(string2);
    }
}

