/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.ADummyXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DataMask;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.view.CProjectTree;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public abstract class AFilter
implements IXMLizable,
Cloneable {
    public static final String XML_TAG_NAME = "filter";
    private static final String XML_ATT_FILTERMODE = "filtermode";
    private static final String XML_VAL_FILTERMODE_TASKS = "tasks";
    private static final String XML_VAL_FILTERMODE_CATEGORIES = "categories";
    private static final String XML_ATT_USE_FILTER = "usefilter";
    private static final String XML_ATT_START = "start";
    private static final String XML_ATT_END = "end";
    private static final String XML_ATT_DATAMASK = "datamask";
    private static final String XML_ATT_RELEVANTMASK = "relevantmask";
    private static final String XML_ATT_SEARCHSTRING = "searchstring";
    private static final String XML_ATT_COLLIDING_EFFORT_ID = "effortid";
    private static final String XML_TASKS_TAG_NAME = "tasksoffilter";
    private static final String XML_TASK_TAG_NAME = "taskoffilter";
    private static final String XML_ATT_TASK_ID = "id";
    private static final String XML_PERSONS_TAG_NAME = "personsoffilter";
    private static final String XML_PERSON_TAG_NAME = "personoffilter";
    private static final String XML_ATT_PERSON_ID = "id";
    private static final String XML_CATEGORIES_TAG_NAME = "categoriesoffilter";
    private static final String XML_CATEGORY1_TAG_NAME = "categoryoffilterv1";
    private static final String XML_CATEGORY2_TAG_NAME = "categoryoffilterv2";
    private static final String XML_ATT_CATEGORY_ID = "id";
    private static final String XML_ATT_CATEGORY_PROJECT_ID = "projectid";
    private static final Logger LOGGER = LoggerFactory.getLogger(AFilter.class);
    public static final int BIT_APPROVED = 5;
    public static final int BIT_COLLIDATIONS = 4;
    public static final int BIT_IGNORE_MISTAKES = 3;
    public static final int BIT_REPLICATED = 2;
    public static final int BIT_ACCEPTIONSTATE_SET = 1;
    public static final int BIT_ACCEPTED = 0;
    private static final int BIT_COUNT = 6;
    private boolean m_bUseThisFilter = false;
    private TreeSet<CTaskImpl> m_oTasks = new TreeSet();
    private TreeSet<CPersonImpl> m_oPersons = new TreeSet();
    private Calendar m_oStart = null;
    private Calendar m_oEnd = null;
    private int m_iDataMask = 0;
    private int m_iRelevantMask = 0;
    private String m_strSearchString = null;
    private long m_lStart;
    private long m_lEnd;
    private CEffortImpl m_oComparableLeft = null;
    private CEffortImpl m_oComparableRight = null;
    private CEffortImpl m_oCollidingReference = null;

    protected AFilter() {
    }

    protected abstract void setDefaultCategories(CTaskImpl var1);

    public boolean useThisFilter() {
        return this.m_bUseThisFilter;
    }

    public void setUseThisFilter(boolean bl) {
        this.m_bUseThisFilter = bl;
    }

    public abstract void addTreePaths(TreePath[] var1);

    public void addTask(CTaskImpl cTaskImpl) {
        this.m_oTasks.add(cTaskImpl);
    }

    public void addAllTasks() {
        Iterator<CProjectImpl> iterator = ProjectList.getInstance().getProjectIterator();
        while (iterator.hasNext()) {
            Iterator<CTaskImpl> iterator2 = iterator.next().getTaskIterator();
            while (iterator2.hasNext()) {
                this.addTask(iterator2.next());
            }
        }
    }

    public void removeTask(CTaskImpl cTaskImpl) {
        this.m_oTasks.remove(cTaskImpl);
    }

    public void removeProject(CProjectImpl cProjectImpl) {
        Iterator<CTaskImpl> iterator = cProjectImpl.getTaskIterator();
        while (iterator.hasNext()) {
            this.removeTask(iterator.next());
        }
    }

    public boolean containsTask(CTaskImpl cTaskImpl) {
        return this.m_oTasks.contains(cTaskImpl);
    }

    public Iterator<CTaskImpl> getTaskIterator() {
        return this.m_oTasks.iterator();
    }

    public Iterator<CPersonImpl> getPersonIterator() {
        return this.m_oPersons.iterator();
    }

    public void addPerson(CPersonImpl cPersonImpl) {
        this.m_oPersons.add(cPersonImpl);
    }

    public void addAllPersons() {
        this.m_oPersons.addAll(ObjectFactoryImpl.getPersonList());
    }

    public void removePerson(CPersonImpl cPersonImpl) {
        this.m_oPersons.remove(cPersonImpl);
    }

    public Calendar getStart() {
        return this.m_oStart;
    }

    public void setStart(Calendar calendar) {
        this.m_oStart = calendar;
        if (this.m_oStart == null) {
            this.m_oComparableLeft = null;
            return;
        }
        this.m_oComparableLeft = CEffortImpl.createComparableEffort(this.m_oStart, true);
        this.m_lStart = this.m_oStart.getTimeInMillis();
    }

    public void setStart(String string, String string2) {
        if (string.length() == 0) {
            this.setStart(null);
        } else if (string2.length() == 0) {
            Calendar calendar = DateTime.getCalendar(string);
            this.setStart(calendar);
        } else {
            Calendar calendar = DateTime.getCalendar(string, string2);
            this.setStart(calendar);
        }
    }

    public Calendar getEnd() {
        return this.m_oEnd;
    }

    public void setEnd(Calendar calendar) {
        this.m_oEnd = calendar;
        if (this.m_oEnd == null) {
            this.m_oComparableRight = null;
            return;
        }
        this.m_oComparableRight = CEffortImpl.createComparableEffort(this.m_oEnd, false);
        this.m_lEnd = this.m_oEnd.getTimeInMillis();
    }

    public void setEnd(String string, String string2) {
        if (string.length() == 0) {
            this.setEnd(null);
        } else if (string2.length() == 0) {
            Calendar calendar = DateTime.getCalendar(string);
            calendar.add(6, 1);
            calendar.add(14, -1);
            this.setEnd(calendar);
        } else {
            Calendar calendar = DateTime.getCalendar(string, string2);
            calendar.add(12, 1);
            calendar.add(14, -1);
            this.setEnd(calendar);
        }
    }

    public boolean getDataMaskBit(int n) {
        if (n >= 0 && n < 6) {
            return DataMask.getBit(this.m_iDataMask, n);
        }
        LOGGER.error("{}#getDataMaskBit: p_iBitPosition < 0 | p_iBitPosition >= BIT_COUNT", (Object)this.getClass().getName());
        return false;
    }

    public void setDataMaskBit(int n, boolean bl) {
        if (n >= 0 && n < 6) {
            this.m_iDataMask = (short)DataMask.setBit(this.m_iDataMask, n, bl);
        } else {
            LOGGER.error("{}#setDataMaskBit: p_iBitPosition < 0 | p_iBitPosition >= BIT_COUNT", (Object)this.getClass().getName());
        }
    }

    public boolean getRelevantMaskBit(int n) {
        if (n >= 0 && n < 6) {
            return DataMask.getBit(this.m_iRelevantMask, n);
        }
        LOGGER.error("{}#getDataMaskBit: p_iBitPosition < 0 | p_iBitPosition >= BIT_COUNT", (Object)this.getClass().getName());
        return false;
    }

    public void setRelevantMaskBit(int n, boolean bl) {
        if (n >= 0 && n < 6) {
            this.m_iRelevantMask = (short)DataMask.setBit(this.m_iRelevantMask, n, bl);
        } else {
            LOGGER.error("{}#setDataMaskBit: p_iBitPosition < 0 | p_iBitPosition >= BIT_COUNT", (Object)this.getClass().getName());
        }
    }

    public String getSearchString() {
        return StringFunctions.readNullString(this.m_strSearchString);
    }

    public void setSearchString(String string) {
        this.m_strSearchString = StringFunctions.storeNullString(string);
    }

    public CEffortImpl getComparableLeft() {
        return this.m_oComparableLeft;
    }

    public CEffortImpl getComparableRight() {
        return this.m_oComparableRight;
    }

    public void setColidingReference(CEffortImpl cEffortImpl) {
        this.m_oCollidingReference = cEffortImpl;
    }

    public boolean isColidingReferenceSet() {
        return this.m_oCollidingReference != null;
    }

    public boolean isReferenceColidingWith(CEffortImpl cEffortImpl) {
        return this.isColidingReferenceSet() && (cEffortImpl == this.m_oCollidingReference || this.m_oCollidingReference.containsCollidator(cEffortImpl));
    }

    public abstract void addAllCategories();

    public abstract void addCategoriesOfProject(CProjectImpl var1);

    public abstract void removeCategoriesOfProject(CProjectImpl var1);

    public abstract boolean containsMappedCategory(CategoryList.CCategory var1, CProjectImpl var2);

    public boolean containsPerson(CPersonImpl cPersonImpl) {
        if (cPersonImpl != null) {
            return this.m_oPersons.contains(cPersonImpl);
        }
        return false;
    }

    public boolean isDurationIncluded(long l, long l2) {
        boolean bl = false;
        bl = this.m_oStart != null ? (this.m_oEnd != null ? l - this.m_lStart >= 0L && this.m_lEnd - l2 >= 0L : l - this.m_lStart >= 0L) : (this.m_oEnd != null ? this.m_lEnd - l2 >= 0L : true);
        return bl;
    }

    public boolean isCurrentMaskIncluded(short s) {
        return DataMask.passesFilter(s, this.m_iDataMask, this.m_iRelevantMask);
    }

    public boolean containsSearchString(String string) {
        if (this.m_strSearchString != null && this.m_strSearchString.length() > 0) {
            return string.contains(this.m_strSearchString);
        }
        return true;
    }

    public AFilter clone() {
        AFilter aFilter = this.cloneFilterAndCategories();
        aFilter.m_bUseThisFilter = this.m_bUseThisFilter;
        aFilter.m_oTasks.addAll(this.m_oTasks);
        aFilter.m_oPersons.addAll(this.m_oPersons);
        if (this.m_oStart == null) {
            aFilter.setStart(null);
        } else {
            aFilter.setStart((Calendar)this.m_oStart.clone());
        }
        if (this.m_oEnd == null) {
            aFilter.setEnd(null);
        } else {
            aFilter.setEnd((Calendar)this.m_oEnd.clone());
        }
        aFilter.m_iDataMask = this.m_iDataMask;
        aFilter.m_iRelevantMask = this.m_iRelevantMask;
        aFilter.m_strSearchString = this.m_strSearchString;
        aFilter.m_oCollidingReference = this.m_oCollidingReference;
        return aFilter;
    }

    protected abstract AFilter cloneFilterAndCategories();

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        if (this instanceof CTasksInTreeFilter) {
            cSimpleXMLStream.addAttribute(XML_ATT_FILTERMODE, XML_VAL_FILTERMODE_TASKS);
        } else {
            cSimpleXMLStream.addAttribute(XML_ATT_FILTERMODE, XML_VAL_FILTERMODE_CATEGORIES);
        }
        cSimpleXMLStream.addAttribute(XML_ATT_USE_FILTER, String.valueOf(this.m_bUseThisFilter));
        if (this.m_oStart != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_START, DateTime.getXMLDateTime(this.m_oStart));
        }
        if (this.m_oEnd != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_END, DateTime.getXMLDateTime(this.m_oEnd));
        }
        cSimpleXMLStream.addAttribute(XML_ATT_DATAMASK, String.valueOf(this.m_iDataMask));
        cSimpleXMLStream.addAttribute(XML_ATT_RELEVANTMASK, String.valueOf(this.m_iRelevantMask));
        if (this.m_strSearchString != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_SEARCHSTRING, this.m_strSearchString);
        }
        if (this.m_oCollidingReference != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_COLLIDING_EFFORT_ID, this.m_oCollidingReference.getID());
        }
        cSimpleXMLStream.startElement(XML_TASKS_TAG_NAME);
        Iterator<CTaskImpl> iterator = this.m_oTasks.iterator();
        while (iterator.hasNext()) {
            cSimpleXMLStream.startElement(XML_TASK_TAG_NAME);
            cSimpleXMLStream.addAttribute("id", iterator.next().getID());
            cSimpleXMLStream.endElement(XML_TASK_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_TASKS_TAG_NAME);
        cSimpleXMLStream.startElement(XML_PERSONS_TAG_NAME);
        Iterator<CPersonImpl> iterator2 = this.m_oPersons.iterator();
        while (iterator2.hasNext()) {
            cSimpleXMLStream.startElement(XML_PERSON_TAG_NAME);
            cSimpleXMLStream.addAttribute("id", iterator2.next().getID());
            cSimpleXMLStream.endElement(XML_PERSON_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_PERSONS_TAG_NAME);
        cSimpleXMLStream.startElement(XML_CATEGORIES_TAG_NAME);
        this.xmlizeCategories(cSimpleXMLStream);
        cSimpleXMLStream.endElement(XML_CATEGORIES_TAG_NAME);
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    protected abstract void xmlizeCategories(CSimpleXMLStream var1) throws CSimpleXMLStream.XmlWriteException;

    public String toString() {
        String string = "-";
        if (this.m_oStart != null) {
            string = DateTime.getDateString(this.m_oStart) + " " + DateTime.getTimeString(this.m_oStart);
        }
        String string2 = "-";
        if (this.m_oEnd != null) {
            string2 = DateTime.getDateString(this.m_oEnd) + " " + DateTime.getTimeString(this.m_oEnd);
        }
        return "start: " + string + "\n" + "end:  " + string2 + "\n" + "activated:" + this.m_bUseThisFilter + "\n" + "tasks: " + this.m_oTasks + "\npersons: " + this.m_oPersons + "\n" + "rel:  " + Integer.toBinaryString(this.m_iRelevantMask) + "\n" + "data: " + Integer.toBinaryString(this.m_iDataMask);
    }

    public static AFilter createEmptyFilter(CProjectTree.ETreeType eTreeType) {
        switch (eTreeType) {
            case ShowTasks: {
                return new CTasksInTreeFilter();
            }
            case ShowCategories: {
                return new CCategoriesInTreeFilter();
            }
        }
        return null;
    }

    public static AFilter createDefaultFilter(CProjectTree.ETreeType eTreeType) {
        AFilter aFilter = null;
        switch (eTreeType) {
            case ShowTasks: {
                aFilter = new CTasksInTreeFilter();
                break;
            }
            case ShowCategories: {
                aFilter = new CCategoriesInTreeFilter();
                break;
            }
            default: {
                throw new CFredRuntimeException((Object)((Object)eTreeType) + " unknown");
            }
        }
        if (DefaultTask.isSet()) {
            aFilter.addTask(DefaultTask.get());
            aFilter.setDefaultCategories(DefaultTask.get());
        }
        aFilter.addPerson(MainController.getInstance().getUser());
        aFilter.setRelevantMaskBit(5, true);
        aFilter.setDataMaskBit(5, true);
        aFilter.setRelevantMaskBit(4, false);
        aFilter.setDataMaskBit(4, false);
        aFilter.setRelevantMaskBit(3, false);
        aFilter.setDataMaskBit(3, false);
        aFilter.setRelevantMaskBit(2, false);
        aFilter.setDataMaskBit(2, false);
        aFilter.setRelevantMaskBit(1, true);
        aFilter.setDataMaskBit(1, true);
        aFilter.setRelevantMaskBit(0, true);
        aFilter.setDataMaskBit(0, true);
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(2, -1);
        aFilter.setStart(calendar2);
        aFilter.setEnd(calendar);
        return aFilter;
    }

    private static class CMappedCategoryContainer
    extends AChildlessXMLObjectContainer<CCategoryProjectMapper> {
        @Override
        protected CCategoryProjectMapper createContainedObject(Attributes attributes, int n) {
            int n2 = Integer.parseInt(attributes.getValue("id"));
            CategoryList.CCategory cCategory = CategoryList.getCategoryByID(n2);
            String string = attributes.getValue(AFilter.XML_ATT_CATEGORY_PROJECT_ID);
            CProjectImpl cProjectImpl = ObjectFactoryImpl.createProjectImpl(string);
            return new CCategoryProjectMapper(cCategory, cProjectImpl);
        }
    }

    private static class CCategoryContainer
    extends AChildlessXMLObjectContainer<CategoryList.CCategory> {
        @Override
        protected CategoryList.CCategory createContainedObject(Attributes attributes, int n) {
            int n2 = Integer.parseInt(attributes.getValue("id"));
            return CategoryList.getCategoryByID(n2);
        }
    }

    private static class CCategoriesContainer
    extends ADummyXMLObjectContainer {
        private static final CCategoryContainer CATEGORY_CONTAINER = new CCategoryContainer();
        private static final CMappedCategoryContainer MAPPED_CATEGORY_CONTAINER = new CMappedCategoryContainer();
        private CTasksInTreeFilter m_oTargetTaskFilter;
        private CCategoriesInTreeFilter m_oTargetCategoryFilter;

        public void reset(AFilter aFilter) {
            if (aFilter instanceof CTasksInTreeFilter) {
                this.m_oTargetTaskFilter = (CTasksInTreeFilter)aFilter;
                this.m_oTargetCategoryFilter = null;
            } else {
                this.m_oTargetTaskFilter = null;
                this.m_oTargetCategoryFilter = (CCategoriesInTreeFilter)aFilter;
            }
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(AFilter.XML_CATEGORY1_TAG_NAME)) {
                return CATEGORY_CONTAINER;
            }
            if (string.equals(AFilter.XML_CATEGORY2_TAG_NAME)) {
                return MAPPED_CATEGORY_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(AFilter.XML_CATEGORY1_TAG_NAME)) {
                this.m_oTargetTaskFilter.addCategory((CategoryList.CCategory)object);
            } else if (string.equals(AFilter.XML_CATEGORY2_TAG_NAME)) {
                CCategoryProjectMapper cCategoryProjectMapper = (CCategoryProjectMapper)object;
                this.m_oTargetCategoryFilter.addCategoryOfProject(cCategoryProjectMapper.getCategory(), cCategoryProjectMapper.getProject());
            }
        }
    }

    private static class CPersonContainer
    extends AChildlessXMLObjectContainer<CPersonImpl> {
        @Override
        protected CPersonImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            return ObjectFactoryImpl.createPersonImpl(string);
        }
    }

    private static class CPersonsContainer
    extends ADummyXMLObjectContainer {
        private static final CPersonContainer PERSON_CONTAINER = new CPersonContainer();
        private AFilter m_oTargetFilter;

        public void reset(AFilter aFilter) {
            this.m_oTargetFilter = aFilter;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(AFilter.XML_PERSON_TAG_NAME)) {
                return PERSON_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(AFilter.XML_PERSON_TAG_NAME)) {
                this.m_oTargetFilter.addPerson((CPersonImpl)object);
            }
        }
    }

    private static class CTaskContainer
    extends AChildlessXMLObjectContainer<CTaskImpl> {
        @Override
        protected CTaskImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue("id");
            return ObjectFactoryImpl.createTaskImpl(string);
        }
    }

    private static class CTasksContainer
    extends ADummyXMLObjectContainer {
        private static final CTaskContainer TASK_CONTAINER = new CTaskContainer();
        private AFilter m_oTargetFilter;

        public void reset(AFilter aFilter) {
            this.m_oTargetFilter = aFilter;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(AFilter.XML_TASK_TAG_NAME)) {
                return TASK_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(AFilter.XML_TASK_TAG_NAME)) {
                this.m_oTargetFilter.addTask((CTaskImpl)object);
            }
        }
    }

    public static class CFilterContainer
    extends AXMLObjectContainer<AFilter> {
        private static final CTasksContainer TASKS_CONTAINER = new CTasksContainer();
        private static final CPersonsContainer PERSONS_CONTAINER = new CPersonsContainer();
        private static final CCategoriesContainer CATEGORIES_CONTAINER = new CCategoriesContainer();

        @Override
        protected AFilter createContainedObject(Attributes attributes, int n) {
            String string;
            AFilter aFilter = null;
            String string2 = attributes.getValue(AFilter.XML_ATT_FILTERMODE);
            if (string2.equals(AFilter.XML_VAL_FILTERMODE_TASKS)) {
                aFilter = new CTasksInTreeFilter();
            } else if (string2.equals(AFilter.XML_VAL_FILTERMODE_CATEGORIES)) {
                aFilter = new CCategoriesInTreeFilter();
            } else {
                throw new CFredRuntimeException(string2 + " unknown");
            }
            aFilter.setUseThisFilter(Boolean.parseBoolean(attributes.getValue(AFilter.XML_ATT_USE_FILTER)));
            String string3 = attributes.getValue(AFilter.XML_ATT_START);
            if (string3 != null && string3.length() > 0) {
                aFilter.setStart(DateTime.parseXMLDateTime(string3));
            }
            if ((string = attributes.getValue(AFilter.XML_ATT_END)) != null && string.length() > 0) {
                aFilter.setEnd(DateTime.parseXMLDateTime(string));
            }
            aFilter.m_iDataMask = Integer.parseInt(attributes.getValue(AFilter.XML_ATT_DATAMASK));
            aFilter.m_iRelevantMask = Integer.parseInt(attributes.getValue(AFilter.XML_ATT_RELEVANTMASK));
            aFilter.setSearchString(attributes.getValue(AFilter.XML_ATT_SEARCHSTRING));
            String string4 = attributes.getValue(AFilter.XML_ATT_COLLIDING_EFFORT_ID);
            if (string4 != null) {
                aFilter.setColidingReference(ObjectFactoryImpl.createEffortImpl(string4));
            }
            return aFilter;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(AFilter.XML_TASKS_TAG_NAME)) {
                TASKS_CONTAINER.reset((AFilter)this.getContainedObject());
                return TASKS_CONTAINER;
            }
            if (string.equals(AFilter.XML_PERSONS_TAG_NAME)) {
                PERSONS_CONTAINER.reset((AFilter)this.getContainedObject());
                return PERSONS_CONTAINER;
            }
            if (string.equals(AFilter.XML_CATEGORIES_TAG_NAME)) {
                CATEGORIES_CONTAINER.reset((AFilter)this.getContainedObject());
                return CATEGORIES_CONTAINER;
            }
            return null;
        }
    }

    public static enum EFilterMode {
        NoFilter,
        FullFilter,
        TaskFilter,
        CategoryFilter,
        CollidingFilter;

    }

    public static class CCategoryProjectMapper
    implements Comparable<CCategoryProjectMapper> {
        private final CategoryList.CCategory m_oCategory;
        private final CProjectImpl m_oProject;

        public CCategoryProjectMapper(CategoryList.CCategory cCategory, CProjectImpl cProjectImpl) {
            this.m_oCategory = cCategory;
            this.m_oProject = cProjectImpl;
        }

        public CategoryList.CCategory getCategory() {
            return this.m_oCategory;
        }

        public CProjectImpl getProject() {
            return this.m_oProject;
        }

        @Override
        public int compareTo(CCategoryProjectMapper cCategoryProjectMapper) {
            if (this.m_oCategory == cCategoryProjectMapper.m_oCategory) {
                return this.m_oProject.compareTo(cCategoryProjectMapper.m_oProject);
            }
            return this.m_oCategory.getIndex() - cCategoryProjectMapper.m_oCategory.getIndex();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CCategoryProjectMapper)) {
                return false;
            }
            CCategoryProjectMapper cCategoryProjectMapper = (CCategoryProjectMapper)object;
            return this.m_oCategory == cCategoryProjectMapper.m_oCategory && this.m_oProject == cCategoryProjectMapper.m_oProject;
        }
    }

    public static class CCategoriesInTreeFilter
    extends AFilter {
        private final TreeSet<CCategoryProjectMapper> m_oMappedCategories = new TreeSet();
        private final TreeSet<CProjectImpl> m_oContainedProjects = new TreeSet();

        void addCategoryOfProject(CategoryList.CCategory cCategory, CProjectImpl cProjectImpl) {
            this.m_oMappedCategories.add(new CCategoryProjectMapper(cCategory, cProjectImpl));
            this.m_oContainedProjects.add(cProjectImpl);
        }

        @Override
        public void addAllCategories() {
            Iterator<CProjectImpl> iterator = ProjectList.getInstance().getProjectIterator();
            while (iterator.hasNext()) {
                this.addCategoriesOfProject(iterator.next());
            }
        }

        @Override
        public void addCategoriesOfProject(CProjectImpl cProjectImpl) {
            for (int i = 0; i < CategoryList.getCategoryCount(); ++i) {
                this.addCategoryOfProject(CategoryList.getCategory(i), cProjectImpl);
            }
        }

        @Override
        public void addTreePaths(TreePath[] treePathArray) {
            this.m_oMappedCategories.clear();
            this.m_oContainedProjects.clear();
            if (treePathArray == null) {
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof CProjectImpl) {
                    this.addCategoriesOfProject((CProjectImpl)object);
                    continue;
                }
                if (object instanceof CategoryList.CCategory) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    CProjectImpl cProjectImpl = (CProjectImpl)defaultMutableTreeNode2.getUserObject();
                    this.addCategoryOfProject((CategoryList.CCategory)object, cProjectImpl);
                    continue;
                }
                if (object instanceof CTaskImpl) {
                    throw new CFredRuntimeException("no Tasks in Treepath expected!");
                }
                if (object == CProjectTree.ROOT_NODE_NAME) {
                    this.addAllCategories();
                    continue;
                }
                LOGGER.error("{}#addTreePaths: p_oSelected is unknown type: {}", (Object)this.getClass().getName(), (Object)object.getClass().getName());
            }
        }

        public Iterator<CProjectImpl> getProjectIterator() {
            return this.m_oContainedProjects.iterator();
        }

        @Override
        public boolean containsMappedCategory(CategoryList.CCategory cCategory, CProjectImpl cProjectImpl) {
            return this.m_oMappedCategories.contains(new CCategoryProjectMapper(cCategory, cProjectImpl));
        }

        @Override
        public void removeCategoriesOfProject(CProjectImpl cProjectImpl) {
            for (int i = 0; i < CategoryList.getCategoryCount(); ++i) {
                this.m_oMappedCategories.add(new CCategoryProjectMapper(CategoryList.getCategory(i), cProjectImpl));
            }
            this.m_oContainedProjects.remove(cProjectImpl);
        }

        @Override
        protected void setDefaultCategories(CTaskImpl cTaskImpl) {
            CProjectImpl cProjectImpl = cTaskImpl.getProject();
            this.addCategoriesOfProject(cProjectImpl);
        }

        @Override
        protected AFilter cloneFilterAndCategories() {
            CCategoriesInTreeFilter cCategoriesInTreeFilter = new CCategoriesInTreeFilter();
            cCategoriesInTreeFilter.m_oMappedCategories.addAll(this.m_oMappedCategories);
            cCategoriesInTreeFilter.m_oContainedProjects.addAll(this.m_oContainedProjects);
            return cCategoriesInTreeFilter;
        }

        @Override
        protected void xmlizeCategories(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            for (CCategoryProjectMapper cCategoryProjectMapper : this.m_oMappedCategories) {
                cSimpleXMLStream.startElement(AFilter.XML_CATEGORY2_TAG_NAME);
                cSimpleXMLStream.addAttribute("id", String.valueOf(cCategoryProjectMapper.getCategory().getID()));
                cSimpleXMLStream.addAttribute(AFilter.XML_ATT_CATEGORY_PROJECT_ID, cCategoryProjectMapper.getProject().getID());
                cSimpleXMLStream.endElement(AFilter.XML_CATEGORY2_TAG_NAME);
            }
        }
    }

    public static class CTasksInTreeFilter
    extends AFilter {
        private final boolean[] m_abCategory = new boolean[CategoryList.getCategoryCount()];

        public void addCategory(int n) {
            this.m_abCategory[n] = true;
        }

        @Override
        public void addAllCategories() {
            this.addCategoriesOfProject(null);
        }

        @Override
        public void addCategoriesOfProject(CProjectImpl cProjectImpl) {
            int n = CategoryList.getCategoryCount();
            for (int i = 0; i < n; ++i) {
                this.addCategory(i);
            }
        }

        public void addCategory(CategoryList.CCategory cCategory) {
            this.addCategory(cCategory.getIndex());
        }

        public void addTasksOfProject(CProjectImpl cProjectImpl) {
            Iterator<CTaskImpl> iterator = cProjectImpl.getTaskIterator();
            while (iterator.hasNext()) {
                ((AFilter)this).m_oTasks.add(iterator.next());
            }
        }

        @Override
        public void addTreePaths(TreePath[] treePathArray) {
            ((AFilter)this).m_oTasks.clear();
            if (treePathArray == null) {
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof CProjectImpl) {
                    this.addTasksOfProject((CProjectImpl)object);
                    continue;
                }
                if (object instanceof CTaskImpl) {
                    this.addTask((CTaskImpl)object);
                    continue;
                }
                if (object instanceof CategoryList.CCategory) {
                    throw new CFredRuntimeException("no Categories in Treepath expected!");
                }
                if (object == CProjectTree.ROOT_NODE_NAME) {
                    Iterator<CProjectImpl> iterator = ProjectList.getInstance().getProjectIterator();
                    while (iterator.hasNext()) {
                        this.addTasksOfProject(iterator.next());
                    }
                    continue;
                }
                LOGGER.error("{}#addTreePaths: p_oSelected is unknown type: {}", (Object)this.getClass().getName(), (Object)object.getClass().getName());
            }
        }

        public boolean[] getCategories() {
            boolean[] blArray = new boolean[this.m_abCategory.length];
            System.arraycopy(this.m_abCategory, 0, blArray, 0, this.m_abCategory.length);
            return blArray;
        }

        @Override
        public boolean containsMappedCategory(CategoryList.CCategory cCategory, CProjectImpl cProjectImpl) {
            return this.m_abCategory[cCategory.getIndex()];
        }

        @Override
        protected void setDefaultCategories(CTaskImpl cTaskImpl) {
            int n = CategoryList.getCategoryCount();
            for (int i = 0; i < n; ++i) {
                this.addCategory(i);
            }
        }

        @Override
        protected AFilter cloneFilterAndCategories() {
            CTasksInTreeFilter cTasksInTreeFilter = new CTasksInTreeFilter();
            System.arraycopy(this.m_abCategory, 0, cTasksInTreeFilter.m_abCategory, 0, this.m_abCategory.length);
            return cTasksInTreeFilter;
        }

        @Override
        protected void xmlizeCategories(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
            for (int i = 0; i < this.m_abCategory.length; ++i) {
                if (!this.m_abCategory[i]) continue;
                cSimpleXMLStream.startElement(AFilter.XML_CATEGORY1_TAG_NAME);
                cSimpleXMLStream.addAttribute("id", String.valueOf(CategoryList.getCategory(i).getID()));
                cSimpleXMLStream.endElement(AFilter.XML_CATEGORY1_TAG_NAME);
            }
        }

        @Override
        public void removeCategoriesOfProject(CProjectImpl cProjectImpl) {
        }
    }
}

