/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.resources.CEntry;
import com.mayastudios.fred.client.resources.CategoryList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class CStatistic
implements IXMLizable {
    public static final int FIELD_COUNT = 5;
    public static final int FIELD_EFFORT_COUNT = 0;
    public static final int FIELD_EFFORT_DURATION_SUM = 1;
    public static final int FIELD_REPLICATED_EFFORT_COUNT = 2;
    public static final int FIELD_ACCEPTED_EFFORT_COUNT = 3;
    public static final int FIELD_NOT_ACCEPTED_EFFORT_COUNT = 4;
    public static final String XML_TAG_NAME = "statistic";
    private static final String XML_ATT_EFFORT_COUNT = "effortcount";
    private static final String XML_ATT_EFFORT_DURATION_SUM = "effortdurationsum";
    private static final String XML_ATT_REPLICATED_EFFORT_COUNT = "replicatedeffortcount";
    private static final String XML_ATT_ACCEPTED_EFFORT_COUNT = "acceptedeffortcount";
    private static final String XML_ATT_NOT_ACCEPTED_EFFORT_COUNT = "notacceptedeffortcount";
    private static final String XML_EFFORTS_OF_PERSONS_TAG_NAME = "effortsofpersons";
    private static final String XML_EFFORTS_OF_PERSON_TAG_NAME = "effortsofperson";
    private static final String XML_EFFORTS_OF_CATEGORIES_TAG_NAME = "effortsofcategories";
    private static final String XML_EFFORTS_OF_CATEGORY_TAG_NAME = "effortsofcategory";
    private static final String XML_ATT_ID = "id";
    private static final String XML_ATT_COUNT = "count";
    private static final Logger LOGGER = LoggerFactory.getLogger(CStatistic.class);
    TreeMap<CPersonImpl, Integer> m_oEffortsOfPersons;
    int[] m_aiEffortsOfCategories;
    int[] m_aiStatisticField;
    private CStatistic m_oStatisticToInform;

    public CStatistic(CStatistic cStatistic) {
        this.m_oStatisticToInform = cStatistic;
        this.m_oEffortsOfPersons = new TreeMap();
        this.m_aiEffortsOfCategories = new int[CategoryList.getCategoryCount()];
        this.m_aiStatisticField = new int[5];
    }

    public boolean containsPerson(CPersonImpl cPersonImpl) {
        return this.m_oEffortsOfPersons.get(cPersonImpl) != null;
    }

    Integer getEffortsOfPerson(CPersonImpl cPersonImpl) {
        return this.m_oEffortsOfPersons.get(cPersonImpl);
    }

    public Iterator<CPersonImpl> getContainedPersons() {
        return this.m_oEffortsOfPersons.keySet().iterator();
    }

    public void updateEffortsOfPerson(CPersonImpl cPersonImpl, int n) {
        Integer n2 = this.m_oEffortsOfPersons.get(cPersonImpl);
        n2 = n2 == null ? new Integer(n) : new Integer(n2 + n);
        if (n2 > 0) {
            this.m_oEffortsOfPersons.put(cPersonImpl, n2);
        } else if (n2 == 0) {
            this.m_oEffortsOfPersons.remove(cPersonImpl);
        } else {
            LOGGER.error("{}#updateEffortsOfPerson: oInteger.intValue() < 0", (Object)this.getClass().getName());
        }
        if (this.m_oStatisticToInform != null) {
            this.m_oStatisticToInform.updateEffortsOfPerson(cPersonImpl, n);
        }
    }

    public boolean containsCategory(int n) {
        return this.m_aiEffortsOfCategories[n] > 0;
    }

    int getEffortsOfCategory(int n) {
        return this.m_aiEffortsOfCategories[n];
    }

    public boolean containsCategory(CategoryList.CCategory cCategory) {
        return this.containsCategory(cCategory.getIndex());
    }

    public boolean[] getUsedCategories() {
        boolean[] blArray = new boolean[this.m_aiEffortsOfCategories.length];
        for (int i = 0; i < this.m_aiEffortsOfCategories.length; ++i) {
            blArray[i] = this.m_aiEffortsOfCategories[i] > 0;
        }
        return blArray;
    }

    public void updateEffortsOfCategory(int n, int n2) {
        int n3 = n;
        this.m_aiEffortsOfCategories[n3] = this.m_aiEffortsOfCategories[n3] + n2;
        if (this.m_aiEffortsOfCategories[n] < 0) {
            LOGGER.error("{}#updateEffortsOfCategory: this.m_aiEffortsOfCategories[p_iCategoryIndex] < 0", (Object)this.getClass().getName());
        }
        if (this.m_oStatisticToInform != null) {
            this.m_oStatisticToInform.updateEffortsOfCategory(n, n2);
        }
    }

    public void updateEffortsOfCategory(CategoryList.CCategory cCategory, int n) {
        this.updateEffortsOfCategory(cCategory.getIndex(), n);
    }

    public int getFieldValue(int n) {
        if (n >= 0 && n < this.m_aiStatisticField.length) {
            return this.m_aiStatisticField[n];
        }
        LOGGER.error("{}#getFieldValue: p_iFieldIndex < 0 || p_iFieldIndex >= this.m_aiStatisticField.length; Use Constants!", (Object)this.getClass().getName());
        return 0;
    }

    public void updateFieldValue(int n, int n2) {
        if (n >= 0 && n < this.m_aiStatisticField.length) {
            int n3 = n;
            this.m_aiStatisticField[n3] = this.m_aiStatisticField[n3] + n2;
            if (this.m_aiStatisticField[n] < 0) {
                LOGGER.error("{}#updateFieldValue: this.m_aiStatisticField[{}] < 0", (Object)this.getClass().getName(), (Object)n);
            }
        } else {
            LOGGER.error("{}#updateFieldValue: p_iFieldIndex < 0 || p_iFieldIndex >= this.m_aiStatisticField.length; Use Constants!", (Object)this.getClass().getName());
        }
        if (this.m_oStatisticToInform != null) {
            this.m_oStatisticToInform.updateFieldValue(n, n2);
        }
    }

    public void addStatistic(CStatistic cStatistic) {
        if (cStatistic != null) {
            int n;
            for (Map.Entry<CPersonImpl, Integer> entry : cStatistic.m_oEffortsOfPersons.entrySet()) {
                this.updateEffortsOfPerson(entry.getKey(), entry.getValue());
            }
            for (n = 0; n < this.m_aiEffortsOfCategories.length; ++n) {
                this.updateEffortsOfCategory(n, cStatistic.m_aiEffortsOfCategories[n]);
            }
            for (n = 0; n < this.m_aiStatisticField.length; ++n) {
                this.updateFieldValue(n, cStatistic.m_aiStatisticField[n]);
            }
        }
    }

    public void subtractStatistic(CStatistic cStatistic) {
        if (cStatistic != null) {
            int n;
            for (Map.Entry<CPersonImpl, Integer> entry : cStatistic.m_oEffortsOfPersons.entrySet()) {
                this.updateEffortsOfPerson(entry.getKey(), -1 * entry.getValue());
            }
            for (n = 0; n < this.m_aiEffortsOfCategories.length; ++n) {
                this.updateEffortsOfCategory(n, -1 * cStatistic.m_aiEffortsOfCategories[n]);
            }
            for (n = 0; n < this.m_aiStatisticField.length; ++n) {
                this.updateFieldValue(n, -1 * cStatistic.m_aiStatisticField[n]);
            }
        }
    }

    public void setParentStatistic(CStatistic cStatistic) {
        this.m_oStatisticToInform = cStatistic;
    }

    public int estimateFittingEffortCount(AFilter aFilter, CTaskImpl cTaskImpl) {
        int n;
        Object object;
        AFilter aFilter2;
        if (cTaskImpl.getStatistic() != this) {
            throw new CFredRuntimeException("p_oStatisticOwner.getStatistic() != this");
        }
        int n2 = 0;
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            if (!aFilter.useThisFilter()) {
                return this.getFieldValue(0);
            }
            aFilter2 = (AFilter.CTasksInTreeFilter)aFilter;
            object = ((AFilter.CTasksInTreeFilter)aFilter2).getCategories();
            for (n = 0; n < this.m_aiEffortsOfCategories.length; ++n) {
                if (!object[n]) continue;
                n2 += this.m_aiEffortsOfCategories[n];
            }
        } else if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            aFilter2 = (AFilter.CCategoriesInTreeFilter)aFilter;
            object = cTaskImpl.getProject();
            for (n = 0; n < this.m_aiEffortsOfCategories.length; ++n) {
                if (!((AFilter.CCategoriesInTreeFilter)aFilter2).containsMappedCategory(CategoryList.getCategory(n), (CProjectImpl)object)) continue;
                n2 += this.m_aiEffortsOfCategories[n];
            }
            if (!aFilter.useThisFilter()) {
                return n2;
            }
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.m_aiStatisticField[0];
        if (aFilter.getRelevantMaskBit(1)) {
            n3 = aFilter.getDataMaskBit(1) && aFilter.getRelevantMaskBit(0) ? (aFilter.getDataMaskBit(0) ? this.m_aiStatisticField[3] : this.m_aiStatisticField[4]) : this.m_aiStatisticField[0] - this.m_aiStatisticField[3] - this.m_aiStatisticField[4];
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        Iterator<CPersonImpl> iterator = aFilter.getPersonIterator();
        while (iterator.hasNext()) {
            Integer n5 = this.m_oEffortsOfPersons.get(iterator.next());
            if (n5 == null) continue;
            n4 += n5.intValue();
        }
        if (n4 == 0) {
            return 0;
        }
        return Math.min(n3, Math.min(n4, n2));
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_EFFORT_COUNT, String.valueOf(this.getFieldValue(0)));
        cSimpleXMLStream.addAttribute(XML_ATT_EFFORT_DURATION_SUM, String.valueOf(this.getFieldValue(1)));
        cSimpleXMLStream.addAttribute(XML_ATT_REPLICATED_EFFORT_COUNT, String.valueOf(this.getFieldValue(2)));
        cSimpleXMLStream.addAttribute(XML_ATT_ACCEPTED_EFFORT_COUNT, String.valueOf(this.getFieldValue(3)));
        cSimpleXMLStream.addAttribute(XML_ATT_NOT_ACCEPTED_EFFORT_COUNT, String.valueOf(this.getFieldValue(4)));
        cSimpleXMLStream.startElement(XML_EFFORTS_OF_PERSONS_TAG_NAME);
        for (Map.Entry<CPersonImpl, Integer> entry : this.m_oEffortsOfPersons.entrySet()) {
            cSimpleXMLStream.startElement(XML_EFFORTS_OF_PERSON_TAG_NAME);
            cSimpleXMLStream.addAttribute(XML_ATT_ID, entry.getKey().getID());
            cSimpleXMLStream.addAttribute(XML_ATT_COUNT, entry.getValue().toString());
            cSimpleXMLStream.endElement(XML_EFFORTS_OF_PERSON_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_EFFORTS_OF_PERSONS_TAG_NAME);
        cSimpleXMLStream.startElement(XML_EFFORTS_OF_CATEGORIES_TAG_NAME);
        for (int i = 0; i < this.m_aiEffortsOfCategories.length; ++i) {
            cSimpleXMLStream.startElement(XML_EFFORTS_OF_CATEGORY_TAG_NAME);
            cSimpleXMLStream.addAttribute(XML_ATT_ID, String.valueOf(CategoryList.getCategory(i).getID()));
            cSimpleXMLStream.addAttribute(XML_ATT_COUNT, String.valueOf(this.m_aiEffortsOfCategories[i]));
            cSimpleXMLStream.endElement(XML_EFFORTS_OF_CATEGORY_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_EFFORTS_OF_CATEGORIES_TAG_NAME);
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    private static class CIntArrayKeeper {
        int[] m_oArray;
    }

    private static class CEffortsOfCategoryStoreContainer
    extends AChildlessXMLObjectContainer<CEntry<Integer, Integer>> {
        @Override
        protected CEntry<Integer, Integer> createContainedObject(Attributes attributes, int n) {
            Integer n2 = new Integer(attributes.getValue(CStatistic.XML_ATT_ID));
            Integer n3 = new Integer(attributes.getValue(CStatistic.XML_ATT_COUNT));
            return new CEntry<Integer, Integer>(n2, n3);
        }
    }

    private static class CEffortsOfCategoriesStoreContainer
    extends AXMLObjectContainer<CIntArrayKeeper> {
        private static final CEffortsOfCategoryStoreContainer EFFORTS_OF_CATEGORY_CONTAINER = new CEffortsOfCategoryStoreContainer();

        @Override
        protected CIntArrayKeeper createContainedObject(Attributes attributes, int n) {
            CIntArrayKeeper cIntArrayKeeper = new CIntArrayKeeper();
            cIntArrayKeeper.m_oArray = new int[CategoryList.getCategoryCount()];
            return cIntArrayKeeper;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_CATEGORY_TAG_NAME)) {
                return EFFORTS_OF_CATEGORY_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_CATEGORY_TAG_NAME)) {
                int n2;
                CEntry cEntry = (CEntry)object;
                int n3 = (Integer)cEntry.getKey();
                ((CIntArrayKeeper)this.m_oObject).m_oArray[CategoryList.getCategoryByID((int)n3).getIndex()] = n2 = ((Integer)cEntry.getValue()).intValue();
            }
        }
    }

    private static class CEffortsOfPersonStoreContainer
    extends AChildlessXMLObjectContainer<CEntry<CPersonImpl, Integer>> {
        @Override
        protected CEntry<CPersonImpl, Integer> createContainedObject(Attributes attributes, int n) {
            CPersonImpl cPersonImpl = ObjectFactoryImpl.createPersonImpl(attributes.getValue(CStatistic.XML_ATT_ID));
            Integer n2 = new Integer(attributes.getValue(CStatistic.XML_ATT_COUNT));
            return new CEntry<CPersonImpl, Integer>(cPersonImpl, n2);
        }
    }

    private static class CEffortsOfPersonsStoreContainer
    extends AXMLObjectContainer<TreeMap<CPersonImpl, Integer>> {
        private static final CEffortsOfPersonStoreContainer EFFORTS_OF_PERSON_CONTAINER = new CEffortsOfPersonStoreContainer();

        @Override
        protected TreeMap<CPersonImpl, Integer> createContainedObject(Attributes attributes, int n) {
            return new TreeMap<CPersonImpl, Integer>();
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_PERSON_TAG_NAME)) {
                return EFFORTS_OF_PERSON_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_PERSON_TAG_NAME)) {
                CEntry cEntry = (CEntry)object;
                CPersonImpl cPersonImpl = (CPersonImpl)cEntry.getKey();
                Integer n2 = (Integer)cEntry.getValue();
                ((TreeMap)this.m_oObject).put(cPersonImpl, n2);
            }
        }
    }

    public static class CStatisticStoreContainer
    extends AXMLObjectContainer<CStatistic> {
        private static final CEffortsOfPersonsStoreContainer EFFORTS_OF_PERSONS_CONTAINER = new CEffortsOfPersonsStoreContainer();
        private static final CEffortsOfCategoriesStoreContainer EFFORTS_OF_CATEGORIES_CONTAINER = new CEffortsOfCategoriesStoreContainer();

        @Override
        protected CStatistic createContainedObject(Attributes attributes, int n) {
            CStatistic cStatistic = new CStatistic(null);
            cStatistic.m_aiStatisticField[0] = Integer.parseInt(attributes.getValue(CStatistic.XML_ATT_EFFORT_COUNT));
            cStatistic.m_aiStatisticField[1] = Integer.parseInt(attributes.getValue(CStatistic.XML_ATT_EFFORT_DURATION_SUM));
            cStatistic.m_aiStatisticField[2] = Integer.parseInt(attributes.getValue(CStatistic.XML_ATT_REPLICATED_EFFORT_COUNT));
            cStatistic.m_aiStatisticField[3] = Integer.parseInt(attributes.getValue(CStatistic.XML_ATT_ACCEPTED_EFFORT_COUNT));
            cStatistic.m_aiStatisticField[4] = Integer.parseInt(attributes.getValue(CStatistic.XML_ATT_NOT_ACCEPTED_EFFORT_COUNT));
            return cStatistic;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_PERSONS_TAG_NAME)) {
                return EFFORTS_OF_PERSONS_CONTAINER;
            }
            if (string.equals(CStatistic.XML_EFFORTS_OF_CATEGORIES_TAG_NAME)) {
                return EFFORTS_OF_CATEGORIES_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(CStatistic.XML_EFFORTS_OF_PERSONS_TAG_NAME)) {
                ((CStatistic)this.m_oObject).m_oEffortsOfPersons = (TreeMap)object;
            } else if (string.equals(CStatistic.XML_EFFORTS_OF_CATEGORIES_TAG_NAME)) {
                ((CStatistic)this.m_oObject).m_aiEffortsOfCategories = ((CIntArrayKeeper)object).m_oArray;
            }
        }
    }
}

