/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.resources.Labels;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFunctions {
    public static final int MAX_NAME_LENGTH = 50;
    public static final int MAX_TASK_SHORT_NAME_LENGTH = 5;
    public static final int MAX_PERSON_SHORT_NAME_LENGTH = 5;
    private static final char QUOTATION_MARK = '\"';
    private static final String LINE_BREAK_TO_REPLACE = "\n";
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\n");
    private static final String LINE_BREAK_REPLACE_CSV = " ";
    private static final String LINE_BREAK_REPLACE_HTML = "<br>";
    private static final String YES_LABEL = Labels.get("YES", new Object[0]);
    private static final String NO_LABEL = Labels.get("NO", new Object[0]);

    public static String storeNullString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public static String readNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String getDeHTMLizedString(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            // empty if block
        }
        return string2;
    }

    public static String isNameValid(String string) {
        if (string == null || string.trim().length() == 0) {
            return Labels.get("WRONG_NAME_EMPTY", new Object[0]);
        }
        if (string.length() > 50) {
            return Labels.get("WRONG_NAME_LONG", 50);
        }
        return null;
    }

    public static String isTaskShortNameValid(String string) {
        if (string == null || string.trim().length() == 0) {
            return Labels.get("WRONG_SHORTNAME_EMPTY", new Object[0]);
        }
        if (string.length() > 5) {
            return Labels.get("WRONG_SHORTNAME_LONG", 5);
        }
        return null;
    }

    public static String isPersonShortNameValid(String string) {
        if (string == null || string.trim().length() == 0) {
            return Labels.get("WRONG_SHORTNAME_EMPTY", new Object[0]);
        }
        if (string.length() > 5) {
            return Labels.get("WRONG_SHORTNAME_LONG", 5);
        }
        return null;
    }

    public static void writeBoolean(Writer writer, boolean bl) throws IOException {
        writer.write(bl ? YES_LABEL : NO_LABEL);
    }

    public static void writeForCSVCell(Writer writer, String string) throws IOException {
        writer.write(34);
        if (string != null) {
            writer.write(string.replace("\"", "\"\""));
        }
        writer.write(34);
    }

    public static void writeCommentForHTML(Writer writer, String string) throws IOException {
        Matcher matcher = LINE_BREAK_PATTERN.matcher(string);
        writer.write(matcher.replaceAll(LINE_BREAK_REPLACE_HTML));
    }
}

