/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.servertuning;

import com.mayastudios.fred.client.servertuning.CTunedEffort;
import com.mayastudios.fred.client.servertuning.CTunedObjectFactory;
import com.mayastudios.fred.client.servertuning.IEffortEx;
import com.mayastudios.fred.client.servertuning.IObjectFactoryEx;
import de.sopra06.domainmodel.ObjectFactory;
import de.sopra06.domainmodel.Person;
import de.sopra06.domainmodel.Project;
import de.sopra06.domainmodel.Task;
import de.sopra06.replication.ReplicationService;
import de.sopra06.replication.exceptions.ReplicationException;
import java.net.URL;
import java.util.Vector;

public class CReplicationServiceEx {
    private final ReplicationService mf_oReplicationService = new ReplicationService();
    private Vector<? extends IEffortEx> m_oSendEfforts = null;
    private Vector<IEffortEx> mf_oRecievedEfforts = null;
    private final CTunedObjectFactory mf_oObjectFactory = new CTunedObjectFactory();

    public CReplicationServiceEx() {
        this.mf_oReplicationService.setObjectFactory((ObjectFactory)this.mf_oObjectFactory);
    }

    public IObjectFactoryEx getObjectFactory() {
        return this.mf_oObjectFactory.getInnerFactory();
    }

    public void setObjectFactory(IObjectFactoryEx iObjectFactoryEx) {
        this.mf_oObjectFactory.setInnerFactory(iObjectFactoryEx);
    }

    public URL getURL() {
        return this.mf_oReplicationService.getURL();
    }

    public void setURL(URL uRL) {
        this.mf_oReplicationService.setURL(uRL);
    }

    public void sendNewProject() throws ReplicationException {
        this.mf_oReplicationService.sendNewProject();
    }

    public void sendNewTasks() throws ReplicationException {
        this.mf_oReplicationService.sendNewTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendNewEfforts() throws ReplicationException {
        Vector<? extends IEffortEx> vector = this.m_oSendEfforts;
        synchronized (vector) {
            if (this.m_oSendEfforts == null || this.m_oSendEfforts.size() < 1) {
                throw new ReplicationException("You have to send at least one effort!");
            }
            int n = this.m_oSendEfforts.size();
            Vector<CTunedEffort> vector2 = new Vector<CTunedEffort>(n);
            for (int i = 0; i < n; ++i) {
                vector2.add(new CTunedEffort(this.m_oSendEfforts.get(i)));
            }
            this.mf_oReplicationService.setEfforts(vector2);
        }
        this.mf_oReplicationService.sendNewEfforts();
    }

    public void receiveProjects() throws ReplicationException {
        this.mf_oReplicationService.receiveProjects();
    }

    public void receiveTasks() throws ReplicationException {
        this.mf_oReplicationService.receiveTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receiveEfforts() throws ReplicationException {
        this.mf_oReplicationService.receiveEfforts();
        Vector vector = this.mf_oReplicationService.getEfforts();
        int n = vector.size();
        Vector<IEffortEx> vector2 = this.mf_oRecievedEfforts = new Vector(n);
        synchronized (vector2) {
            for (int i = 0; i < n; ++i) {
                this.mf_oRecievedEfforts.add(((CTunedEffort)vector.get(i)).getInnerEffort());
            }
        }
        vector.clear();
    }

    public void closeProject() throws ReplicationException {
        this.mf_oReplicationService.closeProject();
    }

    public void setPersons(Vector<? extends Person> vector) {
        this.mf_oReplicationService.setPersons(vector);
    }

    public Vector<? extends Person> getPersons() {
        return this.mf_oReplicationService.getPersons();
    }

    public void setEfforts(Vector<? extends IEffortEx> vector) {
        this.m_oSendEfforts = vector;
    }

    public Vector<? extends IEffortEx> getEfforts() {
        return this.mf_oRecievedEfforts;
    }

    public void setTasks(Vector<? extends Task> vector) {
        this.mf_oReplicationService.setTasks(vector);
    }

    public Vector<? extends Task> getTasks() {
        return this.mf_oReplicationService.getTasks();
    }

    public void setProjects(Vector<? extends Project> vector) {
        this.mf_oReplicationService.setProjects(vector);
    }

    public Vector<? extends Project> getProjects() {
        return this.mf_oReplicationService.getProjects();
    }

    public int getStatus() {
        return this.mf_oReplicationService.getStatus();
    }
}

