/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.CViewController;
import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.textfields.CEmptyDateTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CEmptyTimeTextfield;
import de.wb.control.IValidable;
import de.wb.view.ComponentCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFilterPanel
extends JPanel
implements ActionListener {
    private static final Dimension FILTER_LABEL_SIZE = new Dimension(200, 18);
    private static final Color FILTER_LABEL_BACKGROUND = new Color(255, 247, 194);
    private static final Color FILTER_FRAME_COLOR = new Color(170, 170, 170);
    private static final Color FILTER_LABEL_ENABLED = Color.BLACK;
    private static final String FILTER_LABEL_ENABLED_TEXT = Labels.get("FILTERDIALOG_ENABLED_FILTER", new Object[0]);
    private static final ImageIcon FILTER_LABEL_ENABLED_ICON = MainController.getResLoader().getIcon("images/filter-icon-enabled.png");
    private static final Color FILTER_LABEL_DISABLED = new Color(18, 89, 188);
    private static final String FILTER_LABEL_DISABLED_TEXT = Labels.get("FILTERDIALOG_DISABLED_FILTER", new Object[0]);
    private static final ImageIcon FILTER_LABEL_DISABLED_ICON = MainController.getResLoader().getIcon("images/filter-icon-disabled.png");
    private static final int LEFT_MARGIN = 5;
    private static final int TOP_MARGIN = CFilterPanel.FILTER_LABEL_SIZE.height + 5;
    private static final Dimension PREFERRED_SIZE = new Dimension(740, 150 + TOP_MARGIN);
    private static final int ACCEPTEDPOSSIBILITY_YES = 0;
    private static final int ACCEPTEDPOSSIBILITY_NO = 1;
    private static final int ACCEPTEDPOSSIBILITY_NOTYET = 2;
    private static final int ACCEPTEDPOSSIBILITY_NA = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(CFilterPanel.class);
    private boolean m_bEnabled = false;
    private JLabel m_oFilterEnabledLabel = new JLabel();
    private JLabel m_oTaskCategoryLabel = null;
    private JLabel m_oSearchTimeErrorLabel = null;
    private JComboBox m_oAcceptedComboBox = null;
    private JList m_oTaskList = null;
    private JList m_oCategoryList = null;
    private JList m_oPersonList = null;
    private DefaultListModel m_oTaskListModel = null;
    private DefaultListModel m_oCategoryListModel = null;
    private DefaultListModel m_oPersonListModel = null;
    private JScrollPane m_oCurrentlyVisibleScrollPane = null;
    private JScrollPane m_oTaskScrollPane = null;
    private JScrollPane m_oCategoryScrollPane = null;
    private JScrollPane m_oPersonScrollPane = null;
    private JTextField m_oSearchTextField = null;
    private CEmptyDateTextfield m_oBeginDateTextfield = null;
    private CEmptyTimeTextfield m_oBeginTimeTextfield = null;
    private CEmptyDateTextfield m_oEndDateTextfield = null;
    private CEmptyTimeTextfield m_oEndTimeTextfield = null;
    private JButton m_oSubmitButton = null;
    private JButton m_oAbortButton = null;
    private JRadioButton m_oCompleteYesRadioButton = null;
    private JRadioButton m_oCompleteNoRadioButton = null;
    private JRadioButton m_oCompleteNARadioButton = null;
    private JRadioButton m_oErrorYesRadioButton = null;
    private JRadioButton m_oErrorNoRadioButton = null;
    private JRadioButton m_oErrorNARadioButton = null;
    private JRadioButton m_oIgnoredYesRadioButton = null;
    private JRadioButton m_oIgnoredNoRadioButton = null;
    private JRadioButton m_oIgnoredNARadioButton = null;
    private JRadioButton m_oReplicatedYesRadioButton = null;
    private JRadioButton m_oReplicatedNoRadioButton = null;
    private JRadioButton m_oReplicatedNARadioButton = null;
    private ButtonGroup m_oBGComplete = null;
    private ButtonGroup m_oBGError = null;
    private ButtonGroup m_oBGIgnored = null;
    private ButtonGroup m_oBGReplicated = null;
    private Vector<IValidable> m_oValidationList;
    private CViewController m_oViewController;
    private EListMode m_eListMode;

    public CFilterPanel(DefaultListModel defaultListModel, DefaultListModel defaultListModel2, DefaultListModel defaultListModel3, AFilter aFilter, CViewController cViewController) {
        this.m_oViewController = cViewController;
        this.m_oTaskListModel = defaultListModel;
        this.m_oCategoryListModel = defaultListModel2;
        this.m_oPersonListModel = defaultListModel3;
        super.setLayout(null);
        this.m_oValidationList = new Vector();
        super.setPreferredSize(PREFERRED_SIZE);
        this.createFilterLabel();
        this.createTaskCategoryShortName();
        this.createSearchTextfield();
        this.createBeginEndArea();
        this.createStateArea();
        this.createButtons();
        this.setFocusTraversalPolicy();
        this._enableFilterInternal(false);
        this.setFilter(aFilter);
    }

    public AFilter getFilter() {
        int n;
        AFilter aFilter = null;
        Object[] objectArray = null;
        switch (this.getListMode()) {
            case ShowTasks: {
                aFilter = new AFilter.CCategoriesInTreeFilter();
                objectArray = this.m_oTaskList.getSelectedValues();
                for (n = 0; n < objectArray.length; ++n) {
                    aFilter.addTask((CTaskImpl)objectArray[n]);
                }
                break;
            }
            case ShowCategories: {
                aFilter = new AFilter.CTasksInTreeFilter();
                objectArray = this.m_oCategoryList.getSelectedValues();
                for (n = 0; n < objectArray.length; ++n) {
                    ((AFilter.CTasksInTreeFilter)aFilter).addCategory((CategoryList.CCategory)objectArray[n]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown list mode: " + (Object)((Object)this.getListMode()));
            }
        }
        aFilter.setSearchString(this.m_oSearchTextField.getText());
        aFilter.setStart(this.m_oBeginDateTextfield.getText(), this.m_oBeginTimeTextfield.getText());
        aFilter.setEnd(this.m_oEndDateTextfield.getText(), this.m_oEndTimeTextfield.getText());
        switch (this.m_oAcceptedComboBox.getSelectedIndex()) {
            case 0: {
                aFilter.setRelevantMaskBit(1, true);
                aFilter.setRelevantMaskBit(0, true);
                aFilter.setDataMaskBit(1, true);
                aFilter.setDataMaskBit(0, true);
                break;
            }
            case 1: {
                aFilter.setRelevantMaskBit(1, true);
                aFilter.setRelevantMaskBit(0, true);
                aFilter.setDataMaskBit(1, true);
                aFilter.setDataMaskBit(0, false);
                break;
            }
            case 2: {
                aFilter.setRelevantMaskBit(1, true);
                aFilter.setRelevantMaskBit(0, false);
                aFilter.setDataMaskBit(1, false);
                break;
            }
            case 3: {
                aFilter.setRelevantMaskBit(1, false);
                aFilter.setRelevantMaskBit(0, false);
                break;
            }
        }
        if (this.m_oCompleteNARadioButton.isSelected()) {
            aFilter.setRelevantMaskBit(5, false);
        } else {
            aFilter.setRelevantMaskBit(5, true);
            aFilter.setDataMaskBit(5, this.m_oCompleteYesRadioButton.isSelected());
        }
        if (this.m_oReplicatedNARadioButton.isSelected()) {
            aFilter.setRelevantMaskBit(2, false);
        } else {
            aFilter.setRelevantMaskBit(2, true);
            aFilter.setDataMaskBit(2, this.m_oReplicatedYesRadioButton.isSelected());
        }
        if (this.m_oErrorNARadioButton.isSelected()) {
            aFilter.setRelevantMaskBit(4, false);
        } else {
            aFilter.setRelevantMaskBit(4, true);
            aFilter.setDataMaskBit(4, this.m_oErrorYesRadioButton.isSelected());
        }
        if (this.m_oIgnoredNARadioButton.isSelected()) {
            aFilter.setRelevantMaskBit(3, false);
        } else {
            aFilter.setRelevantMaskBit(3, true);
            aFilter.setDataMaskBit(3, this.m_oIgnoredYesRadioButton.isSelected());
        }
        objectArray = this.m_oPersonList.getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            aFilter.addPerson((CPersonImpl)objectArray[n]);
        }
        aFilter.setUseThisFilter(this.m_bEnabled);
        return aFilter;
    }

    private void _enableFilterInternal(boolean bl) {
        this.m_bEnabled = bl;
        if (bl) {
            this.m_oFilterEnabledLabel.setText(FILTER_LABEL_ENABLED_TEXT);
            this.m_oFilterEnabledLabel.setIcon(FILTER_LABEL_ENABLED_ICON);
            this.m_oFilterEnabledLabel.setForeground(FILTER_LABEL_ENABLED);
        } else {
            this.m_oFilterEnabledLabel.setText(FILTER_LABEL_DISABLED_TEXT);
            this.m_oFilterEnabledLabel.setIcon(FILTER_LABEL_DISABLED_ICON);
            this.m_oFilterEnabledLabel.setForeground(FILTER_LABEL_DISABLED);
        }
    }

    public boolean enableFilter(boolean bl) {
        if (bl && !this._checkFields()) {
            return false;
        }
        this._enableFilterInternal(bl);
        this.m_oViewController.incomingFilterRequest();
        return bl;
    }

    public void setFilter(AFilter aFilter) {
        Vector<CategoryList.CCategory> vector;
        Iterator<CPersonImpl> iterator = null;
        CPersonImpl cPersonImpl = null;
        int n = 0;
        boolean[] blArray = null;
        Vector<Integer> vector2 = null;
        int[] nArray = null;
        this.m_oPersonList.removeSelectionInterval(0, this.m_oCategoryList.getComponentCount() - 1);
        iterator = aFilter.getPersonIterator();
        while (iterator.hasNext()) {
            cPersonImpl = iterator.next();
            n = this.m_oPersonListModel.indexOf(cPersonImpl);
            if (n == -1) continue;
            this.m_oPersonList.addSelectionInterval(n, n);
        }
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            this.m_oCategoryList.removeSelectionInterval(0, this.m_oCategoryList.getComponentCount() - 1);
            blArray = ((AFilter.CTasksInTreeFilter)aFilter).getCategories();
            vector = new Vector<CategoryList.CCategory>();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                vector.add(CategoryList.getCategory(i));
            }
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                n = this.m_oCategoryListModel.indexOf(iterator2.next());
                if (n == -1) continue;
                this.m_oCategoryList.addSelectionInterval(n, n);
            }
            this.setListMode(EListMode.ShowCategories);
        } else if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            vector2 = new Vector<Integer>();
            vector = aFilter.getTaskIterator();
            while (vector.hasNext()) {
                CTaskImpl cTaskImpl = (CTaskImpl)vector.next();
                for (int i = 0; i < this.m_oTaskListModel.getSize(); ++i) {
                    if (this.m_oTaskListModel.getElementAt(i) != cTaskImpl) continue;
                    vector2.add(new Integer(i));
                }
            }
            nArray = new int[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                nArray[i] = (Integer)vector2.get(i);
            }
            this.m_oTaskList.setSelectedIndices(nArray);
            this.setListMode(EListMode.ShowTasks);
        }
        this.m_oSearchTextField.setText(aFilter.getSearchString());
        vector = aFilter.getStart();
        if (vector == null) {
            this.m_oBeginDateTextfield.setText("");
            this.m_oBeginTimeTextfield.setText("");
        } else {
            this.m_oBeginDateTextfield.setText(DateTime.getDateString(vector));
            this.m_oBeginTimeTextfield.setText(DateTime.getTimeString(vector));
        }
        Calendar calendar = aFilter.getEnd();
        if (calendar == null) {
            this.m_oEndDateTextfield.setText("");
            this.m_oEndTimeTextfield.setText("");
        } else {
            this.m_oEndDateTextfield.setText(DateTime.getDateString(calendar));
            this.m_oEndTimeTextfield.setText(DateTime.getTimeString(calendar));
        }
        if (!aFilter.getRelevantMaskBit(5)) {
            this.m_oCompleteNARadioButton.setSelected(true);
        } else if (aFilter.getDataMaskBit(5)) {
            this.m_oCompleteYesRadioButton.setSelected(true);
        } else {
            this.m_oCompleteNoRadioButton.setSelected(true);
        }
        if (!aFilter.getRelevantMaskBit(4)) {
            this.m_oErrorNARadioButton.setSelected(true);
        } else if (aFilter.getDataMaskBit(4)) {
            this.m_oErrorYesRadioButton.setSelected(true);
        } else {
            this.m_oErrorNoRadioButton.setSelected(true);
        }
        if (!aFilter.getRelevantMaskBit(3)) {
            this.m_oIgnoredNARadioButton.setSelected(true);
        } else if (aFilter.getDataMaskBit(3)) {
            this.m_oIgnoredYesRadioButton.setSelected(true);
        } else {
            this.m_oIgnoredNoRadioButton.setSelected(true);
        }
        if (!aFilter.getRelevantMaskBit(2)) {
            this.m_oReplicatedNARadioButton.setSelected(true);
        } else if (aFilter.getDataMaskBit(2)) {
            this.m_oReplicatedYesRadioButton.setSelected(true);
        } else {
            this.m_oReplicatedNoRadioButton.setSelected(true);
        }
        if (!aFilter.getRelevantMaskBit(1)) {
            this.m_oAcceptedComboBox.setSelectedIndex(3);
        } else if (!aFilter.getDataMaskBit(1)) {
            this.m_oAcceptedComboBox.setSelectedIndex(2);
        } else if (aFilter.getDataMaskBit(0)) {
            this.m_oAcceptedComboBox.setSelectedIndex(0);
        } else {
            this.m_oAcceptedComboBox.setSelectedIndex(1);
        }
        this._enableFilterInternal(aFilter.useThisFilter());
    }

    private void setListMode(EListMode eListMode) {
        this.m_eListMode = eListMode;
        this.m_oCurrentlyVisibleScrollPane.setVisible(false);
        switch (this.m_eListMode) {
            case ShowTasks: {
                this.m_oCurrentlyVisibleScrollPane = this.m_oTaskScrollPane;
                this.m_oTaskCategoryLabel.setText(Labels.get("TASKS", new Object[0]) + ":");
                break;
            }
            case ShowCategories: {
                this.m_oCurrentlyVisibleScrollPane = this.m_oCategoryScrollPane;
                this.m_oTaskCategoryLabel.setText(Labels.get("CATEGORIES", new Object[0]) + ":");
                break;
            }
        }
        this.m_oCurrentlyVisibleScrollPane.setVisible(true);
    }

    private EListMode getListMode() {
        return this.m_eListMode;
    }

    private void createFilterLabel() {
        MatteBorder matteBorder = BorderFactory.createMatteBorder(CFilterPanel.FILTER_LABEL_SIZE.height, 0, 0, 0, FILTER_LABEL_BACKGROUND);
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(1, 0, 0, 0, FILTER_FRAME_COLOR);
        this.setBorder(BorderFactory.createCompoundBorder(matteBorder, matteBorder2));
        this.m_oFilterEnabledLabel.setBounds(5, 0, CFilterPanel.FILTER_LABEL_SIZE.width, CFilterPanel.FILTER_LABEL_SIZE.height);
        this.add(this.m_oFilterEnabledLabel);
    }

    private void createTaskCategoryShortName() {
        this.m_oTaskCategoryLabel = this.m_eListMode == EListMode.ShowTasks ? ComponentCreator.createLabel(Labels.get("TASKS", new Object[0]), this, true, 5, TOP_MARGIN, 100, 20) : ComponentCreator.createLabel(Labels.get("CATEGORIES", new Object[0]), this, true, 5, TOP_MARGIN, 100, 20);
        this.m_oCategoryList = ComponentCreator.createListWithModel(this.m_oCategoryListModel);
        this.m_oCategoryList.setSelectionMode(2);
        this.m_oCategoryScrollPane = ComponentCreator.createScrollPane(this, this.m_oCategoryList, 5, TOP_MARGIN + 21, 120, 99);
        this.m_oCategoryScrollPane.setVisible(true);
        this.m_oCategoryScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oTaskList = ComponentCreator.createListWithModel(this.m_oTaskListModel);
        this.m_oTaskList.setSelectionMode(2);
        this.m_oTaskScrollPane = ComponentCreator.createScrollPane(this, this.m_oTaskList, 5, TOP_MARGIN + 21, 120, 99);
        this.m_oTaskScrollPane.setVisible(false);
        this.m_oTaskScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oCurrentlyVisibleScrollPane = this.m_oCategoryScrollPane;
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_PERSONS", new Object[0]), this, true, 130, TOP_MARGIN, 120, 20);
        this.m_oPersonList = ComponentCreator.createListWithModel(this.m_oPersonListModel);
        this.m_oPersonList.setSelectionMode(2);
        this.m_oPersonScrollPane = ComponentCreator.createScrollPane(this, this.m_oPersonList, 130, TOP_MARGIN + 21, 120, 99);
        this.m_oPersonScrollPane.setHorizontalScrollBarPolicy(30);
    }

    private void createSearchTextfield() {
        ComponentCreator.createLabel("Kommentarsuche", this, true, 5, TOP_MARGIN + 125, 120, 20);
        this.m_oSearchTextField = ComponentCreator.createTextField(this, 130, TOP_MARGIN + 125, 295, 20);
    }

    private void createBeginEndArea() {
        JPanel jPanel = null;
        jPanel = ComponentCreator.createBorderedPanel("Suchzeitraum - Begin", this, 253, TOP_MARGIN + 1, 175, 50);
        jPanel.setLayout(null);
        this.m_oBeginDateTextfield = ComponentCreator.createEmptyDateTextfield(jPanel, null, 10, 20, 75, 20);
        this.m_oBeginTimeTextfield = ComponentCreator.createEmptyTimeTextfield(jPanel, null, 95, 20, 70, 20);
        jPanel = ComponentCreator.createBorderedPanel("Suchzeitraum - Ende", this, 253, TOP_MARGIN + 72, 175, 50);
        jPanel.setLayout(null);
        this.m_oEndDateTextfield = ComponentCreator.createEmptyDateTextfield(jPanel, null, 10, 20, 75, 20);
        this.m_oEndTimeTextfield = ComponentCreator.createEmptyTimeTextfield(jPanel, null, 95, 20, 70, 20);
        this.m_oValidationList.add(this.m_oBeginDateTextfield);
        this.m_oValidationList.add(this.m_oBeginTimeTextfield);
        this.m_oValidationList.add(this.m_oEndDateTextfield);
        this.m_oValidationList.add(this.m_oEndTimeTextfield);
        this.m_oSearchTimeErrorLabel = ComponentCreator.createLabel("", this, false, 260, TOP_MARGIN + 50, 175, 20);
        this.m_oSearchTimeErrorLabel.setForeground(Color.RED);
    }

    private void createStateArea() {
        JPanel jPanel = null;
        jPanel = ComponentCreator.createBorderedPanel(Labels.get("FILTERDIALOG_STATES", new Object[0]), this, 435, TOP_MARGIN + 1, 300, 120);
        jPanel.setLayout(null);
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_APPROVED", new Object[0]), jPanel, true, 20, 15, 130, 20);
        this.m_oBGComplete = new ButtonGroup();
        this.m_oCompleteYesRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_YES", new Object[0]), jPanel, this.m_oBGComplete, 140, 15, 40, 20);
        this.m_oCompleteNoRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_NO", new Object[0]), jPanel, this.m_oBGComplete, 180, 15, 55, 20);
        this.m_oCompleteNARadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_IRRELEVANT", new Object[0]), jPanel, this.m_oBGComplete, 235, 15, 55, 20);
        this.m_oCompleteNARadioButton.setSelected(true);
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_COLLISION", new Object[0]), jPanel, true, 20, 35, 130, 20);
        this.m_oBGError = new ButtonGroup();
        this.m_oErrorYesRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_YES", new Object[0]), jPanel, this.m_oBGError, 140, 35, 40, 20);
        this.m_oErrorNoRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_NO", new Object[0]), jPanel, this.m_oBGError, 180, 35, 55, 20);
        this.m_oErrorNARadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_IRRELEVANT", new Object[0]), jPanel, this.m_oBGError, 235, 35, 55, 20);
        this.m_oErrorNARadioButton.setSelected(true);
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_IGNORE_COLLISION", new Object[0]), jPanel, true, 20, 55, 130, 20);
        this.m_oBGIgnored = new ButtonGroup();
        this.m_oIgnoredYesRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_YES", new Object[0]), jPanel, this.m_oBGIgnored, 140, 55, 40, 20);
        this.m_oIgnoredNoRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_NO", new Object[0]), jPanel, this.m_oBGIgnored, 180, 55, 55, 20);
        this.m_oIgnoredNARadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_IRRELEVANT", new Object[0]), jPanel, this.m_oBGIgnored, 235, 55, 55, 20);
        this.m_oIgnoredNARadioButton.setSelected(true);
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_REPLICATED", new Object[0]), jPanel, true, 20, 75, 130, 20);
        this.m_oBGReplicated = new ButtonGroup();
        this.m_oReplicatedYesRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_YES", new Object[0]), jPanel, this.m_oBGReplicated, 140, 75, 40, 20);
        this.m_oReplicatedNoRadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_NO", new Object[0]), jPanel, this.m_oBGReplicated, 180, 75, 55, 20);
        this.m_oReplicatedNARadioButton = ComponentCreator.createRadioButton(Labels.get("FILTERDIALOG_IRRELEVANT", new Object[0]), jPanel, this.m_oBGReplicated, 235, 75, 55, 20);
        this.m_oReplicatedNARadioButton.setSelected(true);
        ComponentCreator.createLabel(Labels.get("FILTERDIALOG_ACCEPTED", new Object[0]), jPanel, true, 20, 95, 130, 20);
        Vector<String> vector = new Vector<String>();
        vector.add(Labels.get("EACCEPTED_Accepted", new Object[0]));
        vector.add(Labels.get("EACCEPTED_NotAccepted", new Object[0]));
        vector.add(Labels.get("EACCEPTED_NotYetAccepted", new Object[0]));
        vector.add(Labels.get("FILTERDIALOG_IRRELEVANT", new Object[0]));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.m_oAcceptedComboBox = ComponentCreator.createComboBoxWithModel(jPanel, defaultComboBoxModel, 140, 95, 150, 20);
        this.m_oAcceptedComboBox.setSelectedIndex(3);
    }

    private void createButtons() {
        this.m_oSubmitButton = ComponentCreator.createButton(Labels.get("FILTERDIALOG_APPLY", new Object[0]), null, this, this, 435, TOP_MARGIN + 126, 147, 20);
        this.m_oAbortButton = ComponentCreator.createButton(Labels.get("FILTERDIALOG_RESET", new Object[0]), null, this, this, 586, TOP_MARGIN + 126, 147, 20);
    }

    private void setFocusTraversalPolicy() {
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.m_oTaskList);
        arrayList.add(this.m_oCategoryList);
        arrayList.add(this.m_oPersonList);
        arrayList.add(this.m_oBeginDateTextfield);
        arrayList.add(this.m_oBeginTimeTextfield);
        arrayList.add(this.m_oEndDateTextfield);
        arrayList.add(this.m_oEndTimeTextfield);
        arrayList.add(this.m_oSearchTextField);
        arrayList.add(this.m_oCompleteYesRadioButton);
        arrayList.add(this.m_oCompleteNoRadioButton);
        arrayList.add(this.m_oCompleteNARadioButton);
        arrayList.add(this.m_oErrorYesRadioButton);
        arrayList.add(this.m_oErrorNoRadioButton);
        arrayList.add(this.m_oErrorNARadioButton);
        arrayList.add(this.m_oIgnoredYesRadioButton);
        arrayList.add(this.m_oIgnoredNoRadioButton);
        arrayList.add(this.m_oIgnoredNARadioButton);
        arrayList.add(this.m_oReplicatedYesRadioButton);
        arrayList.add(this.m_oReplicatedNoRadioButton);
        arrayList.add(this.m_oReplicatedNARadioButton);
        arrayList.add(this.m_oAcceptedComboBox);
        arrayList.add(this.m_oSubmitButton);
        arrayList.add(this.m_oAbortButton);
        final int n = arrayList.size();
        FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){

            @Override
            public Component getFirstComponent(Container container) {
                return this._adjustTraversability(0, true);
            }

            @Override
            public Component getLastComponent(Container container) {
                return this._adjustTraversability(n - 1, false);
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int n2 = arrayList.indexOf(component);
                if (n2 == -1) {
                    return null;
                }
                return this._adjustTraversability((n2 + 1) % n, true);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int n2 = arrayList.indexOf(component);
                if (n2 == -1) {
                    return null;
                }
                return this._adjustTraversability((n2 - 1 + n) % n, false);
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return this._adjustTraversability(0, true);
            }

            @Override
            public Component getInitialComponent(Window window) {
                return this._adjustTraversability(0, true);
            }

            private Component _adjustTraversability(int n2, boolean bl) {
                Component component = (Component)arrayList.get(n2);
                if (!(!component.isVisible() || component == CFilterPanel.this.m_oTaskList && CFilterPanel.this.m_eListMode != EListMode.ShowTasks || component == CFilterPanel.this.m_oCategoryList && CFilterPanel.this.m_eListMode != EListMode.ShowCategories)) {
                    return component;
                }
                if (bl) {
                    return this._adjustTraversability((n2 + 1) % n, bl);
                }
                return this._adjustTraversability((n2 - 1 + n) % n, bl);
            }
        };
        super.setFocusTraversalPolicy(focusTraversalPolicy);
        super.setFocusCycleRoot(true);
    }

    private void resetFilterPanel() {
        if (this.m_oTaskListModel.getSize() > 0) {
            this.m_oTaskList.setSelectionInterval(0, this.m_oTaskListModel.getSize() - 1);
        }
        if (this.m_oCategoryListModel.getSize() > 0) {
            this.m_oCategoryList.setSelectionInterval(0, this.m_oCategoryListModel.getSize() - 1);
        }
        if (this.m_oPersonListModel.getSize() > 0) {
            this.m_oPersonList.setSelectionInterval(0, this.m_oPersonListModel.getSize() - 1);
        }
        this.m_oSearchTextField.setText("");
        this.m_oBeginDateTextfield.setText("");
        this.m_oBeginTimeTextfield.setText("");
        this.m_oEndDateTextfield.setText("");
        this.m_oEndTimeTextfield.setText("");
        this.m_oCompleteNARadioButton.setSelected(true);
        this.m_oErrorNARadioButton.setSelected(true);
        this.m_oIgnoredNARadioButton.setSelected(true);
        this.m_oReplicatedNARadioButton.setSelected(true);
        this.m_oAcceptedComboBox.setSelectedIndex(3);
        for (int i = 0; i < this.m_oValidationList.size(); ++i) {
            this.m_oValidationList.elementAt(i).highlightControl(false);
        }
        this.m_oSearchTimeErrorLabel.setText("");
    }

    private boolean _checkFields() {
        Calendar calendar = null;
        Calendar calendar2 = null;
        for (int i = 0; i < this.m_oValidationList.size(); ++i) {
            IValidable iValidable = this.m_oValidationList.elementAt(i);
            if (iValidable.evaluateContent()) continue;
            this.m_oSearchTimeErrorLabel.setText(Labels.get("FILTERDIALOG_INPUT_ERROR", new Object[0]));
            iValidable.highlightControl(true);
            return false;
        }
        if (this.m_oBeginDateTextfield.getText().length() > 0) {
            calendar = this.m_oBeginTimeTextfield.getText().length() == 0 ? DateTime.getCalendar(this.m_oBeginDateTextfield.getText()) : DateTime.getCalendar(this.m_oBeginDateTextfield.getText(), this.m_oBeginTimeTextfield.getText());
        }
        if (this.m_oEndDateTextfield.getText().length() > 0) {
            if (this.m_oEndTimeTextfield.getText().length() == 0) {
                calendar2 = DateTime.getCalendar(this.m_oEndDateTextfield.getText());
                calendar2.add(6, 1);
                calendar2.add(14, -1);
            } else {
                calendar2 = DateTime.getCalendar(this.m_oEndDateTextfield.getText(), this.m_oEndTimeTextfield.getText());
                calendar2.add(12, 1);
                calendar2.add(14, -1);
            }
        }
        if (calendar != null && calendar2 != null && calendar2.before(calendar)) {
            this.m_oSearchTimeErrorLabel.setText(Labels.get("FILTERDIALOG_SEARCHTIME_ERROR", new Object[0]));
            return false;
        }
        this.m_oSearchTimeErrorLabel.setText("");
        return true;
    }

    private void incomingSubmit() {
        if (this._checkFields()) {
            this.m_oViewController.incomingFilterRequest();
        } else {
            LOGGER.info("CFilterDialog - incomingSubmit() - _checkFields() == false");
        }
    }

    private void incomingAbort() {
        this.resetFilterPanel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_oSubmitButton) {
            this.incomingSubmit();
        } else if (actionEvent.getSource() == this.m_oAbortButton) {
            this.incomingAbort();
        }
    }

    public static enum EListMode {
        ShowTasks,
        ShowCategories;

    }
}

