/*
 * Decompiled with CFR 0.152.
 */
package net.mayastudios.mscl.mwt.trayicon;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class CTrayIcon {
    private final TrayIcon mf_oTrayIcon;
    private final CClickListener mf_oClickListener = new CClickListener();

    public CTrayIcon(Icon p_oIcon, String p_strCaption) {
        this(p_oIcon, p_strCaption, null);
    }

    public CTrayIcon(Icon p_oIcon, String p_strCaption, JPopupMenu p_oPopupMenu) {
        this.mf_oTrayIcon = new TrayIcon(p_oIcon, null, p_oPopupMenu);
        this.mf_oTrayIcon.setCaption(p_strCaption);
    }

    public void setVisible(boolean p_bShow) {
        if (p_bShow) {
            SystemTray.getDefaultSystemTray().addTrayIcon(this.mf_oTrayIcon);
        } else {
            SystemTray.getDefaultSystemTray().removeTrayIcon(this.mf_oTrayIcon);
        }
    }

    public void setIcon(Icon icon) {
        this.mf_oTrayIcon.setIcon(icon);
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.mf_oTrayIcon.setPopupMenu(popup);
    }

    public void setClickListener(ITrayIconClickListener p_oListener) {
        this.mf_oClickListener.setListener(p_oListener);
        if (p_oListener == null) {
            this.mf_oTrayIcon.removeActionListener(this.mf_oClickListener);
        } else {
            this.mf_oTrayIcon.addActionListener(this.mf_oClickListener);
        }
    }

    public void setCaption(String caption) {
        this.mf_oTrayIcon.setCaption(caption);
        this.mf_oTrayIcon.setToolTip(caption);
    }

    public void setIconAutoSize(boolean autosize) {
        this.mf_oTrayIcon.setIconAutoSize(autosize);
    }

    public Point getLocationOnScreen() {
        return this.mf_oTrayIcon.getLocationOnScreen();
    }

    private class CClickListener
    implements ActionListener {
        private ActionEvent m_oLastEvent = null;
        private Timer m_oTimer = new Timer(200, this);
        private ITrayIconClickListener m_oListener = null;

        public CClickListener() {
            this.m_oTimer.setRepeats(false);
        }

        public void setListener(ITrayIconClickListener p_oListener) {
            this.m_oListener = p_oListener;
        }

        public void actionPerformed(ActionEvent p_oEvent) {
            if (this.m_oLastEvent == null) {
                if (p_oEvent.getSource() == this.m_oTimer) {
                    return;
                }
                this.m_oLastEvent = p_oEvent;
                this.m_oTimer.start();
            } else {
                CTrayIconClickEvent oMouseEvent = new CTrayIconClickEvent(CTrayIcon.this, p_oEvent.getWhen(), this.m_oLastEvent.getModifiers(), p_oEvent.getSource() != this.m_oTimer);
                if (this.m_oListener != null) {
                    this.m_oLastEvent = null;
                    this.m_oListener.clickPerformed(oMouseEvent);
                }
            }
        }
    }

    public static interface ITrayIconClickListener {
        public void clickPerformed(CTrayIconClickEvent var1);
    }

    public static class CTrayIconClickEvent {
        public static final int DOUBLE_CLICK_DELAY = 200;
        public final CTrayIcon mf_oTrayIcon;
        public final long mf_lWhen;
        public final int mf_iModifiers;
        public final boolean mf_bIsDoubleClick;

        public CTrayIconClickEvent(CTrayIcon p_oTrayIcon, long p_lWhen, int p_iModifiers, boolean p_bIsDoubleClick) {
            this.mf_oTrayIcon = p_oTrayIcon;
            this.mf_lWhen = p_lWhen;
            this.mf_iModifiers = p_iModifiers;
            this.mf_bIsDoubleClick = p_bIsDoubleClick;
        }
    }
}

