/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

class Helpers {
    private Helpers() {
    }

    public static boolean doesFileExist(String string) {
        return new File(string).exists();
    }

    public static String[] readFile(String string) throws IOException {
        return Helpers.readFile(new File(string));
    }

    public static String[] readFile(File file) throws IOException {
        return Helpers.readFile(new FileInputStream(file));
    }

    public static String[] readFile(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder(1024);
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString().split("\n");
    }

    public static long determineTotalPhysicalMemory() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.OperatingSystemMXBean");
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            long l = (Long)clazz.getMethod("getTotalPhysicalMemorySize", new Class[0]).invoke((Object)operatingSystemMXBean, new Object[0]);
            if (l == Integer.MAX_VALUE) {
                return 0L;
            }
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<T1, T2> {
        private final T1 m_first;
        private final T2 m_second;

        public Pair(T1 T1, T2 T2) {
            this.m_first = T1;
            this.m_second = T2;
        }

        public T1 getFirst() {
            return this.m_first;
        }

        public T2 getSecond() {
            return this.m_second;
        }
    }
}

