/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.Helpers;
import com.mayastudios.systeminfo.SystemInfo;

public class UnknownSystemInfo
extends SystemInfo {
    private final String m_versionNumber = System.getProperty("os.version");
    private final long m_totalMemory = Helpers.determineTotalPhysicalMemory();

    UnknownSystemInfo() {
        super(UnknownSystemInfo.determineSystemArch());
    }

    private static SystemInfo.JavaArch determineSystemArch() {
        String string = System.getProperty("os.arch");
        if ("x86".equals(string) || string.matches("i\\d86")) {
            return SystemInfo.JavaArch.x86;
        }
        if ("x86_64".equals(string) || "amd64".equals(string)) {
            return SystemInfo.JavaArch.x64;
        }
        if ("ppc".equals(string)) {
            return SystemInfo.JavaArch.PowerPC;
        }
        if ("sparc".equals(string)) {
            return SystemInfo.JavaArch.Sparc;
        }
        return SystemInfo.JavaArch.Unknown;
    }

    public String getOsName() {
        return "Unknown (" + System.getProperty("os.name") + ")";
    }

    public String getSystemCodename() {
        return null;
    }

    public String getSystemVersionNumber() {
        return this.m_versionNumber;
    }

    public String getProcessorName() {
        return null;
    }

    public SystemInfo.SystemArch getSystemArch() {
        return SystemInfo.SystemArch.Unknown;
    }

    public long getTotalPhysicalMemorySize() {
        return this.m_totalMemory;
    }

    public String toString() {
        String string = this.getTotalPhysicalMemorySize() == 0L ? "unknown" : this.getTotalPhysicalMemorySize() / 1024L / 1024L + " MB";
        return "Operating System:  " + this.getOsName() + LINE_SEPERATOR + "OS Version:        " + this.m_versionNumber + LINE_SEPERATOR + "Total Memory:      " + string + LINE_SEPERATOR + "Java Architecture: " + (Object)((Object)this.getJavaArch());
    }
}

