/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpp;

import com.tapsterrock.mpp.MPPUtility;

public class SubProject {
    private Integer m_uniqueID;
    private String m_dosFullPath;
    private String m_fullPath;
    private String m_dosFileName;
    private String m_fileName;
    private int m_uniqueIDStartValue;

    public void read(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int uniqueIDStartValue) {
        this.m_uniqueIDStartValue = uniqueIDStartValue;
        if (uniqueIDOffset != -1) {
            this.m_uniqueID = new Integer(MPPUtility.getInt(data, uniqueIDOffset));
        }
        filePathOffset += 18;
        this.m_dosFullPath = MPPUtility.getString(data, filePathOffset += 4);
        filePathOffset += this.m_dosFullPath.length() + 1;
        int size = MPPUtility.getInt(data, filePathOffset += 24);
        filePathOffset += 4;
        if (size == 0) {
            this.m_fullPath = this.m_dosFullPath;
        } else {
            size = MPPUtility.getInt(data, filePathOffset);
            filePathOffset += 4;
            this.m_fullPath = MPPUtility.getUnicodeString(data, filePathOffset += 2, size);
            filePathOffset += size;
        }
        fileNameOffset += 18;
        this.m_dosFileName = MPPUtility.getString(data, fileNameOffset += 4);
        fileNameOffset += this.m_dosFileName.length() + 1;
        size = MPPUtility.getInt(data, fileNameOffset += 24);
        fileNameOffset += 4;
        if (size == 0) {
            this.m_fileName = this.m_dosFileName;
        } else {
            size = MPPUtility.getInt(data, fileNameOffset);
            fileNameOffset += 4;
            this.m_fileName = MPPUtility.getUnicodeString(data, fileNameOffset += 2, size);
            fileNameOffset += size;
        }
    }

    public String getDosFileName() {
        return this.m_dosFileName;
    }

    public String getDosFullPath() {
        return this.m_dosFullPath;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getFullPath() {
        return this.m_fullPath;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public int getUniqueIDStartValue() {
        return this.m_uniqueIDStartValue;
    }

    public String toString() {
        return "[SubProject uniqueID=" + this.m_uniqueID + " path=" + this.m_fullPath + "]";
    }
}

