/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.CodePage;
import com.tapsterrock.mpx.FileVersion;
import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Record;
import java.util.Locale;

public final class FileCreationRecord
extends MPXRecord {
    private char m_delimiter;
    private String m_programName;
    private FileVersion m_fileVersion;
    private CodePage m_codePage;
    static final int RECORD_NUMBER = 999;

    FileCreationRecord(MPXFile file) {
        super(file, 0);
        this.setLocale(file.getLocale());
        this.setFileVersion(FileVersion.VERSION_4_0);
    }

    void setLocale(Locale locale) {
        this.setDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        this.setProgramName(LocaleData.getString(locale, "PROGRAM_NAME"));
        this.setCodePage((CodePage)LocaleData.getObject(locale, "CODE_PAGE"));
    }

    void setValues(Record record) {
        this.setProgramName(record.getString(0));
        this.setFileVersion(FileVersion.getInstance(record.getString(1)));
        this.setCodePage(record.getCodePage(2));
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
        this.getParentFile().setDelimiter(this.m_delimiter);
    }

    public char getDelimiter() {
        return this.m_delimiter;
    }

    public void setProgramName(String programName) {
        this.m_programName = programName;
    }

    public String getProgramName() {
        return this.m_programName;
    }

    public void setFileVersion(FileVersion version) {
        this.m_fileVersion = version;
    }

    public FileVersion getFileVersion() {
        return this.m_fileVersion;
    }

    public void setCodePage(CodePage codePage) {
        this.m_codePage = codePage;
    }

    public CodePage getCodePage() {
        return this.m_codePage;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getParentFile().getDelimiter();
        buffer.append("MPX");
        buffer.append(delimiter);
        buffer.append(this.m_programName);
        buffer.append(delimiter);
        buffer.append(this.m_fileVersion);
        buffer.append(delimiter);
        buffer.append(this.m_codePage);
        buffer.append("\r\n");
        return buffer.toString();
    }
}

