/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXDate;
import com.tapsterrock.mpx.MPXException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

final class MPXDateFormat
implements Serializable {
    private SimpleDateFormat m_format = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private SimpleDateFormat m_alternativeFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private String m_null = "NA";

    MPXDateFormat() {
    }

    void setLocale(Locale locale) {
        this.m_format = new SimpleDateFormat(this.m_format.toPattern(), locale);
        this.m_alternativeFormat = new SimpleDateFormat(this.m_alternativeFormat.toPattern(), locale);
        this.m_null = LocaleData.getString(locale, "NA");
    }

    public void applyPattern(String pattern) {
        this.m_format.applyPattern(pattern);
        if (pattern.endsWith(" a")) {
            pattern = pattern.substring(0, pattern.length() - 2) + "a";
        }
        this.m_alternativeFormat.applyPattern(pattern);
    }

    public String format(Date date) {
        return this.m_format.format(date);
    }

    public MPXDate parse(String str) throws MPXException {
        MPXDate result;
        if (str == null || str.trim().length() == 0) {
            result = null;
        } else if (str.equals(this.m_null)) {
            result = null;
        } else {
            ParsePosition pos = new ParsePosition(0);
            Date javaDate = this.m_format.parse(str, pos);
            if (pos.getIndex() == 0) {
                javaDate = this.m_alternativeFormat.parse(str, pos);
                if (pos.getIndex() == 0) {
                    throw new MPXException("Invalid date " + str);
                }
            }
            result = new MPXDate(this, javaDate);
        }
        return result;
    }
}

