/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;

final class MPXNumberFormat {
    private DecimalFormatSymbols m_symbols = new DecimalFormatSymbols();
    private DecimalFormat m_primaryFormat = new DecimalFormat();
    private DecimalFormat[] m_alternativeFormats;
    private String m_primaryPattern = "";

    MPXNumberFormat() {
    }

    MPXNumberFormat(String primaryPattern, char decimalSeparator, char groupingSeparator) {
        this.applyPattern(primaryPattern, null, decimalSeparator, groupingSeparator);
    }

    MPXNumberFormat(String primaryPattern, String[] alternativePatterns, char decimalSeparator, char groupingSeparator) {
        this.applyPattern(primaryPattern, alternativePatterns, decimalSeparator, groupingSeparator);
    }

    public void applyPattern(String primaryPattern, String[] alternativePatterns, char decimalSeparator, char groupingSeparator) {
        this.m_symbols.setDecimalSeparator(decimalSeparator);
        this.m_symbols.setGroupingSeparator(groupingSeparator);
        this.m_primaryFormat.setDecimalFormatSymbols(this.m_symbols);
        this.m_primaryFormat.applyPattern(primaryPattern);
        if (alternativePatterns != null && alternativePatterns.length != 0) {
            int loop;
            if (this.m_alternativeFormats == null || this.m_alternativeFormats.length != alternativePatterns.length) {
                this.m_alternativeFormats = new DecimalFormat[alternativePatterns.length];
                for (loop = 0; loop < alternativePatterns.length; ++loop) {
                    this.m_alternativeFormats[loop] = new DecimalFormat();
                }
            }
            for (loop = 0; loop < alternativePatterns.length; ++loop) {
                this.m_alternativeFormats[loop].setDecimalFormatSymbols(this.m_symbols);
                this.m_alternativeFormats[loop].applyPattern(alternativePatterns[loop]);
            }
        }
        this.m_primaryPattern = primaryPattern;
    }

    public String format(float number) {
        return this.m_primaryFormat.format(number);
    }

    public String format(double number) {
        return this.m_primaryFormat.format(number);
    }

    public Number parse(String str) throws MPXException {
        Number result = null;
        if (str != null && (str = str.trim()).length() != 0) {
            ParsePosition parsePosition = new ParsePosition(0);
            result = this.m_primaryFormat.parse(str, parsePosition);
            if (parsePosition.getIndex() == 0) {
                result = null;
                if (this.m_alternativeFormats != null) {
                    for (int loop = 0; loop < this.m_alternativeFormats.length; ++loop) {
                        result = this.m_alternativeFormats[loop].parse(str, parsePosition);
                        if (parsePosition.getIndex() != 0) break;
                    }
                    if (parsePosition.getIndex() == 0) {
                        result = null;
                    }
                }
            }
            if (result == null) {
                throw new MPXException("Invalid number or number format number=" + str + " expected format=" + this.m_primaryPattern);
            }
        }
        return result;
    }
}

