/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.RelationType;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.ToStringRequiresFile;

public final class Relation
implements ToStringRequiresFile {
    private MPXFile m_parent;
    private int m_taskIDValue;
    private int m_taskUniqueIDValue;
    private RelationType m_type;
    private MPXDuration m_duration;

    Relation(MPXFile parent) {
        this.m_parent = parent;
        this.m_taskIDValue = 0;
        this.m_taskUniqueIDValue = 0;
        this.m_type = RelationType.FINISH_START;
        this.m_duration = MPXDuration.getInstance(0, TimeUnit.DAYS);
    }

    Relation(String relationship, MPXFile file) throws MPXException {
        int index;
        int length = relationship.length();
        for (index = 0; index < length && Character.isDigit(relationship.charAt(index)); ++index) {
        }
        try {
            this.m_taskIDValue = Integer.parseInt(relationship.substring(0, index));
        }
        catch (NumberFormatException ex) {
            throw new MPXException("Invalid format '" + relationship + "'");
        }
        Task task = file.getTaskByID(this.m_taskIDValue);
        if (task != null) {
            this.m_taskUniqueIDValue = task.getUniqueIDValue();
        }
        if (index == length) {
            this.m_type = RelationType.FINISH_START;
            this.m_duration = MPXDuration.getInstance(0, TimeUnit.DAYS);
        } else {
            if (index + 1 == length) {
                throw new MPXException("Invalid format '" + relationship + "'");
            }
            String relationType = relationship.substring(index, index + 2);
            this.m_type = RelationType.getInstance(file.getLocale(), relationship.substring(index, index + 2));
            if (this.m_type == null) {
                throw new MPXException("Invalid format '" + relationType + "'");
            }
            if ((index += 2) == length) {
                this.m_duration = MPXDuration.getInstance(0, TimeUnit.DAYS);
            } else {
                if (relationship.charAt(index) == '+') {
                    ++index;
                }
                this.m_duration = MPXDuration.getInstance(relationship.substring(index), file.getDurationDecimalFormat(), file.getLocale());
            }
        }
    }

    public String toString(MPXFile file) {
        double duration;
        StringBuffer sb = new StringBuffer(Integer.toString(this.m_taskIDValue));
        if (this.m_duration.getDuration() != 0.0 || this.m_type != RelationType.FINISH_START) {
            sb.append(this.m_type.toString(file));
        }
        if ((duration = this.m_duration.getDuration()) != 0.0) {
            if (duration > 0.0) {
                sb.append('+');
            }
            sb.append(this.m_duration.toString(file));
        }
        return sb.toString();
    }

    public int getTaskIDValue() {
        return this.m_taskIDValue;
    }

    public int getTaskUniqueIDValue() {
        return this.m_taskUniqueIDValue;
    }

    public void setTaskIDValue(int id) {
        this.m_taskIDValue = id;
    }

    public void setTaskUniqueIDValue(int id) {
        this.m_taskUniqueIDValue = id;
    }

    public RelationType getType() {
        return this.m_type;
    }

    public void setType(RelationType type) {
        this.m_type = type;
    }

    public MPXDuration getDuration() {
        return this.m_duration;
    }

    public void setDuration(MPXDuration duration) {
        this.m_duration = duration;
    }

    public Task getTask() {
        return this.m_parent.getTaskByUniqueID(this.m_taskUniqueIDValue);
    }
}

