/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.MPXUnits;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignmentWorkgroupFields;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.WorkContour;
import java.util.Date;

public final class ResourceAssignment
extends MPXRecord {
    private MPXDuration m_remainingWork;
    private Task m_task;
    private ResourceAssignmentWorkgroupFields m_workgroup;
    private WorkContour m_workContour;
    public static final Double DEFAULT_UNITS = new Double(100.0);
    private static final int RESOURCE_ID = 0;
    private static final int UNITS = 1;
    private static final int WORK = 2;
    private static final int PLANNED_WORK = 3;
    private static final int ACTUAL_WORK = 4;
    private static final int OVERTIME_WORK = 5;
    private static final int COST = 6;
    private static final int PLANNED_COST = 7;
    private static final int ACTUAL_COST = 8;
    private static final int START = 9;
    private static final int FINISH = 10;
    private static final int DELAY = 11;
    private static final int RESOURCE_UNIQUE_ID = 12;
    private static final int WORK_CONTOUR = 13;
    private static final int MAX_FIELDS = 14;
    public static final int CONTOUR_FLAT = 0;
    public static final int CONTOUR_BACK_LOADED = 1;
    public static final int CONTOUR_FRONT_LOADED = 2;
    public static final int CONTOUR_DOUBLE_PEAK = 3;
    public static final int CONTOUR_EARLY_PEAK = 4;
    public static final int CONTOUR_LATE_PEAK = 5;
    public static final int CONTOUR_BELL = 6;
    public static final int CONTOUR_TURTLE = 7;
    public static final int CONTOUR_MANUAL = 8;
    static final int RECORD_NUMBER = 75;

    ResourceAssignment(MPXFile file, Task task) throws MPXException {
        this(file, Record.EMPTY_RECORD, task);
    }

    ResourceAssignment(MPXFile file, Record record, Task task) throws MPXException {
        super(file, 14);
        this.m_task = task;
        this.setResourceID(record.getInteger(0));
        this.setUnits(record.getUnits(1));
        this.setWork(record.getDuration(2));
        this.setPlannedWork(record.getDuration(3));
        this.setActualWork(record.getDuration(4));
        this.setOvertimeWork(record.getDuration(5));
        this.setCost(record.getCurrency(6));
        this.setPlannedCost(record.getCurrency(7));
        this.setActualCost(record.getCurrency(8));
        this.setStart(record.getDateTime(9));
        this.setFinish(record.getDateTime(10));
        this.setDelay(record.getDuration(11));
        this.setResourceUniqueID(record.getInteger(12));
        MPXDuration work = this.getWork();
        MPXDuration actualWork = this.getActualWork();
        if (work != null && actualWork != null) {
            if (work.getUnits() != actualWork.getUnits()) {
                actualWork = actualWork.convertUnits(work.getUnits());
            }
            this.setRemainingWork(MPXDuration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
        }
    }

    public ResourceAssignmentWorkgroupFields addWorkgroupAssignment() throws MPXException {
        if (this.m_workgroup != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields(this.getParentFile());
        return this.m_workgroup;
    }

    ResourceAssignmentWorkgroupFields addWorkgroupAssignment(Record record) throws MPXException {
        if (this.m_workgroup != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields(this.getParentFile(), record);
        return this.m_workgroup;
    }

    public int getResourceIDValue() {
        return this.getIntValue(0);
    }

    public Integer getResourceID() {
        return (Integer)this.get(0);
    }

    public void setResourceID(int val) {
        this.setResourceID(new Integer(val));
    }

    public void setResourceID(Integer val) {
        if (val != null) {
            this.put(0, val);
            if (this.getResourceUniqueID() == null) {
                this.setResourceUniqueID(val);
            }
        }
    }

    public double getUnitsValue() {
        return this.getDoubleValue(1);
    }

    public Number getUnits() {
        return (Number)this.get(1);
    }

    public void setUnits(double val) {
        this.put(1, new MPXUnits(val));
    }

    public void setUnits(Number val) {
        this.putUnits(1, val);
    }

    public MPXDuration getWork() {
        return (MPXDuration)this.get(2);
    }

    public void setWork(MPXDuration dur) {
        this.put(2, dur);
    }

    public MPXDuration getPlannedWork() {
        return (MPXDuration)this.get(3);
    }

    public void setPlannedWork(MPXDuration dur) {
        this.put(3, dur);
    }

    public MPXDuration getActualWork() {
        return (MPXDuration)this.get(4);
    }

    public void setActualWork(MPXDuration dur) {
        this.put(4, dur);
    }

    public MPXDuration getOvertimeWork() {
        return (MPXDuration)this.get(5);
    }

    public void setOvertimeWork(MPXDuration dur) {
        this.put(5, dur);
    }

    public Number getCost() {
        return (Number)this.get(6);
    }

    public void setCost(Number val) {
        this.putCurrency(6, val);
    }

    public Number getPlannedCost() {
        return (Number)this.get(7);
    }

    public void setPlannedCost(Number val) {
        this.putCurrency(7, val);
    }

    public Number getActualCost() {
        return (Number)this.get(8);
    }

    public void setActualCost(Number val) {
        this.putCurrency(8, val);
    }

    public Date getStart() {
        return (Date)this.get(9);
    }

    public void setStart(Date val) {
        this.putDate(9, val);
    }

    public Date getFinish() {
        return (Date)this.get(10);
    }

    public void setFinish(Date val) {
        this.putDate(10, val);
    }

    public MPXDuration getDelay() {
        return (MPXDuration)this.get(11);
    }

    public void setDelay(MPXDuration dur) {
        this.put(11, dur);
    }

    public int getResourceUniqueIDValue() {
        return this.getIntValue(12);
    }

    public Integer getResourceUniqueID() {
        return (Integer)this.get(12);
    }

    public void setResourceUniqueID(int val) {
        this.setResourceUniqueID(new Integer(val));
    }

    public void setResourceUniqueID(Integer val) {
        if (val != null) {
            this.put(12, val);
            if (this.getResourceID() == null) {
                this.setResourceID(val);
            }
        }
    }

    public ResourceAssignmentWorkgroupFields getWorkgroupAssignment() {
        return this.m_workgroup;
    }

    public Task getTask() {
        return this.m_task;
    }

    public Resource getResource() {
        return this.getParentFile().getResourceByUniqueID(this.getResourceUniqueIDValue());
    }

    public WorkContour getWorkContour() {
        return this.m_workContour;
    }

    public void setWorkContour(WorkContour workContour) {
        this.m_workContour = workContour;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString(75));
        if (this.m_workgroup != null) {
            buf.append(this.m_workgroup.toString());
        }
        return buf.toString();
    }

    public MPXDuration getRemainingWork() {
        return this.m_remainingWork;
    }

    public void setRemainingWork(MPXDuration remainingWork) {
        this.m_remainingWork = remainingWork;
    }
}

