/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Record;
import java.util.HashMap;
import java.util.Locale;

final class TaskModel
extends MPXRecord {
    private boolean m_written;
    private boolean[] m_flags = new boolean[153];
    private int[] m_fields = new int[154];
    private int m_count;
    private String[] m_taskNames;
    private HashMap m_taskNumbers = new HashMap();
    static final int RECORD_NUMBER_TEXT = 60;
    static final int RECORD_NUMBER_NUMERIC = 61;

    TaskModel(MPXFile file) {
        super(file, 0);
        this.setLocale(file.getLocale());
    }

    void setLocale(Locale locale) {
        this.m_taskNames = LocaleData.getStringArray(locale, "TASK_NAMES");
        this.m_taskNumbers.clear();
        for (int loop = 0; loop < this.m_taskNames.length; ++loop) {
            String name = this.m_taskNames[loop];
            if (name == null) continue;
            this.m_taskNumbers.put(name, new Integer(loop));
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    public void update(Record record, boolean isText) throws MPXException {
        int length = record.getLength();
        for (int i = 0; i < length; ++i) {
            if (isText) {
                this.add(this.getTaskCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    public boolean getWritten() {
        return this.m_written;
    }

    public void setWritten(boolean written) {
        this.m_written = written;
    }

    public void add(int field) {
        if (field < this.m_flags.length && !this.m_flags[field]) {
            this.m_flags[field] = true;
            this.m_fields[this.m_count] = field;
            ++this.m_count;
        }
    }

    public String toString() {
        char delimiter = this.getParentFile().getDelimiter();
        StringBuffer textual = new StringBuffer();
        StringBuffer numeric = new StringBuffer();
        textual.append(60);
        numeric.append(61);
        for (int loop = 0; loop < this.m_count; ++loop) {
            int number = this.m_fields[loop];
            textual.append(delimiter);
            numeric.append(delimiter);
            textual.append(this.getTaskField(number));
            numeric.append(number);
        }
        textual.append("\r\n");
        numeric.append("\r\n");
        textual.append(numeric.toString());
        return textual.toString();
    }

    private String getTaskField(int key) {
        String result = null;
        if (key > 0 && key < this.m_taskNames.length) {
            result = this.m_taskNames[key];
        }
        return result;
    }

    private int getTaskCode(String field) throws MPXException {
        Integer result = (Integer)this.m_taskNumbers.get(field.trim());
        if (result == null) {
            throw new MPXException("Invalid task field name " + field);
        }
        return result;
    }
}

