/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mspdi;

import com.tapsterrock.mpx.AccrueType;
import com.tapsterrock.mpx.DateRange;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXCalendarException;
import com.tapsterrock.mpx.MPXCalendarHours;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.NumberUtility;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.RelationType;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.ScheduleFrom;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TaskType;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mspdi.DatatypeConverter;
import com.tapsterrock.mspdi.schema.ObjectFactory;
import com.tapsterrock.mspdi.schema.Project;
import com.tapsterrock.mspdi.schema.ProjectType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MSPDIFile
extends MPXFile {
    private boolean m_compatibleOutput = true;
    private boolean m_compatibleInput = true;
    private static final int TASK_FIELD_PREFIX = 1887;
    private static final int RESOURCE_FIELD_PREFIX = 2055;
    private static final int MSPDI_FIELD_ID = 0;
    private static final int MPX_FIELD_ID = 1;
    private static final int MSPDI_FIELD_NAME = 2;
    private static final int FIELD_DATA_TYPE = 3;
    static final int STRING_ATTRIBUTE = 1;
    static final int DATE_ATTRIBUTE = 2;
    static final int CURRENCY_ATTRIBUTE = 3;
    static final int BOOLEAN_ATTRIBUTE = 4;
    static final int NUMERIC_ATTRIBUTE = 5;
    static final int DURATION_ATTRIBUTE = 6;
    private static final Integer STRING_ATTRIBUTE_OBJECT;
    private static final Integer DATE_ATTRIBUTE_OBJECT;
    private static final Integer CURRENCY_ATTRIBUTE_OBJECT;
    private static final Integer BOOLEAN_ATTRIBUTE_OBJECT;
    private static final Integer NUMERIC_ATTRIBUTE_OBJECT;
    private static final Integer DURATION_ATTRIBUTE_OBJECT;
    private static final Object[][] TASK_DATA;
    private static final Object[][] RESOURCE_DATA;
    private static final HashMap TASK_FIELD_MPX_TO_NAME_MAP;
    private static final HashMap TASK_FIELD_XML_TO_MPX_MAP;
    private static final HashMap TASK_FIELD_MPX_TO_XML_MAP;
    private static final HashMap TASK_FIELD_MPX_TO_TYPE_MAP;
    private static final HashMap RESOURCE_FIELD_MPX_TO_NAME_MAP;
    private static final HashMap RESOURCE_FIELD_XML_TO_MPX_MAP;
    private static final HashMap RESOURCE_FIELD_MPX_TO_XML_MAP;
    private static final HashMap RESOURCE_FIELD_MPX_TO_TYPE_MAP;
    private static final BigInteger BIGINTEGER_ZERO;

    public MSPDIFile() {
    }

    public MSPDIFile(MPXFile file) {
        super(file);
    }

    public MSPDIFile(InputStream stream) throws MPXException {
        super(stream);
    }

    public MSPDIFile(File file) throws MPXException {
        super(file);
    }

    public MSPDIFile(String filename) throws MPXException {
        super(filename);
    }

    protected void configure() {
        super.configure();
        this.m_compatibleOutput = true;
        this.m_compatibleInput = true;
    }

    public void setMicrosoftProjectCompatibleOutput(boolean flag) {
        this.m_compatibleOutput = flag;
    }

    public boolean getMicrosoftProjectCompatibleOutput() {
        return this.m_compatibleOutput;
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    private void removeEmptyElementNodes(Node parent, Node node) {
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            for (int loop = 0; loop < list.getLength(); ++loop) {
                this.removeEmptyElementNodes(node, list.item(loop));
            }
        } else if (node.getNodeType() == 1) {
            parent.removeChild(node);
        }
    }

    public void read(InputStream stream) throws MPXException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(stream);
            if (this.m_compatibleInput) {
                this.removeEmptyElementNodes(doc, doc);
            }
            JAXBContext context = JAXBContext.newInstance((String)"com.tapsterrock.mspdi.schema");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        return true;
                    }
                });
            }
            Project project = (Project)unmarshaller.unmarshal((Node)doc);
            HashMap calendarMap = new HashMap();
            this.readProjectHeader(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
        }
        catch (ParserConfigurationException ex) {
            throw new MPXException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXException("Failed to parse file", ex);
        }
    }

    private void readProjectHeader(Project project) {
        ProjectHeader header = this.getProjectHeader();
        header.setActualsInSync(project.isActualsInSync());
        header.setAdminProject(project.isAdminProject());
        header.setAuthor(project.getAuthor());
        header.setAutoAddNewResourcesAndTasks(project.isAutoAddNewResourcesAndTasks());
        header.setAutolink(project.isAutolink());
        header.setBaselineForEarnedValue(NumberUtility.getInteger(project.getBaselineForEarnedValue()));
        header.setCategory(project.getCategory());
        header.setCompany(project.getCompany());
        header.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        header.setCriticalSlackLimit(NumberUtility.getInteger(project.getCriticalSlackLimit()));
        header.setCurrencyDigits(NumberUtility.getInteger(project.getCurrencyDigits()));
        header.setCurrencySymbol(project.getCurrencySymbol());
        header.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        header.setDaysPerMonth(NumberUtility.getInteger(project.getDaysPerMonth()));
        header.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        header.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        header.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        header.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        header.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        header.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        header.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        header.setDefaultTaskType(project.getDefaultTaskType());
        header.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        header.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        header.setEditableActualCosts(project.isEditableActualCosts());
        header.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        header.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        header.setFiscalYearStart(project.isFiscalYearStart());
        header.setFiscalYearStartMonth(NumberUtility.getInteger(project.getFYStartDate()));
        header.setHonorConstraints(project.isHonorConstraints());
        header.setInsertedProjectsLikeSummary(project.isInsertedProjectsLikeSummary());
        header.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        header.setManager(project.getManager());
        header.setMicrosoftProjectServerURL(project.isMicrosoftProjectServerURL());
        header.setMinutesPerDay(NumberUtility.getInteger(project.getMinutesPerDay()));
        header.setMinutesPerWeek(NumberUtility.getInteger(project.getMinutesPerWeek()));
        header.setMoveCompletedEndsBack(project.isMoveCompletedEndsBack());
        header.setMoveCompletedEndsForward(project.isMoveCompletedEndsForward());
        header.setMoveRemainingStartsBack(project.isMoveRemainingStartsBack());
        header.setMoveRemainingStartsForward(project.isMoveRemainingStartsForward());
        header.setMultipleCriticalPaths(project.isMultipleCriticalPaths());
        header.setName(project.getName());
        header.setNewTasksEffortDriven(project.isNewTasksEffortDriven());
        header.setNewTasksEstimated(project.isNewTasksEstimated());
        header.setNewTaskStartIsProjectStart(NumberUtility.getInt(project.getNewTaskStartDate()) == 0);
        header.setProjectExternallyEdited(project.isProjectExternallyEdited());
        header.setProjectTitle(project.getTitle());
        header.setRemoveFileProperties(project.isRemoveFileProperties());
        header.setRevision(NumberUtility.getInteger(project.getRevision()));
        header.setScheduleFrom(project.isScheduleFromStart() ? ScheduleFrom.START : ScheduleFrom.FINISH);
        header.setSubject(project.getSubject());
        header.setSplitInProgressTasks(project.isSplitsInProgressTasks());
        header.setSpreadActualCost(project.isSpreadActualCost());
        header.setSpreadPercentComplete(project.isSpreadPercentComplete());
        header.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        header.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        header.setSymbolPosition(project.getCurrencySymbolPosition());
        header.setUniqueID(project.getUID());
        header.setUpdatingTaskStatusUpdatesResourceStatus(project.isTaskUpdatesResource());
        header.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
    }

    private void readCalendars(Project project, HashMap map) throws MPXException {
        ProjectType.CalendarsType calendars = project.getCalendars();
        if (calendars != null) {
            List calendar = calendars.getCalendar();
            Iterator iter = calendar.iterator();
            while (iter.hasNext()) {
                this.readCalendar((ProjectType.CalendarsType.CalendarType)iter.next(), map);
            }
            MSPDIFile.updateBaseCalendarNames(map);
        }
    }

    private static void updateBaseCalendarNames(HashMap map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            MPXCalendar baseCal;
            MPXCalendar cal = (MPXCalendar)map.get(iter.next());
            String baseCalendarName = cal.getBaseCalendarName();
            if (baseCalendarName == null || (baseCal = (MPXCalendar)map.get(new BigInteger(baseCalendarName))) == null) continue;
            cal.setBaseCalendarName(baseCal.getName());
        }
    }

    private void readCalendar(ProjectType.CalendarsType.CalendarType calendar, HashMap map) throws MPXException {
        ProjectType.CalendarsType.CalendarType.WeekDaysType days;
        MPXCalendar bc = calendar.isIsBaseCalendar() ? this.addBaseCalendar() : this.addResourceCalendar();
        bc.setUniqueID(calendar.getUID().intValue());
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            bc.setBaseCalendarName(baseCalendarID.toString());
        }
        if ((days = calendar.getWeekDays()) != null) {
            List day = days.getWeekDay();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                this.readDay(bc, (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType)iter.next());
            }
        }
        map.put(calendar.getUID(), bc);
    }

    private void readDay(MPXCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day) throws MPXException {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                this.readExceptionDay(calendar, day);
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(MPXCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType weekDay) throws MPXException {
        int dayNumber = weekDay.getDayType().intValue();
        Day day = Day.getInstance(dayNumber);
        calendar.setWorkingDay(day, weekDay.isDayWorking());
        MPXCalendarHours hours = calendar.addCalendarHours(day);
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times = weekDay.getWorkingTimes();
        if (times != null) {
            List time = times.getWorkingTime();
            Iterator iter = time.iterator();
            while (iter.hasNext()) {
                ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                hours.addDateRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(MPXCalendar calendar, ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day) throws MPXException {
        MPXCalendarException exception = calendar.addCalendarException();
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.TimePeriodType timePeriod = day.getTimePeriod();
        exception.setFromDate(DatatypeConverter.parseDate(timePeriod.getFromDate()));
        exception.setToDate(DatatypeConverter.parseDate(timePeriod.getToDate()));
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times = day.getWorkingTimes();
        if (times != null) {
            ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType period;
            List time = times.getWorkingTime();
            Iterator iter = time.iterator();
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime1(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime1(DatatypeConverter.parseTime(period.getToTime()));
            }
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime2(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime2(DatatypeConverter.parseTime(period.getToTime()));
            }
            if (iter.hasNext()) {
                period = (ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType)iter.next();
                exception.setFromTime3(DatatypeConverter.parseTime(period.getFromTime()));
                exception.setToTime3(DatatypeConverter.parseTime(period.getToTime()));
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) throws MPXException {
        ProjectType.ExtendedAttributesType attributes = project.getExtendedAttributes();
        if (attributes != null) {
            List attribute = attributes.getExtendedAttribute();
            Iterator iter = attribute.iterator();
            while (iter.hasNext()) {
                this.readFieldAlias((ProjectType.ExtendedAttributesType.ExtendedAttributeType)iter.next());
            }
        }
    }

    private void readFieldAlias(ProjectType.ExtendedAttributesType.ExtendedAttributeType attribute) {
        String alias = attribute.getAlias();
        if (alias != null && alias.length() != 0) {
            Integer id = new Integer(attribute.getFieldID());
            int prefix = id / 100000;
            switch (prefix) {
                case 1887: {
                    Integer taskField = (Integer)TASK_FIELD_XML_TO_MPX_MAP.get(id);
                    if (taskField == null) break;
                    this.setTaskFieldAlias(taskField, attribute.getAlias());
                    break;
                }
                case 2055: {
                    Integer resourceField = (Integer)RESOURCE_FIELD_XML_TO_MPX_MAP.get(id);
                    if (resourceField == null) break;
                    this.setResourceFieldAlias(resourceField, attribute.getAlias());
                    break;
                }
            }
        }
    }

    private void readResources(Project project, HashMap calendarMap) throws MPXException {
        ProjectType.ResourcesType resources = project.getResources();
        if (resources != null) {
            List resource = resources.getResource();
            Iterator iter = resource.iterator();
            while (iter.hasNext()) {
                this.readResource((ProjectType.ResourcesType.ResourceType)iter.next(), calendarMap);
            }
        }
    }

    private void readResource(ProjectType.ResourcesType.ResourceType xml, HashMap calendarMap) throws MPXException {
        Resource mpx = this.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this, null, xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setAvailableFrom(DatatypeConverter.parseDate(xml.getAvailableFrom()));
        mpx.setAvailableTo(DatatypeConverter.parseDate(xml.getAvailableTo()));
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setCanLevel(xml.isCanLevel());
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostPerUse(DatatypeConverter.parseCurrency(xml.getCostPerUse()));
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(DatatypeConverter.parseDate(xml.getCreationDate()));
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
        mpx.setGroup(xml.getGroup());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setIsEnterprise(xml.isIsEnterprise());
        mpx.setIsGeneric(xml.isIsGeneric());
        mpx.setIsInactive(xml.isIsInactive());
        mpx.setIsNull(xml.isIsNull());
        mpx.setMaterialLabel(xml.getMaterialLabel());
        mpx.setMaxUnits(DatatypeConverter.parseUnits(xml.getMaxUnits()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOverAllocated(xml.isOverAllocated());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeRate(DatatypeConverter.parseRate(xml.getOvertimeRate()));
        mpx.setOvertimeRateFormat(DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this, null, xml.getRemainingWork()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this, null, xml.getRemainingOvertimeWork()));
        mpx.setStandardRate(DatatypeConverter.parseRate(xml.getStandardRate()));
        mpx.setStandardRateFormat(DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInMinutes(xml.getWorkVariance()));
        this.readResourceExtendedAttributes(xml, mpx);
        this.attachResourceCalendar(mpx, (MPXCalendar)calendarMap.get(xml.getCalendarUID()));
    }

    private void readResourceExtendedAttributes(ProjectType.ResourcesType.ResourceType xml, Resource mpx) {
        List extendedAttributes = xml.getExtendedAttribute();
        Iterator iter = extendedAttributes.iterator();
        while (iter.hasNext()) {
            ProjectType.ResourcesType.ResourceType.ExtendedAttributeType attrib = (ProjectType.ResourcesType.ResourceType.ExtendedAttributeType)iter.next();
            Integer xmlFieldID = new Integer(attrib.getFieldID());
            Integer mpxFieldID = (Integer)RESOURCE_FIELD_XML_TO_MPX_MAP.get(xmlFieldID);
            int dataType = (Integer)RESOURCE_FIELD_MPX_TO_TYPE_MAP.get(mpxFieldID);
            DatatypeConverter.parseExtendedAttribute(this, mpx, attrib.getValue(), mpxFieldID, dataType);
        }
    }

    private void readTasks(Project project) throws MPXException {
        ProjectType.TasksType tasks = project.getTasks();
        if (tasks != null) {
            List task = tasks.getTask();
            Iterator iter = task.iterator();
            while (iter.hasNext()) {
                this.readTask((ProjectType.TasksType.TaskType)iter.next());
            }
            iter = task.iterator();
            while (iter.hasNext()) {
                this.readPredecessors((ProjectType.TasksType.TaskType)iter.next());
            }
        }
        this.updateStructure();
    }

    private void readTask(ProjectType.TasksType.TaskType xml) throws MPXException {
        Task mpx = this.addTask();
        mpx.setDurationFormat(DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat()));
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualDuration(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getActualDuration()));
        mpx.setActualFinish(DatatypeConverter.parseDate(xml.getActualFinish()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getActualOvertimeWorkProtected()));
        mpx.setActualStart(DatatypeConverter.parseDate(xml.getActualStart()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setCalendarName(this.getTaskCalendarName(xml));
        mpx.setConstraintDate(DatatypeConverter.parseDate(xml.getConstraintDate()));
        mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
        mpx.setContact(xml.getContact());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCreateDate(DatatypeConverter.parseDate(xml.getCreateDate()));
        mpx.setCritical(xml.isCritical());
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setDeadline(DatatypeConverter.parseDate(xml.getDeadline()));
        mpx.setDuration(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getDuration()));
        mpx.setEarlyFinish(DatatypeConverter.parseDate(xml.getEarlyFinish()));
        mpx.setEarlyStart(DatatypeConverter.parseDate(xml.getEarlyStart()));
        mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
        mpx.setEffortDriven(xml.isEffortDriven());
        mpx.setEstimated(xml.isEstimated());
        mpx.setExternalTask(xml.isExternalTask());
        mpx.setExternalTaskProject(xml.getExternalTaskProject());
        mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
        mpx.setFinishVariance(DatatypeConverter.parseDurationInMinutes(xml.getFinishVariance()));
        mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
        mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
        mpx.setFreeSlack(DatatypeConverter.parseDurationInMinutes(xml.getFreeSlack()));
        mpx.setHideBar(xml.isHideBar());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setIgnoreResourceCalendar(xml.isIgnoreResourceCalendar());
        mpx.setLateFinish(DatatypeConverter.parseDate(xml.getLateFinish()));
        mpx.setLateStart(DatatypeConverter.parseDate(xml.getLateStart()));
        mpx.setLevelAssignments(xml.isLevelAssignments());
        mpx.setLevelingCanSplit(xml.isLevelingCanSplit());
        mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
        if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null) {
            mpx.setLevelingDelay(MPXDuration.getInstance(xml.getLevelingDelay().doubleValue(), mpx.getLevelingDelayFormat()));
        }
        mpx.setMilestone(xml.isMilestone());
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNull(xml.isIsNull());
        mpx.setOutlineLevel(NumberUtility.getInteger(xml.getOutlineLevel()));
        mpx.setOutlineNumber(xml.getOutlineNumber());
        mpx.setOverAllocated(xml.isOverAllocated());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getOvertimeWork()));
        mpx.setPercentageComplete(xml.getPercentComplete());
        mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhysicalPercentComplete(NumberUtility.getInteger(xml.getPhysicalPercentComplete()));
        mpx.setPreleveledFinish(DatatypeConverter.parseDate(xml.getPreLeveledFinish()));
        mpx.setPreleveledStart(DatatypeConverter.parseDate(xml.getPreLeveledStart()));
        mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
        mpx.setRecurring(xml.isRecurring());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingDuration(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getRemainingDuration()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getRemainingOvertimeWork()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getRemainingWork()));
        mpx.setResume(DatatypeConverter.parseDate(xml.getResume()));
        mpx.setResumeValid(xml.isResumeValid());
        mpx.setRollup(xml.isRollup());
        mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
        mpx.setStartVariance(DatatypeConverter.parseDurationInMinutes(xml.getStartVariance()));
        mpx.setStop(DatatypeConverter.parseDate(xml.getStop()));
        mpx.setSubproject(xml.isIsSubproject());
        mpx.setSubprojectName(xml.getSubprojectName());
        mpx.setSubprojectReadOnly(xml.isIsSubprojectReadOnly());
        mpx.setSummary(xml.isSummary());
        mpx.setTotalSlack(DatatypeConverter.parseDurationInMinutes(xml.getTotalSlack()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        mpx.setWBS(xml.getWBS());
        mpx.setWBSLevel(xml.getWBSLevel());
        mpx.setWork(DatatypeConverter.parseDuration(this, mpx.getDurationFormat(), xml.getWork()));
        mpx.setWorkVariance(MPXDuration.getInstance(NumberUtility.getDouble(xml.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
        this.readTaskExtendedAttributes(xml, mpx);
        mpx.setFixed(mpx.getType() == TaskType.FIXED_DURATION);
    }

    private void readTaskExtendedAttributes(ProjectType.TasksType.TaskType xml, Task mpx) {
        List extendedAttributes = xml.getExtendedAttribute();
        Iterator iter = extendedAttributes.iterator();
        while (iter.hasNext()) {
            ProjectType.TasksType.TaskType.ExtendedAttributeType attrib = (ProjectType.TasksType.TaskType.ExtendedAttributeType)iter.next();
            Integer xmlFieldID = new Integer(attrib.getFieldID());
            Integer mpxFieldID = (Integer)TASK_FIELD_XML_TO_MPX_MAP.get(xmlFieldID);
            int dataType = (Integer)TASK_FIELD_MPX_TO_TYPE_MAP.get(mpxFieldID);
            DatatypeConverter.parseExtendedAttribute(this, mpx, attrib.getValue(), mpxFieldID, dataType);
        }
    }

    private String getTaskCalendarName(ProjectType.TasksType.TaskType task) {
        MPXCalendar calendar;
        String name = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null && (calendar = this.getBaseCalendarByUniqueID(calendarID.intValue())) != null) {
            name = calendar.getName();
        }
        return name;
    }

    private void readPredecessors(ProjectType.TasksType.TaskType task) {
        Task currTask;
        BigInteger uid = task.getUID();
        if (uid != null && (currTask = this.getTaskByUniqueID(uid.intValue())) != null) {
            List predecessors = task.getPredecessorLink();
            Iterator iter = predecessors.iterator();
            while (iter.hasNext()) {
                this.readPredecessor(currTask, (ProjectType.TasksType.TaskType.PredecessorLinkType)iter.next());
            }
        }
    }

    private void readPredecessor(Task currTask, ProjectType.TasksType.TaskType.PredecessorLinkType link) {
        Task prevTask;
        BigInteger uid = link.getPredecessorUID();
        if (uid != null && (prevTask = this.getTaskByUniqueID(uid.intValue())) != null) {
            RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
            int lag = link.getLinkLag() != null ? link.getLinkLag().intValue() / 600 : 0;
            Relation rel = currTask.addPredecessor(prevTask);
            rel.setType(type);
            rel.setDuration(MPXDuration.getInstance(lag, TimeUnit.HOURS));
        }
    }

    private void readAssignments(Project project) throws MPXException {
        ProjectType.AssignmentsType assignments = project.getAssignments();
        if (assignments != null) {
            List assignment = assignments.getAssignment();
            Iterator iter = assignment.iterator();
            while (iter.hasNext()) {
                this.readAssignment((ProjectType.AssignmentsType.AssignmentType)iter.next());
            }
        }
    }

    private void readAssignment(ProjectType.AssignmentsType.AssignmentType assignment) throws MPXException {
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null) {
            Task task = this.getTaskByUniqueID(taskUID.intValue());
            Resource resource = this.getResourceByUniqueID(resourceUID.intValue());
            if (task != null && resource != null) {
                ResourceAssignment mpx = task.addResourceAssignment(resource);
                mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
                mpx.setActualWork(DatatypeConverter.parseDuration(this, TimeUnit.HOURS, assignment.getActualWork()));
                mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
                mpx.setDelay(DatatypeConverter.parseDurationInMinutes(assignment.getDelay()));
                mpx.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
                mpx.setOvertimeWork(DatatypeConverter.parseDuration(this, TimeUnit.HOURS, assignment.getOvertimeWork()));
                mpx.setRemainingWork(DatatypeConverter.parseDuration(this, TimeUnit.HOURS, assignment.getRemainingWork()));
                mpx.setStart(DatatypeConverter.parseDate(assignment.getStart()));
                mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
                mpx.setWork(DatatypeConverter.parseDuration(this, TimeUnit.HOURS, assignment.getWork()));
                mpx.setWorkContour(assignment.getWorkContour());
            }
        }
    }

    float getDefaultHoursPerDay() {
        Float value = this.getProjectHeader().getDefaultHoursInDay();
        float result = value == null ? 8.0f : value.floatValue();
        return result;
    }

    float getDefaultHoursPerWeek() {
        Float value = this.getProjectHeader().getDefaultHoursInWeek();
        float result = value == null ? 40.0f : value.floatValue();
        return result;
    }

    TimeUnit getDefaultDurationUnits() {
        TimeUnit units = this.getProjectHeader().getDefaultDurationUnits();
        if (units == null) {
            units = TimeUnit.DAYS;
        }
        return units;
    }

    public void write(OutputStream stream) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"com.tapsterrock.mspdi.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ObjectFactory factory = new ObjectFactory();
            Project project = factory.createProject();
            this.writeProjectHeader(project);
            this.writeProjectExtendedAttributes(factory, project);
            this.writeCalendars(factory, project);
            this.writeResources(factory, project);
            this.writeTasks(factory, project);
            this.writeAssignments(factory, project);
            if (this.m_compatibleOutput) {
                stream = new CompatabilityOutputStream(stream);
            }
            marshaller.marshal((Object)project, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
    }

    private void writeProjectHeader(Project project) {
        ProjectHeader header = this.getProjectHeader();
        project.setActualsInSync(header.getActualsInSync());
        project.setAdminProject(header.getAdminProject());
        project.setAuthor(header.getAuthor());
        project.setAutoAddNewResourcesAndTasks(header.getAutoAddNewResourcesAndTasks());
        project.setAutolink(header.getAutolink());
        project.setBaselineForEarnedValue(NumberUtility.getBigInteger(header.getBaselineForEarnedValue()));
        project.setCalendarUID(BigInteger.ONE);
        project.setCategory(header.getCategory());
        project.setCompany(header.getCompany());
        project.setCreationDate(DatatypeConverter.printDate(header.getCreationDate()));
        project.setCriticalSlackLimit(NumberUtility.getBigInteger(header.getCriticalSlackLimit()));
        project.setCurrencyDigits(BigInteger.valueOf(header.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(header.getCurrencySymbol());
        project.setCurrencySymbolPosition(header.getSymbolPosition());
        project.setCurrentDate(DatatypeConverter.printDate(header.getCurrentDate()));
        project.setDaysPerMonth(NumberUtility.getBigInteger(header.getDaysPerMonth()));
        project.setDefaultFinishTime(DatatypeConverter.printTime(header.getDefaultEndTime()));
        project.setDefaultFixedCostAccrual(header.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(header.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(header.getDefaultStandardRate()));
        project.setDefaultStartTime(DatatypeConverter.printTime(header.getDefaultStartTime()));
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(header.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(header.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(header.getDefaultDurationUnits()));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(header.getEarnedValueMethod()));
        project.setEditableActualCosts(header.getEditableActualCosts());
        project.setExtendedCreationDate(DatatypeConverter.printDate(header.getExtendedCreationDate()));
        project.setFinishDate(DatatypeConverter.printDate(header.getFinishDate()));
        project.setFiscalYearStart(header.getFiscalYearStart());
        project.setFYStartDate(NumberUtility.getBigInteger(header.getFiscalYearStartMonth()));
        project.setHonorConstraints(header.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(header.getInsertedProjectsLikeSummary());
        project.setLastSaved(DatatypeConverter.printDate(header.getLastSaved()));
        project.setManager(header.getManager());
        project.setMicrosoftProjectServerURL(header.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberUtility.getBigInteger(header.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberUtility.getBigInteger(header.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(header.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(header.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(header.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(header.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(header.getMultipleCriticalPaths());
        project.setName(header.getName());
        project.setNewTasksEffortDriven(header.getNewTasksEffortDriven());
        project.setNewTasksEstimated(header.getNewTasksEstimated());
        project.setNewTaskStartDate(header.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setProjectExternallyEdited(header.getProjectExternallyEdited());
        project.setRemoveFileProperties(header.getRemoveFileProperties());
        project.setRevision(NumberUtility.getBigInteger(header.getRevision()));
        project.setScheduleFromStart(header.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(header.getSplitInProgressTasks());
        project.setSpreadActualCost(header.getSpreadActualCost());
        project.setSpreadPercentComplete(header.getSpreadPercentComplete());
        project.setStartDate(DatatypeConverter.printDate(header.getStartDate()));
        project.setStatusDate(DatatypeConverter.printDate(header.getStatusDate()));
        project.setSubject(header.getSubject());
        project.setTaskUpdatesResource(header.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(header.getProjectTitle());
        project.setUID(header.getUniqueID());
        project.setWeekStartDay(DatatypeConverter.printDay(header.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(header.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.ExtendedAttributesType attributes = factory.createProjectTypeExtendedAttributesType();
        project.setExtendedAttributes(attributes);
        List list = attributes.getExtendedAttribute();
        this.writeFieldAliases(factory, this.getTaskFieldAliasMap(), TASK_FIELD_MPX_TO_XML_MAP, TASK_FIELD_MPX_TO_NAME_MAP, list);
        this.writeFieldAliases(factory, this.getResourceFieldAliasMap(), RESOURCE_FIELD_MPX_TO_XML_MAP, RESOURCE_FIELD_MPX_TO_NAME_MAP, list);
    }

    private void writeFieldAliases(ObjectFactory factory, HashMap fieldAliasMap, HashMap mpxXmlMap, HashMap mpxNameMap, List list) throws JAXBException {
        Iterator iter = mpxNameMap.keySet().iterator();
        while (iter.hasNext()) {
            Integer key = (Integer)iter.next();
            Integer fieldID = (Integer)mpxXmlMap.get(key);
            String name = (String)mpxNameMap.get(key);
            String alias = (String)fieldAliasMap.get(key);
            ProjectType.ExtendedAttributesType.ExtendedAttributeType attribute = factory.createProjectTypeExtendedAttributesTypeExtendedAttributeType();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeCalendars(ObjectFactory factory, Project project) throws JAXBException {
        MPXCalendar cal;
        LinkedList<MPXCalendar> calendarList = new LinkedList<MPXCalendar>(this.getBaseCalendars());
        Iterator iter = this.getAllResources().iterator();
        while (iter.hasNext()) {
            cal = ((Resource)iter.next()).getResourceCalendar();
            if (cal == null) continue;
            calendarList.add(cal);
        }
        ProjectType.CalendarsType calendars = factory.createProjectTypeCalendarsType();
        project.setCalendars(calendars);
        List calendar = calendars.getCalendar();
        iter = calendarList.iterator();
        factory.createProjectTypeCalendarsTypeCalendarType();
        while (iter.hasNext()) {
            cal = (MPXCalendar)iter.next();
            calendar.add(this.writeCalendar(factory, cal));
        }
    }

    private ProjectType.CalendarsType.CalendarType writeCalendar(ObjectFactory factory, MPXCalendar bc) throws JAXBException {
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType.WorkingTimeType time;
        List timesList;
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.WorkingTimesType times;
        ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType day;
        MPXCalendar base;
        ProjectType.CalendarsType.CalendarType calendar = factory.createProjectTypeCalendarsTypeCalendarType();
        calendar.setUID(BigInteger.valueOf(bc.getUniqueID()));
        calendar.setIsBaseCalendar(bc.isBaseCalendar());
        if (!bc.isBaseCalendar() && (base = bc.getBaseCalendar()) != null) {
            calendar.setBaseCalendarUID(BigInteger.valueOf(base.getUniqueID()));
        }
        calendar.setName(bc.getName());
        ProjectType.CalendarsType.CalendarType.WeekDaysType days = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysType();
        calendar.setWeekDays(days);
        List dayList = days.getWeekDay();
        for (int loop = 1; loop < 8; ++loop) {
            int workingFlag = bc.getWorkingDay(Day.getInstance(loop));
            if (workingFlag == 2) continue;
            day = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayType();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(loop));
            day.setDayWorking(workingFlag == 1);
            if (workingFlag != 1) continue;
            times = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesType();
            day.setWorkingTimes(times);
            timesList = times.getWorkingTime();
            MPXCalendarHours bch = bc.getCalendarHours(Day.getInstance(loop));
            if (bch == null) continue;
            Iterator rangeIter = bch.iterator();
            while (rangeIter.hasNext()) {
                DateRange range = (DateRange)rangeIter.next();
                if (range == null) continue;
                time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStartDate()));
                time.setToTime(DatatypeConverter.printTime(range.getEndDate()));
            }
        }
        LinkedList exceptions = bc.getCalendarExceptions();
        Iterator iter = exceptions.iterator();
        while (iter.hasNext()) {
            MPXCalendarException exception = (MPXCalendarException)iter.next();
            boolean working = exception.getWorkingValue();
            day = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayType();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            ProjectType.CalendarsType.CalendarType.WeekDaysType.WeekDayType.TimePeriodType period = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeTimePeriodType();
            day.setTimePeriod(period);
            period.setFromDate(DatatypeConverter.printDate(exception.getFromDate()));
            period.setToDate(DatatypeConverter.printDate(exception.getToDate()));
            if (!working) continue;
            times = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesType();
            day.setWorkingTimes(times);
            timesList = times.getWorkingTime();
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime1()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime1()));
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime2()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime2()));
            time = factory.createProjectTypeCalendarsTypeCalendarTypeWeekDaysTypeWeekDayTypeWorkingTimesTypeWorkingTimeType();
            timesList.add(time);
            time.setFromTime(DatatypeConverter.printTime(exception.getFromTime3()));
            time.setToTime(DatatypeConverter.printTime(exception.getToTime3()));
        }
        return calendar;
    }

    private void writeResources(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.ResourcesType resources = factory.createProjectTypeResourcesType();
        project.setResources(resources);
        List list = resources.getResource();
        Iterator iter = this.getAllResources().iterator();
        while (iter.hasNext()) {
            list.add(this.writeResource(factory, (Resource)iter.next()));
        }
    }

    private ProjectType.ResourcesType.ResourceType writeResource(ObjectFactory factory, Resource mpx) throws JAXBException {
        ProjectType.ResourcesType.ResourceType xml = factory.createProjectTypeResourcesTypeResourceType();
        MPXCalendar cal = mpx.getResourceCalendar();
        if (cal != null) {
            xml.setCalendarUID(BigInteger.valueOf(cal.getUniqueID()));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(DatatypeConverter.printDate(mpx.getAvailableFrom()));
        xml.setAvailableTo(DatatypeConverter.printDate(mpx.getAvailableTo()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(DatatypeConverter.printDate(mpx.getCreationDate()));
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setGroup(mpx.getGroup());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(BigInteger.valueOf(mpx.getIDValue()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(mpx.getInactive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(mpx.getMaterialLabel());
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(mpx.getOvertimeRateFormat()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentWorkComplete()));
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printTimeUnit(mpx.getStandardRateFormat()));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setType(mpx.getType());
        xml.setUID(BigInteger.valueOf(mpx.getUniqueIDValue()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writeResourceExtendedAttributes(factory, xml, mpx);
        return xml;
    }

    private void writeResourceExtendedAttributes(ObjectFactory factory, ProjectType.ResourcesType.ResourceType xml, Resource mpx) throws JAXBException {
        List extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < RESOURCE_DATA.length; ++loop) {
            int mpxFieldID = (Integer)RESOURCE_DATA[loop][1];
            Object value = mpx.get(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = (Integer)RESOURCE_DATA[loop][0];
            ProjectType.ResourcesType.ResourceType.ExtendedAttributeType attrib = factory.createProjectTypeResourcesTypeResourceTypeExtendedAttributeType();
            extendedAttributes.add(attrib);
            attrib.setUID(BigInteger.valueOf(loop + 1));
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private void writeTasks(ObjectFactory factory, Project project) throws JAXBException {
        ProjectType.TasksType tasks = factory.createProjectTypeTasksType();
        project.setTasks(tasks);
        List list = tasks.getTask();
        Iterator iter = this.getAllTasks().iterator();
        while (iter.hasNext()) {
            list.add(this.writeTask(factory, (Task)iter.next()));
        }
    }

    private ProjectType.TasksType.TaskType writeTask(ObjectFactory factory, Task mpx) throws JAXBException {
        ProjectType.TasksType.TaskType xml = factory.createProjectTypeTasksTypeTaskType();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(DatatypeConverter.printDate(mpx.getActualFinish()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(DatatypeConverter.printDate(mpx.getActualStart()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(DatatypeConverter.printDate(mpx.getConstraintDate()));
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(DatatypeConverter.printDate(mpx.getCreateDate()));
        xml.setCritical(mpx.getCriticalValue());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(DatatypeConverter.printDate(mpx.getDeadline()));
        xml.setDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDurationFormat()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration()));
        xml.setEarlyFinish(DatatypeConverter.printDate(mpx.getEarlyFinish()));
        xml.setEarlyStart(DatatypeConverter.printDate(mpx.getEarlyStart()));
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getExternalTaskProject());
        Date finishDate = mpx.getFinish();
        if (finishDate != null) {
            xml.setFinish(DatatypeConverter.printDate(finishDate));
        }
        xml.setFinishVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getFinishVariance()) * 1000L));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setFreeSlack(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getFreeSlack()) * 1000L));
        xml.setHideBar(mpx.getHideBarValue());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getSubproject());
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(BigInteger.valueOf(mpx.getIDValue()));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(DatatypeConverter.printDate(mpx.getLateFinish()));
        xml.setLateStart(DatatypeConverter.printDate(mpx.getLateStart()));
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() != null) {
            xml.setLevelingDelay(BigInteger.valueOf((long)mpx.getLevelingDelay().getDuration()));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelayFormat()));
        }
        xml.setMilestone(mpx.getMilestoneValue());
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setOutlineLevel(BigInteger.valueOf(mpx.getOutlineLevelValue()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(BigInteger.valueOf((long)mpx.getPercentageCompleteValue()));
        xml.setPercentWorkComplete(BigInteger.valueOf((long)mpx.getPercentageWorkCompleteValue()));
        xml.setPhysicalPercentComplete(NumberUtility.getBigInteger(mpx.getPhysicalPercentComplete()));
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (this.m_compatibleOutput && mpx.getRemainingDuration() == null) {
            MPXDuration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * mpx.getPercentageCompleteValue() / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, MPXDuration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(DatatypeConverter.printDate(mpx.getResume()));
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollupValue());
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setStartVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getStartVariance()) * 1000L));
        xml.setStop(DatatypeConverter.printDate(mpx.getStop()));
        xml.setSubprojectName(mpx.getSubprojectName());
        xml.setSummary(mpx.getSummaryValue());
        xml.setTotalSlack(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getTotalSlack()) * 1000L));
        xml.setType(mpx.getType());
        xml.setUID(BigInteger.valueOf(mpx.getUniqueIDValue()));
        xml.setWBS(mpx.getWBS());
        xml.setWBSLevel(mpx.getWBSLevel());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writePredecessors(factory, xml, mpx);
        this.writeTaskExtendedAttributes(factory, xml, mpx);
        return xml;
    }

    private void writeTaskExtendedAttributes(ObjectFactory factory, ProjectType.TasksType.TaskType xml, Task mpx) throws JAXBException {
        List extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < TASK_DATA.length; ++loop) {
            int mpxFieldID = (Integer)TASK_DATA[loop][1];
            Object value = mpx.get(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = (Integer)TASK_DATA[loop][0];
            ProjectType.TasksType.TaskType.ExtendedAttributeType attrib = factory.createProjectTypeTasksTypeTaskTypeExtendedAttributeType();
            extendedAttributes.add(attrib);
            attrib.setUID(BigInteger.valueOf(loop + 1));
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private BigInteger printExtendedAttributeDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof MPXDuration) {
            result = DatatypeConverter.printDurationTimeUnits(((MPXDuration)value).getUnits());
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        MPXCalendar cal;
        BigInteger result = null;
        String name = mpx.getCalendarName();
        if (name != null && (cal = this.getBaseCalendar(name)) != null) {
            result = BigInteger.valueOf(cal.getUniqueID());
        }
        if (result == null) {
            result = BigInteger.valueOf(-1L);
        }
        return result;
    }

    private void writePredecessors(ObjectFactory factory, ProjectType.TasksType.TaskType xml, Task mpx) throws JAXBException {
        int taskID;
        Relation rel;
        Iterator iter;
        TreeSet<Integer> set = new TreeSet<Integer>();
        List list = xml.getPredecessorLink();
        List predecessors = mpx.getUniqueIDPredecessors();
        if (predecessors != null) {
            iter = predecessors.iterator();
            while (iter.hasNext()) {
                rel = (Relation)iter.next();
                taskID = rel.getTaskIDValue();
                set.add(new Integer(taskID));
                list.add(this.writePredecessor(factory, taskID, rel.getType(), rel.getDuration()));
            }
        }
        if ((predecessors = mpx.getPredecessors()) != null) {
            iter = predecessors.iterator();
            while (iter.hasNext()) {
                rel = (Relation)iter.next();
                Task task = this.getTaskByID(rel.getTaskIDValue());
                if (task == null || set.contains(new Integer(taskID = task.getUniqueIDValue()))) continue;
                list.add(this.writePredecessor(factory, taskID, rel.getType(), rel.getDuration()));
            }
        }
    }

    private ProjectType.TasksType.TaskType.PredecessorLinkType writePredecessor(ObjectFactory factory, int taskID, RelationType type, MPXDuration lag) throws JAXBException {
        ProjectType.TasksType.TaskType.PredecessorLinkType link = factory.createProjectTypeTasksTypeTaskTypePredecessorLinkType();
        link.setPredecessorUID(BigInteger.valueOf(taskID));
        link.setType(BigInteger.valueOf(type.getType()));
        if (lag != null && lag.getDuration() != 0.0) {
            link.setLinkLag(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(lag) * 10L));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits()));
        }
        return link;
    }

    private void writeAssignments(ObjectFactory factory, Project project) throws JAXBException {
        int uid = 0;
        ProjectType.AssignmentsType assignments = factory.createProjectTypeAssignmentsType();
        project.setAssignments(assignments);
        List list = assignments.getAssignment();
        Iterator iter = this.getAllResourceAssignments().iterator();
        while (iter.hasNext()) {
            list.add(this.writeAssignment(factory, (ResourceAssignment)iter.next(), uid));
            ++uid;
        }
    }

    private ProjectType.AssignmentsType.AssignmentType writeAssignment(ObjectFactory factory, ResourceAssignment mpx, int uid) throws JAXBException {
        ProjectType.AssignmentsType.AssignmentType xml = factory.createProjectTypeAssignmentsTypeAssignmentType();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setDelay(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getDelay()) * 1000L));
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResourceUID(BigInteger.valueOf(mpx.getResourceUniqueIDValue()));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setTaskUID(BigInteger.valueOf(mpx.getTask().getUniqueIDValue()));
        xml.setUID(BigInteger.valueOf(uid));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        return xml;
    }

    static {
        int loop;
        STRING_ATTRIBUTE_OBJECT = new Integer(1);
        DATE_ATTRIBUTE_OBJECT = new Integer(2);
        CURRENCY_ATTRIBUTE_OBJECT = new Integer(3);
        BOOLEAN_ATTRIBUTE_OBJECT = new Integer(4);
        NUMERIC_ATTRIBUTE_OBJECT = new Integer(5);
        DURATION_ATTRIBUTE_OBJECT = new Integer(6);
        TASK_DATA = new Object[][]{{new Integer(188743731), new Integer(4), "Text1", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743734), new Integer(5), "Text2", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743737), new Integer(6), "Text3", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743740), new Integer(7), "Text4", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743743), new Integer(8), "Text5", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743746), new Integer(9), "Text6", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743747), new Integer(10), "Text7", STRING_ATTRIBUTE_OBJECT}, {new Integer(0xB400044), new Integer(11), "Text8", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743749), new Integer(12), "Text9", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743750), new Integer(13), "Text10", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743997), new Integer(1000), "Text11", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743998), new Integer(1001), "Text12", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743999), new Integer(1002), "Text13", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744000), new Integer(1003), "Text14", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744001), new Integer(1004), "Text15", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744002), new Integer(1005), "Text16", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744003), new Integer(1006), "Text17", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744004), new Integer(1007), "Text18", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744005), new Integer(1008), "Text19", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744006), new Integer(1009), "Text20", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744007), new Integer(1010), "Text21", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744008), new Integer(1011), "Text22", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744009), new Integer(1012), "Text23", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744010), new Integer(1013), "Text24", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744011), new Integer(1014), "Text25", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744012), new Integer(1015), "Text26", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744013), new Integer(1016), "Text27", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744014), new Integer(1017), "Text28", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744015), new Integer(1018), "Text29", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744016), new Integer(1019), "Text30", STRING_ATTRIBUTE_OBJECT}, {new Integer(188743732), new Integer(60), "Start1", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743735), new Integer(62), "Start2", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743738), new Integer(64), "Start3", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743741), new Integer(126), "Start4", DATE_ATTRIBUTE_OBJECT}, {new Integer(0xB400040), new Integer(128), "Start5", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743962), new Integer(1020), "Start6", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743964), new Integer(1021), "Start7", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743966), new Integer(1022), "Start8", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743968), new Integer(1023), "Start9", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743970), new Integer(1024), "Start10", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743733), new Integer(61), "Finish1", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743736), new Integer(63), "Finish2", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743739), new Integer(65), "Finish3", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743742), new Integer(127), "Finish4", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743745), new Integer(129), "Finish5", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743963), new Integer(1025), "Finish6", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743965), new Integer(1026), "Finish7", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743967), new Integer(1027), "Finish8", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743969), new Integer(1028), "Finish9", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743971), new Integer(1029), "Finish10", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743786), new Integer(36), "Cost1", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743787), new Integer(37), "Cost2", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743788), new Integer(38), "Cost3", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743938), new Integer(1030), "Cost4", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743939), new Integer(1031), "Cost5", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743940), new Integer(1032), "Cost6", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743941), new Integer(1033), "Cost7", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743942), new Integer(1034), "Cost8", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743943), new Integer(1035), "Cost9", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743944), new Integer(1036), "Cost10", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(188743945), new Integer(1037), "Date1", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743946), new Integer(1038), "Date2", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743947), new Integer(1039), "Date3", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743948), new Integer(1040), "Date4", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743949), new Integer(1041), "Date5", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743950), new Integer(1042), "Date6", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743951), new Integer(1043), "Date7", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743952), new Integer(1044), "Date8", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743953), new Integer(1045), "Date9", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743954), new Integer(1046), "Date10", DATE_ATTRIBUTE_OBJECT}, {new Integer(188743752), new Integer(110), "Flag1", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743753), new Integer(111), "Flag2", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743754), new Integer(112), "Flag3", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(0xB40004B), new Integer(113), "Flag4", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743756), new Integer(114), "Flag5", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743757), new Integer(115), "Flag6", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743758), new Integer(116), "Flag7", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743759), new Integer(117), "Flag8", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743760), new Integer(118), "Flag9", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743761), new Integer(119), "Flag10", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743972), new Integer(1047), "Flag11", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743973), new Integer(1048), "Flag12", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743974), new Integer(1049), "Flag13", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743975), new Integer(1050), "Flag14", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743976), new Integer(1051), "Flag15", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743977), new Integer(1052), "Flag16", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743978), new Integer(1053), "Flag17", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743979), new Integer(1054), "Flag18", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743980), new Integer(1055), "Flag19", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743981), new Integer(1056), "Flag20", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(188743767), new Integer(140), "Number1", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743768), new Integer(141), "Number2", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743769), new Integer(142), "Number3", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743770), new Integer(143), "Number4", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743771), new Integer(144), "Number5", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743982), new Integer(1057), "Number6", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743983), new Integer(1058), "Number7", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743984), new Integer(1059), "Number8", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743985), new Integer(1060), "Number9", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743986), new Integer(1061), "Number10", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743987), new Integer(1062), "Number11", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743988), new Integer(1063), "Number12", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743989), new Integer(1064), "Number13", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743990), new Integer(1065), "Number14", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743991), new Integer(1066), "Number15", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743992), new Integer(1067), "Number16", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743993), new Integer(1068), "Number17", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743994), new Integer(1069), "Number18", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743995), new Integer(1070), "Number19", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743996), new Integer(1071), "Number20", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(188743783), new Integer(46), "Duration1", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743784), new Integer(47), "Duration2", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743785), new Integer(48), "Duration3", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743955), new Integer(1072), "Duration4", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743956), new Integer(1073), "Duration5", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743957), new Integer(1074), "Duration6", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743958), new Integer(1075), "Duration7", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743959), new Integer(1076), "Duration8", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743960), new Integer(1077), "Duration9", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188743961), new Integer(1078), "Duration10", DURATION_ATTRIBUTE_OBJECT}, {new Integer(188744096), new Integer(1079), "Outline Code1", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744098), new Integer(1080), "Outline Code2", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744100), new Integer(1081), "Outline Code3", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744102), new Integer(1082), "Outline Code4", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744104), new Integer(1083), "Outline Code5", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744106), new Integer(1084), "Outline Code6", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744108), new Integer(1085), "Outline Code7", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744110), new Integer(1086), "Outline Code8", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744112), new Integer(1087), "Outline Code9", STRING_ATTRIBUTE_OBJECT}, {new Integer(188744114), new Integer(1088), "Outline Code10", STRING_ATTRIBUTE_OBJECT}};
        RESOURCE_DATA = new Object[][]{{new Integer(205520904), new Integer(5), "Text1", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520905), new Integer(6), "Text2", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520926), new Integer(7), "Text3", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520927), new Integer(8), "Text4", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520928), new Integer(9), "Text5", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520993), new Integer(1000), "Text6", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520994), new Integer(1001), "Text7", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520995), new Integer(1002), "Text8", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520996), new Integer(1003), "Text9", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520997), new Integer(1004), "Text10", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521121), new Integer(1005), "Text11", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521122), new Integer(1006), "Text12", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521123), new Integer(1007), "Text13", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521124), new Integer(1008), "Text14", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521125), new Integer(1009), "Text15", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521126), new Integer(1010), "Text16", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521127), new Integer(1011), "Text17", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521128), new Integer(1012), "Text18", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521129), new Integer(1013), "Text19", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521130), new Integer(1014), "Text20", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521131), new Integer(1015), "Text21", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521132), new Integer(1016), "Text22", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521133), new Integer(1017), "Text23", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521134), new Integer(1018), "Text24", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521135), new Integer(1019), "Text25", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521136), new Integer(1020), "Text26", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521137), new Integer(1021), "Text27", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521138), new Integer(1022), "Text28", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521139), new Integer(1023), "Text29", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521140), new Integer(1024), "Text30", STRING_ATTRIBUTE_OBJECT}, {new Integer(205520998), new Integer(1025), "Start1", DATE_ATTRIBUTE_OBJECT}, {new Integer(205520999), new Integer(1026), "Start2", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521000), new Integer(1027), "Start3", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521001), new Integer(1028), "Start4", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521002), new Integer(1029), "Start5", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521116), new Integer(1030), "Start6", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521117), new Integer(1031), "Start7", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521118), new Integer(1032), "Start8", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521119), new Integer(1033), "Start9", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521120), new Integer(1034), "Start10", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521003), new Integer(1035), "Finish1", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521004), new Integer(1036), "Finish2", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521005), new Integer(1037), "Finish3", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521006), new Integer(1038), "Finish4", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521007), new Integer(1039), "Finish5", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521086), new Integer(1040), "Finish6", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521087), new Integer(1041), "Finish7", DATE_ATTRIBUTE_OBJECT}, {new Integer(0xC4000C0), new Integer(1042), "Finish8", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521089), new Integer(1043), "Finish9", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521090), new Integer(1044), "Finish10", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521019), new Integer(1045), "Cost1", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521020), new Integer(1046), "Cost2", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521021), new Integer(1047), "Cost3", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521062), new Integer(1048), "Cost4", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521063), new Integer(1049), "Cost5", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521064), new Integer(1050), "Cost6", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521065), new Integer(1051), "Cost7", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521066), new Integer(1052), "Cost8", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521067), new Integer(1053), "Cost9", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521068), new Integer(1054), "Cost10", CURRENCY_ATTRIBUTE_OBJECT}, {new Integer(205521069), new Integer(1055), "Date1", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521070), new Integer(1056), "Date2", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521071), new Integer(1057), "Date3", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521072), new Integer(1058), "Date4", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521073), new Integer(1059), "Date5", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521074), new Integer(1060), "Date6", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521075), new Integer(1061), "Date7", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521076), new Integer(1062), "Date8", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521077), new Integer(1063), "Date9", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521078), new Integer(1064), "Date10", DATE_ATTRIBUTE_OBJECT}, {new Integer(205521023), new Integer(1065), "Flag1", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521024), new Integer(1066), "Flag2", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521025), new Integer(1067), "Flag3", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521026), new Integer(1068), "Flag4", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521027), new Integer(1069), "Flag5", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521028), new Integer(1070), "Flag6", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521029), new Integer(1071), "Flag7", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521030), new Integer(1072), "Flag8", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521031), new Integer(1073), "Flag9", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521022), new Integer(1074), "Flag10", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521091), new Integer(1075), "Flag11", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(0xC4000C4), new Integer(1076), "Flag12", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521093), new Integer(1077), "Flag13", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521094), new Integer(1078), "Flag14", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521095), new Integer(1079), "Flag15", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521096), new Integer(1080), "Flag16", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521097), new Integer(1081), "Flag17", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521098), new Integer(1082), "Flag18", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521099), new Integer(1083), "Flag19", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(0xC4000CC), new Integer(1084), "Flag20", BOOLEAN_ATTRIBUTE_OBJECT}, {new Integer(205521008), new Integer(1085), "Number1", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521009), new Integer(1086), "Number2", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521010), new Integer(1087), "Number3", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521011), new Integer(1088), "Number4", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521012), new Integer(1089), "Number5", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521101), new Integer(1090), "Number6", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521102), new Integer(1091), "Number7", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521103), new Integer(1092), "Number8", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521104), new Integer(1093), "Number9", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521105), new Integer(1094), "Number10", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521106), new Integer(1095), "Number11", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521107), new Integer(1096), "Number12", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521108), new Integer(1097), "Number13", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521109), new Integer(1098), "Number14", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521110), new Integer(1099), "Number15", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521111), new Integer(1100), "Number16", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521112), new Integer(1101), "Number17", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521113), new Integer(1102), "Number18", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521114), new Integer(1103), "Number19", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521115), new Integer(1104), "Number20", NUMERIC_ATTRIBUTE_OBJECT}, {new Integer(205521013), new Integer(1105), "Duration1", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521014), new Integer(1106), "Duration2", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521015), new Integer(1107), "Duration3", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521079), new Integer(1108), "Duration4", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521080), new Integer(1109), "Duration5", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521081), new Integer(1110), "Duration6", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521082), new Integer(1111), "Duration7", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521083), new Integer(1112), "Duration8", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521084), new Integer(1113), "Duration9", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521085), new Integer(1114), "Duration10", DURATION_ATTRIBUTE_OBJECT}, {new Integer(205521174), new Integer(1115), "Outline Code1", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521176), new Integer(1116), "Outline Code2", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521178), new Integer(1117), "Outline Code3", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521180), new Integer(1118), "Outline Code4", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521182), new Integer(1119), "Outline Code5", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521184), new Integer(1120), "Outline Code6", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521186), new Integer(1121), "Outline Code7", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521188), new Integer(1122), "Outline Code8", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521190), new Integer(1123), "Outline Code9", STRING_ATTRIBUTE_OBJECT}, {new Integer(205521192), new Integer(1124), "Outline Code10", STRING_ATTRIBUTE_OBJECT}};
        TASK_FIELD_MPX_TO_NAME_MAP = new HashMap();
        TASK_FIELD_XML_TO_MPX_MAP = new HashMap();
        TASK_FIELD_MPX_TO_XML_MAP = new HashMap();
        TASK_FIELD_MPX_TO_TYPE_MAP = new HashMap();
        RESOURCE_FIELD_MPX_TO_NAME_MAP = new HashMap();
        RESOURCE_FIELD_XML_TO_MPX_MAP = new HashMap();
        RESOURCE_FIELD_MPX_TO_XML_MAP = new HashMap();
        RESOURCE_FIELD_MPX_TO_TYPE_MAP = new HashMap();
        for (loop = 0; loop < TASK_DATA.length; ++loop) {
            TASK_FIELD_MPX_TO_NAME_MAP.put(TASK_DATA[loop][1], TASK_DATA[loop][2]);
            TASK_FIELD_XML_TO_MPX_MAP.put(TASK_DATA[loop][0], TASK_DATA[loop][1]);
            TASK_FIELD_MPX_TO_XML_MAP.put(TASK_DATA[loop][1], TASK_DATA[loop][0]);
            TASK_FIELD_MPX_TO_TYPE_MAP.put(TASK_DATA[loop][1], TASK_DATA[loop][3]);
        }
        for (loop = 0; loop < RESOURCE_DATA.length; ++loop) {
            RESOURCE_FIELD_MPX_TO_NAME_MAP.put(RESOURCE_DATA[loop][1], RESOURCE_DATA[loop][2]);
            RESOURCE_FIELD_XML_TO_MPX_MAP.put(RESOURCE_DATA[loop][0], RESOURCE_DATA[loop][1]);
            RESOURCE_FIELD_MPX_TO_XML_MAP.put(RESOURCE_DATA[loop][1], RESOURCE_DATA[loop][0]);
            RESOURCE_FIELD_MPX_TO_TYPE_MAP.put(RESOURCE_DATA[loop][1], RESOURCE_DATA[loop][3]);
        }
        BIGINTEGER_ZERO = BigInteger.valueOf(0L);
    }

    private class CompatabilityOutputStream
    extends OutputStream {
        private OutputStream m_parent;
        private int m_match = -1;
        private byte[] m_buffer;
        private int m_index;
        private byte[][] m_find = new byte[][]{"ns1:".getBytes(), ":ns1".getBytes(), ".000".getBytes(), "+??:??<".getBytes(), "-??:??<".getBytes(), "true<".getBytes(), "false<".getBytes(), ">0.0<".getBytes()};
        private String[] m_replace = new String[]{null, null, null, "<", "<", "1<", "0<", ">0<"};

        public CompatabilityOutputStream(OutputStream parent) {
            this.m_parent = parent;
            int max = 0;
            for (int loop = 0; loop < this.m_find.length; ++loop) {
                if (this.m_find[loop].length <= max) continue;
                max = this.m_find[loop].length;
            }
            this.m_buffer = new byte[max];
        }

        public void write(int b) throws IOException {
            if (this.m_match == -1) {
                for (int loop = 0; loop < this.m_find.length; ++loop) {
                    if (b != this.m_find[loop][0]) continue;
                    this.m_match = loop;
                    break;
                }
                if (this.m_match != -1) {
                    this.m_buffer[0] = (byte)b;
                    this.m_index = 1;
                } else {
                    this.m_parent.write(b);
                }
            } else {
                byte find = this.m_find[this.m_match][this.m_index];
                if (this.m_match > 0 && find == 63 || b == find) {
                    this.m_buffer[this.m_index] = (byte)b;
                    ++this.m_index;
                    if (this.m_index == this.m_find[this.m_match].length) {
                        if (this.m_replace[this.m_match] != null) {
                            this.m_parent.write(this.m_replace[this.m_match].getBytes());
                        }
                        this.m_match = -1;
                    }
                } else {
                    this.m_match = -1;
                    this.m_parent.write(this.m_buffer, 0, this.m_index);
                    this.write(b);
                }
            }
        }

        public void flush() throws IOException {
            this.m_parent.flush();
        }

        public void close() throws IOException {
            this.m_parent.close();
        }
    }
}

