/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.utility;

import com.tapsterrock.mpp.MPPFile;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mspdi.MSPDIFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MpxjQuery {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxQuery <input file name>");
            } else {
                MpxjQuery.query(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void query(String filename) throws Exception {
        MPXFile mpx = null;
        try {
            mpx = new MPXFile(filename);
        }
        catch (Exception ex) {
            mpx = null;
        }
        if (mpx == null) {
            try {
                mpx = new MPPFile(filename);
            }
            catch (Exception ex) {
                mpx = null;
            }
        }
        if (mpx == null) {
            try {
                mpx = new MSPDIFile(filename);
            }
            catch (Exception ex) {
                mpx = null;
            }
        }
        if (mpx == null) {
            throw new Exception("Failed to read file");
        }
        MpxjQuery.listProjectHeader(mpx);
        MpxjQuery.listResources(mpx);
        MpxjQuery.listTasks(mpx);
        MpxjQuery.listAssignments(mpx);
        MpxjQuery.listAssignmentsByTask(mpx);
        MpxjQuery.listAssignmentsByResource(mpx);
        MpxjQuery.listHierarchy(mpx);
        MpxjQuery.listTaskNotes(mpx);
        MpxjQuery.listResourceNotes(mpx);
        MpxjQuery.listPredecessors(mpx);
    }

    private static void listProjectHeader(MPXFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm z");
        ProjectHeader header = file.getProjectHeader();
        Date startDate = header.getStartDate();
        Date finishDate = header.getFinishDate();
        String formattedStartDate = startDate == null ? "(none)" : df.format(startDate);
        String formattedFinishDate = finishDate == null ? "(none)" : df.format(finishDate);
        System.out.println("Project Header: StartDate=" + formattedStartDate + " FinishDate=" + formattedFinishDate);
        System.out.println();
    }

    private static void listResources(MPXFile file) {
        LinkedList allResources = file.getAllResources();
        Iterator iter = allResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            System.out.println("Resource: " + resource.getName() + " (Unique ID=" + resource.getUniqueID() + ")");
        }
        System.out.println();
    }

    private static void listTasks(MPXFile file) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm z");
        LinkedList allTasks = file.getAllTasks();
        Iterator iter = allTasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            Date date = task.getStart();
            String startDate = date != null ? df.format(date) : "(no date supplied)";
            date = task.getFinish();
            String finishDate = date != null ? df.format(date) : "(no date supplied)";
            MPXDuration dur = task.getDuration();
            String duration = dur != null ? dur.toString() : "(no duration supplied)";
            System.out.println("Task: " + task.getName() + " (Start Date=" + startDate + " Finish Date=" + finishDate + " Duration=" + duration + " Outline Level=" + task.getOutlineLevel() + " Outline Number=" + task.getOutlineNumber() + " Unique ID=" + task.getUniqueID() + ")");
        }
        System.out.println();
    }

    private static void listHierarchy(MPXFile file) {
        LinkedList tasks = file.getChildTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            System.out.println("Task: " + task.getName());
            MpxjQuery.listHierarchy(task, " ");
        }
        System.out.println();
    }

    private static void listHierarchy(Task task, String indent) {
        LinkedList tasks = task.getChildTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task child = (Task)iter.next();
            System.out.println(indent + "Task: " + child.getName());
            MpxjQuery.listHierarchy(child, indent + " ");
        }
    }

    private static void listAssignments(MPXFile file) {
        LinkedList allAssignments = file.getAllResourceAssignments();
        Iterator iter = allAssignments.iterator();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            Task task = assignment.getTask();
            String taskName = task == null ? "(null task)" : task.getName();
            Resource resource = assignment.getResource();
            String resourceName = resource == null ? "(null resource)" : resource.getName();
            System.out.println("Assignment: Task=" + taskName + " Resource=" + resourceName);
        }
        System.out.println();
    }

    private static void listAssignmentsByTask(MPXFile file) {
        LinkedList tasks = file.getAllTasks();
        Iterator taskIter = tasks.iterator();
        while (taskIter.hasNext()) {
            Task task = (Task)taskIter.next();
            System.out.println("Assignments for task " + task.getName() + ":");
            LinkedList assignments = task.getResourceAssignments();
            Iterator assignmentIter = assignments.iterator();
            while (assignmentIter.hasNext()) {
                ResourceAssignment assignment = (ResourceAssignment)assignmentIter.next();
                Resource resource = assignment.getResource();
                String resourceName = resource == null ? "(null resource)" : resource.getName();
                System.out.println("   " + resourceName);
            }
        }
        System.out.println();
    }

    private static void listAssignmentsByResource(MPXFile file) {
        LinkedList resources = file.getAllResources();
        Iterator taskIter = resources.iterator();
        while (taskIter.hasNext()) {
            Resource resource = (Resource)taskIter.next();
            System.out.println("Assignments for resource " + resource.getName() + ":");
            LinkedList assignments = resource.getTaskAssignments();
            Iterator assignmentIter = assignments.iterator();
            while (assignmentIter.hasNext()) {
                ResourceAssignment assignment = (ResourceAssignment)assignmentIter.next();
                Task task = assignment.getTask();
                System.out.println("   " + task.getName());
            }
        }
        System.out.println();
    }

    private static void listTaskNotes(MPXFile file) {
        LinkedList tasks = file.getAllTasks();
        Iterator taskIter = tasks.iterator();
        while (taskIter.hasNext()) {
            Task task = (Task)taskIter.next();
            String notes = task.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + task.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listResourceNotes(MPXFile file) {
        LinkedList resources = file.getAllResources();
        Iterator resourceIter = resources.iterator();
        while (resourceIter.hasNext()) {
            Resource resource = (Resource)resourceIter.next();
            String notes = resource.getNotes();
            if (notes == null || notes.length() == 0) continue;
            System.out.println("Notes for " + resource.getName() + ": " + notes);
        }
        System.out.println();
    }

    private static void listPredecessors(MPXFile file) {
        LinkedList tasks = file.getAllTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            List predecessors = task.getPredecessors();
            if (predecessors == null || predecessors.isEmpty()) continue;
            System.out.println(task.getName() + " predecessors:");
            Iterator predecessorIterator = predecessors.iterator();
            while (predecessorIterator.hasNext()) {
                Relation relation = (Relation)predecessorIterator.next();
                System.out.println("   Task: " + file.getTaskByUniqueID(relation.getTaskIDValue()).getName());
                System.out.println("   Type: " + relation.getType());
                System.out.println("   Lag: " + relation.getDuration());
            }
        }
    }
}

