/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFAction;

public class PDFGoTo
extends PDFAction {
    protected String pageReference;
    protected String destination = null;
    protected float xPosition = 0.0f;
    protected float yPosition = 0.0f;

    public PDFGoTo(int number, String pageReference) {
        super(number);
        this.pageReference = pageReference;
    }

    public void setPageReference(String pageReference) {
        this.pageReference = pageReference;
    }

    public String getPageReference() {
        return this.pageReference;
    }

    public void setYPosition(int yPosition) {
        this.yPosition = (float)yPosition / 1000.0f;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setXPosition(int xPosition) {
        this.xPosition = (float)xPosition / 1000.0f;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public byte[] toPDF() {
        this.destination = this.destination == null ? "/D [" + this.pageReference + " /XYZ " + this.xPosition + " " + this.yPosition + " null]\n" : "/D [" + this.pageReference + " " + this.destination + "]\n";
        String p = new String(this.number + " " + this.generation + " obj\n<<\n/S /GoTo\n" + this.destination + ">>\nendobj\n");
        try {
            return p.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.getBytes();
        }
    }
}

