/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf.fonts;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.ganttproject.impex.htmlpdf.fonts.FontMetricsStorage;
import org.ganttproject.impex.htmlpdf.fonts.FontRecord;
import org.ganttproject.impex.htmlpdf.fonts.FontTriplet;
import org.ganttproject.impex.htmlpdf.fonts.TTFFileExt;

public class JDKFontLocator {
    private FontMetricsStorage myFontMetricsStorage = new FontMetricsStorage();

    public FontRecord[] getFontRecords() {
        String javaHome = System.getProperty("java.home");
        File fontDirectory = new File(javaHome + "/lib/fonts");
        File[] children = fontDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttf");
            }
        });
        if (children == null) {
            children = new File[]{};
        }
        ArrayList<FontRecord> result = new ArrayList<FontRecord>(children.length);
        for (int i = 0; i < children.length; ++i) {
            try {
                FontRecord record = new FontRecord(children[i], this.myFontMetricsStorage);
                if (record.getMetricsLocation() == null) continue;
                this.populateWithTriplets(record);
                result.add(record);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return result.toArray(new FontRecord[0]);
    }

    private void populateWithTriplets(FontRecord record) {
        TTFFileExt ttfFile = record.getTTFFile();
        boolean isItalic = ttfFile.isItalic();
        boolean isBold = ttfFile.isBold();
        String name = ttfFile.getFamilyName();
        FontTriplet triplet = new FontTriplet(name, isItalic, isBold);
        record.addTriplet(triplet);
        if (name.toLowerCase().indexOf("typewriter") >= 0) {
            FontTriplet monospaceTriplet = new FontTriplet("monospace", isItalic, isBold);
            record.addTriplet(monospaceTriplet);
        } else if (name.toLowerCase().indexOf("sans") >= 0) {
            FontTriplet sansTriplet = new FontTriplet("sans-serif", isItalic, isBold);
            record.addTriplet(sansTriplet);
        } else {
            FontTriplet serifTriplet = new FontTriplet("serif", isItalic, isBold);
            record.addTriplet(serifTriplet);
        }
    }
}

