/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFFile;

class TTFFileExt
extends TTFFile {
    private final File myFile;
    private Font myAwtFont;

    TTFFileExt(File file) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException("File=" + file + " does not exist");
        }
        System.err.println("[TTFileExt] <ctor> file=" + file.getAbsolutePath());
        this.myFile = file;
        FontFileReader reader = new FontFileReader(file.getCanonicalPath());
        this.readFont(reader);
    }

    public boolean isItalic() {
        return Integer.parseInt(this.getItalicAngle()) >> 16 != 0;
    }

    public boolean isBold() {
        return this.getAwtFont().isBold();
    }

    public File getFile() {
        return this.myFile;
    }

    private Font getAwtFont() {
        if (this.myAwtFont == null) {
            try {
                this.myAwtFont = Font.createFont(0, new FileInputStream(this.getFile()));
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.myAwtFont;
    }
}

