/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import org.bardsoftware.impl.eclipsito.ExtensionImpl;
import org.eclipse.core.runtime.IExtension;
import org.w3c.dom.NodeList;

public class PluginDescriptor {
    final URL myLocationUrl;
    private String myId;
    private String myName;
    private String myVersion;
    private String myProviderName;
    private String myClassName;
    private ArrayList myRuntimeLibraries = new ArrayList();
    private ArrayList myRequiredPlugins = new ArrayList();
    private ArrayList myExtensions = new ArrayList();
    private ArrayList myExtensionPoints = new ArrayList();

    protected PluginDescriptor(URL pluginDescriptorUrl) {
        this.myLocationUrl = pluginDescriptorUrl;
    }

    String getLocation() {
        return String.valueOf(this.myLocationUrl);
    }

    public String getId() {
        return this.myId;
    }

    protected void setId(String id) {
        if (id == null) {
            throw new InvalidParameterException("Plugin id cannot be null, please, correct " + this.myLocationUrl);
        }
        this.myId = id;
    }

    public String getName() {
        return this.myName;
    }

    protected void setName(String name) {
        if (name == null) {
            throw new InvalidParameterException("Plugin name cannot be null, please, correct " + this.myLocationUrl);
        }
        this.myName = name;
    }

    public String getVersion() {
        return this.myVersion;
    }

    protected void setVersion(String version) {
        if (version == null) {
            throw new InvalidParameterException("Plugin version cannot be null, please, correct " + this.myLocationUrl);
        }
        this.myVersion = version;
    }

    public String getClassName() {
        return this.myClassName;
    }

    protected void setClassName(String className) {
        this.myClassName = className;
    }

    public String getProviderName() {
        return this.myProviderName;
    }

    protected void setProviderName(String providerName) {
        this.myProviderName = providerName;
    }

    public String[] getRequiredPluginIds() {
        return this.myRequiredPlugins.toArray(new String[this.myRequiredPlugins.size()]);
    }

    protected void addRequiredPluginId(String requiredPlugin) {
        if (requiredPlugin == null) {
            throw new IllegalArgumentException("Required plugin attribute cannot be null, please, correct " + this.myLocationUrl);
        }
        this.myRequiredPlugins.add(requiredPlugin);
    }

    public URL[] getRuntimeLibraries() {
        return this.myRuntimeLibraries.toArray(new URL[this.myRuntimeLibraries.size()]);
    }

    protected void addRuntimeLibrary(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("Runtime library name attribute cannot be null, please, correct " + this.myLocationUrl);
        }
        try {
            URL url = new URL(this.myLocationUrl, relativePath);
            this.myRuntimeLibraries.add(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public ExtensionPointDescriptor[] getExtensionPointDescriptors() {
        return this.myExtensionPoints.toArray(new ExtensionPointDescriptor[this.myExtensionPoints.size()]);
    }

    protected void addExtensionPointDescriptor(String name, String label, String schemaReference) {
        if (name == null || label == null) {
            throw new IllegalArgumentException("Extension point id and name cannot be null, please, correct " + this.myLocationUrl);
        }
        this.myExtensionPoints.add(new ExtensionPointDescriptor(name, this.getId(), label, schemaReference));
    }

    public IExtension[] getExtensions() {
        return this.myExtensions.toArray(new IExtension[this.myExtensions.size()]);
    }

    protected void addExtension(String id, String label, String extensionPointId, NodeList configurationTags) {
        if (extensionPointId == null) {
            throw new IllegalArgumentException("Extension's point attribute cannot be null, please, correct " + this.myLocationUrl);
        }
        ExtensionImpl extension = new ExtensionImpl(id, label, extensionPointId, this.getId());
        extension.createConfigurationElements(configurationTags);
        this.myExtensions.add(extension);
    }

    public String toString() {
        return "plugin descriptor: id=" + this.myId + " name=" + this.myName + " version=" + this.myVersion + " class=" + this.myClassName + " required=" + this.myRequiredPlugins + " runtime=" + this.myRuntimeLibraries + " extensions=" + this.myExtensions + " extension-points=" + this.myExtensionPoints;
    }

    public static class ExtensionPointDescriptor {
        public final String myNamespace;
        public final String myRelativeName;
        public final String myLabel;
        public final String mySchemaReference;

        protected ExtensionPointDescriptor(String name, String namespace, String label, String schemaReference) {
            this.myRelativeName = name;
            this.myNamespace = namespace;
            this.myLabel = label;
            this.mySchemaReference = schemaReference;
        }

        public String getId() {
            return String.valueOf(this.myNamespace) + "." + this.myRelativeName;
        }

        public String toString() {
            return "extension point descriptor: id=" + this.getId() + " label=" + this.myLabel + " schema=" + this.mySchemaReference;
        }
    }
}

