/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.ganttproject.GPView;
import net.sourceforge.ganttproject.GPViewManager;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.ProjectEventListener;
import net.sourceforge.ganttproject.UIFacadeImpl;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.chart.ChartModelImpl;
import net.sourceforge.ganttproject.chart.ChartSelection;
import net.sourceforge.ganttproject.chart.ChartSelectionListener;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentCreator;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.gui.GanttStatusBar;
import net.sourceforge.ganttproject.gui.GanttTabbedPane;
import net.sourceforge.ganttproject.gui.ProjectUIFacade;
import net.sourceforge.ganttproject.gui.ProjectUIFacadeImpl;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.ParserFactory;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnitStack;
import net.sourceforge.ganttproject.time.gregorian.GPTimeUnitStack;
import net.sourceforge.ganttproject.undo.GPUndoManager;
import net.sourceforge.ganttproject.undo.UndoManagerImpl;
import org.eclipse.core.runtime.IAdaptable;

abstract class GanttProjectBase
extends JFrame
implements IGanttProject,
UIFacade {
    private final ViewManagerImpl myViewManager;
    private final List myModifiedStateChangeListeners = new ArrayList();
    private final UIFacadeImpl myUIFacade;
    private final GanttStatusBar statusBar = new GanttStatusBar(this);
    private final TimeUnitStack myTimeUnitStack;
    private final ProjectUIFacadeImpl myProjectUIFacade;
    private final DocumentManager myDocumentManager;
    private GanttTabbedPane myTabPane = new GanttTabbedPane();
    private final GPUndoManager myUndoManager;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$net$sourceforge$ganttproject$chart$Chart;
    static /* synthetic */ Class class$net$sourceforge$ganttproject$GanttProjectBase;

    protected GanttProjectBase() {
        super("Gantt Chart");
        this.myViewManager = new ViewManagerImpl(this.myTabPane);
        this.addProjectEventListener(this.myViewManager);
        this.myTimeUnitStack = new GPTimeUnitStack(this.getLanguage());
        this.myUIFacade = new UIFacadeImpl(this, this.statusBar, this.getProject(), this);
        this.myDocumentManager = new DocumentCreator(this, this.getUIFacade(), null){

            protected ParserFactory getParserFactory() {
                return GanttProjectBase.this.getParserFactory();
            }
        };
        this.myUndoManager = new UndoManagerImpl(this, null, this.myDocumentManager){

            protected ParserFactory getParserFactory() {
                return GanttProjectBase.this.getParserFactory();
            }
        };
        Mediator.registerUndoManager(this.myUndoManager);
        this.myProjectUIFacade = new ProjectUIFacadeImpl(this.myUIFacade, this.myDocumentManager, this.myUndoManager);
    }

    private GanttLanguage getLanguage() {
        return GanttLanguage.getInstance();
    }

    public void addProjectEventListener(ProjectEventListener listener) {
        this.myModifiedStateChangeListeners.add(listener);
    }

    public void removeProjectEventListener(ProjectEventListener listener) {
        this.myModifiedStateChangeListeners.remove(listener);
    }

    protected void fireProjectModified(boolean isModified) {
        for (int i = 0; i < this.myModifiedStateChangeListeners.size(); ++i) {
            ProjectEventListener next = (ProjectEventListener)this.myModifiedStateChangeListeners.get(i);
            try {
                if (isModified) {
                    next.projectModified();
                    continue;
                }
                next.projectSaved();
                continue;
            }
            catch (Exception e) {
                this.showErrorDialog(e);
            }
        }
    }

    protected void fireProjectClosed() {
        for (int i = 0; i < this.myModifiedStateChangeListeners.size(); ++i) {
            ProjectEventListener next = (ProjectEventListener)this.myModifiedStateChangeListeners.get(i);
            next.projectClosed();
        }
    }

    public ProjectUIFacade getProjectUIFacade() {
        return this.myProjectUIFacade;
    }

    public UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    public Frame getMainFrame() {
        return this.myUIFacade.getMainFrame();
    }

    public ScrollingManager getScrollingManager() {
        return this.myUIFacade.getScrollingManager();
    }

    public ZoomManager getZoomManager() {
        return this.myUIFacade.getZoomManager();
    }

    public GPUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    public void setStatusText(String text) {
        this.myUIFacade.setStatusText(text);
    }

    public void showDialog(Component content, Action[] actions) {
        this.myUIFacade.showDialog(content, actions);
    }

    public void showDialog(Component content, Action[] actions, String title) {
        this.myUIFacade.showDialog(content, actions, title);
    }

    public UIFacade.Choice showConfirmationDialog(String message, String title) {
        return this.myUIFacade.showConfirmationDialog(message, title);
    }

    public void showErrorDialog(String message) {
        this.myUIFacade.showErrorDialog(message);
    }

    public void showErrorDialog(Throwable e) {
        this.myUIFacade.showErrorDialog(e);
    }

    public void logErrorMessage(Exception e) {
        this.myUIFacade.logErrorMessage(e);
    }

    public void showPopupMenu(Component invoker, Action[] actions, int x, int y) {
        this.myUIFacade.showPopupMenu(invoker, actions, x, y);
    }

    public void setWorkbenchTitle(String title) {
        this.myUIFacade.setWorkbenchTitle(title);
    }

    protected GPViewManager getViewManager() {
        return this.myViewManager;
    }

    public GanttTabbedPane getTabs() {
        return this.myTabPane;
    }

    protected IGanttProject getProject() {
        return this;
    }

    public TimeUnitStack getTimeUnitStack() {
        return this.myTimeUnitStack;
    }

    public abstract String getProjectName();

    public abstract void setProjectName(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract String getOrganization();

    public abstract void setOrganization(String var1);

    public abstract String getWebLink();

    public abstract void setWebLink(String var1);

    public abstract Task newTask();

    public abstract GanttLanguage getI18n();

    public abstract UIConfiguration getUIConfiguration();

    public abstract ResourceManager getHumanResourceManager();

    public abstract RoleManager getRoleManager();

    public abstract TaskManager getTaskManager();

    public abstract TaskContainmentHierarchyFacade getTaskContainment();

    public abstract GPCalendar getActiveCalendar();

    public abstract void setModified();

    public abstract void close();

    public abstract Document getDocument();

    protected GanttStatusBar getStatusBar() {
        return this.statusBar;
    }

    public DocumentManager getDocumentManager() {
        return this.myDocumentManager;
    }

    protected abstract ParserFactory getParserFactory();

    protected static class RowHeightAligner
    implements GPOptionChangeListener {
        private ChartModelImpl myGanttViewModel;
        private GanttTree2 myTreeView;

        public RowHeightAligner(GanttTree2 treeView, ChartModelImpl ganttViewModel) {
            this.myGanttViewModel = ganttViewModel;
            this.myTreeView = treeView;
        }

        public void optionsChanged() {
            this.myTreeView.getTable().setRowHeight(this.myGanttViewModel.setRowHeight());
            AbstractTableModel model = (AbstractTableModel)this.myTreeView.getTable().getModel();
            model.fireTableStructureChanged();
            this.myTreeView.updateUI();
        }
    }

    private class GPViewImpl
    implements GPView,
    ChartSelectionListener {
        private final GanttTabbedPane myTabs;
        private int myIndex;
        private Container myComponent;
        private boolean isVisible;
        private final Icon myIcon;
        private final Chart myChart;
        private final ViewManagerImpl myManager;
        static final /* synthetic */ boolean $assertionsDisabled;

        GPViewImpl(ViewManagerImpl manager, GanttTabbedPane tabs, Container component, Chart chart, Icon icon) {
            this.myManager = manager;
            this.myTabs = tabs;
            this.myComponent = component;
            this.myIcon = icon;
            this.myChart = chart;
            if (!$assertionsDisabled && this.myChart == null) {
                throw new AssertionError();
            }
        }

        public void setActive(boolean active) {
            if (active) {
                this.myChart.addSelectionListener(this);
            } else {
                this.myChart.removeSelectionListener(this);
            }
        }

        public void reset() {
            this.myChart.reset();
        }

        public void setVisible(boolean isVisible) {
            String tabName = "New view";
            JScrollPane jsp = new JScrollPane();
            if (isVisible) {
                this.myChart.setTaskManager(GanttProjectBase.this.getTaskManager());
                tabName = this.myChart.getName();
                jsp.getViewport().add(this.myComponent);
                this.myTabs.addTab(tabName, this.myIcon, jsp, tabName, this);
                this.myTabs.setSelectedComponent(jsp);
                this.myIndex = this.myTabs.getSelectedIndex();
            } else {
                this.myTabs.remove(this.myIndex);
            }
            this.isVisible = isVisible;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void selectionChanged() {
            this.myManager.updateActions();
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$ganttproject$GanttProjectBase == null ? (class$net$sourceforge$ganttproject$GanttProjectBase = GanttProjectBase.class$("net.sourceforge.ganttproject.GanttProjectBase")) : class$net$sourceforge$ganttproject$GanttProjectBase).desiredAssertionStatus();
        }
    }

    private class ViewManagerImpl
    implements GPViewManager,
    ProjectEventListener {
        private GanttTabbedPane myTabs;
        private List myViews = new ArrayList();
        private GPViewImpl mySelectedView;
        private final GPAction myCopyAction = new GPAction(this){
            private final /* synthetic */ ViewManagerImpl this$1;
            {
                this.this$1 = this$1;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
            }

            protected String getIconFilePrefix() {
                return "copy_";
            }

            public void actionPerformed(ActionEvent e) {
                GPViewImpl.access$200(ViewManagerImpl.access$100(this.this$1)).getSelection().startCopyClipboardTransaction();
            }

            protected String getLocalizedName() {
                return this.getI18n("copy");
            }
        };
        private final GPAction myCutAction = new GPAction(this){
            private final /* synthetic */ ViewManagerImpl this$1;
            {
                this.this$1 = this$1;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
            }

            protected String getIconFilePrefix() {
                return "cut_";
            }

            public void actionPerformed(ActionEvent e) {
                GPViewImpl.access$200(ViewManagerImpl.access$100(this.this$1)).getSelection().startMoveClipboardTransaction();
            }

            protected String getLocalizedName() {
                return this.getI18n("cut");
            }
        };
        private final GPAction myPasteAction = new GPAction(this){
            private final /* synthetic */ ViewManagerImpl this$1;
            {
                this.this$1 = this$1;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
            }

            protected String getIconFilePrefix() {
                return "paste_";
            }

            public void actionPerformed(ActionEvent e) {
                ChartSelection selection = GPViewImpl.access$200(ViewManagerImpl.access$100(this.this$1)).getSelection();
                GPViewImpl.access$200(ViewManagerImpl.access$100(this.this$1)).paste(selection);
                selection.commitClipboardTransaction();
            }

            protected String getLocalizedName() {
                return this.getI18n("paste");
            }
        };

        ViewManagerImpl(GanttTabbedPane tabs) {
            this.myTabs = tabs;
            this.myTabs.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ ViewManagerImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    GPViewImpl selectedView = (GPViewImpl)ViewManagerImpl.access$000(this.this$1).getSelectedUserObject();
                    if (ViewManagerImpl.access$100(this.this$1) == selectedView) {
                        return;
                    }
                    if (ViewManagerImpl.access$100(this.this$1) != null) {
                        ViewManagerImpl.access$100(this.this$1).setActive(false);
                    }
                    ViewManagerImpl.access$102(this.this$1, selectedView);
                    ViewManagerImpl.access$100(this.this$1).setActive(true);
                }
            });
        }

        public GPView createView(IAdaptable adaptable, Icon icon) {
            GPViewImpl view = new GPViewImpl(this, this.myTabs, (Container)adaptable.getAdapter(class$java$awt$Container == null ? (class$java$awt$Container = GanttProjectBase.class$("java.awt.Container")) : class$java$awt$Container), (Chart)adaptable.getAdapter(class$net$sourceforge$ganttproject$chart$Chart == null ? (class$net$sourceforge$ganttproject$chart$Chart = GanttProjectBase.class$("net.sourceforge.ganttproject.chart.Chart")) : class$net$sourceforge$ganttproject$chart$Chart), icon);
            this.myViews.add(view);
            return view;
        }

        public Action getCopyAction() {
            return this.myCopyAction;
        }

        public Action getCutAction() {
            return this.myCutAction;
        }

        public Action getPasteAction() {
            return this.myPasteAction;
        }

        public void projectModified() {
        }

        public void projectSaved() {
        }

        public void projectClosed() {
            for (int i = 0; i < this.myViews.size(); ++i) {
                GPViewImpl nextView = (GPViewImpl)this.myViews.get(i);
                nextView.reset();
            }
        }

        private void updateActions() {
            ChartSelection selection = this.mySelectedView.myChart.getSelection();
            this.myCopyAction.setEnabled(false == selection.isEmpty());
            this.myCutAction.setEnabled(false == selection.isEmpty() && selection.isDeletable().isOK());
        }

        static /* synthetic */ GanttTabbedPane access$000(ViewManagerImpl x0) {
            return x0.myTabs;
        }

        static /* synthetic */ GPViewImpl access$100(ViewManagerImpl x0) {
            return x0.mySelectedView;
        }

        static /* synthetic */ GPViewImpl access$102(ViewManagerImpl x0, GPViewImpl x1) {
            x0.mySelectedView = x1;
            return x0.mySelectedView;
        }
    }
}

