/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.calendar;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.calendar.CalendarActivityImpl;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.calendar.GPCalendarBase;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.time.TimeUnit;

public class AlwaysWorkingTimeCalendarImpl
extends GPCalendarBase
implements GPCalendar {
    public List getActivities(Date startDate, Date endDate) {
        return Collections.singletonList(new CalendarActivityImpl(startDate, endDate, true));
    }

    protected List getActivitiesForward(Date startDate, TimeUnit timeUnit, long l) {
        Date activityStart;
        Date activityEnd = activityStart = timeUnit.adjustLeft(startDate);
        while (l > 0L) {
            activityEnd = timeUnit.adjustRight(activityEnd);
            --l;
        }
        return Collections.singletonList(new CalendarActivityImpl(activityStart, activityEnd, true));
    }

    protected List getActivitiesBackward(Date startDate, TimeUnit timeUnit, long unitCount) {
        Date activityEnd;
        Date activityStart = activityEnd = timeUnit.adjustLeft(startDate);
        while (unitCount-- > 0L) {
            activityStart = timeUnit.jumpLeft(activityStart);
        }
        return Collections.singletonList(new CalendarActivityImpl(activityStart, activityEnd, true));
    }

    public void setWeekDayType(int day, GPCalendar.DayType type) {
        if (type == GPCalendar.DayType.WEEKEND) {
            throw new IllegalArgumentException("I am always working time calendar, I don't accept holidays!");
        }
    }

    public GPCalendar.DayType getWeekDayType(int day) {
        return GPCalendar.DayType.WORKING;
    }

    public Date findClosestWorkingTime(Date time) {
        return time;
    }

    public void setPublicHoliDayType(int month, int date) {
    }

    public boolean isPublicHoliDay(Date curDayStart) {
        return false;
    }

    public boolean isNonWorkingDay(Date curDayStart) {
        return false;
    }

    public GPCalendar.DayType getDayTypeDate(Date curDayStart) {
        return GPCalendar.DayType.WORKING;
    }

    public void setPublicHoliDayType(Date curDayStart) {
    }

    public void setPublicHolidays(URL calendar, GanttProject gp) {
    }

    public Collection getPublicHolidays() {
        return null;
    }

    public List getActivities(Date startingFrom, TaskLength period) {
        return this.getActivities(startingFrom, period.getTimeUnit(), period.getLength());
    }
}

