/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.calendar;

import java.util.Date;
import java.util.List;
import net.sourceforge.ganttproject.calendar.GPCalendarActivity;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.time.TimeUnit;

abstract class GPCalendarBase {
    GPCalendarBase() {
    }

    public Date shiftDate(Date input, TaskLength shift) {
        Date result;
        List activities = this.getActivities(input, shift);
        if (activities.isEmpty()) {
            throw new RuntimeException("FIXME: Failed to compute calendar activities in time period=" + shift + " starting from " + input);
        }
        if (shift.getValue() >= 0.0f) {
            GPCalendarActivity lastActivity = (GPCalendarActivity)activities.get(activities.size() - 1);
            result = lastActivity.getEnd();
        } else {
            GPCalendarActivity firstActivity = (GPCalendarActivity)activities.get(0);
            result = firstActivity.getStart();
        }
        return result;
    }

    public List getActivities(Date startDate, TimeUnit timeUnit, long unitCount) {
        return unitCount > 0L ? this.getActivitiesForward(startDate, timeUnit, unitCount) : this.getActivitiesBackward(startDate, timeUnit, -unitCount);
    }

    protected abstract List getActivitiesBackward(Date var1, TimeUnit var2, long var3);

    protected abstract List getActivitiesForward(Date var1, TimeUnit var2, long var3);

    public List getActivities(Date startingFrom, TaskLength period) {
        return this.getActivities(startingFrom, period.getTimeUnit(), period.getLength());
    }
}

