/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.document;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import net.sourceforge.ganttproject.gui.options.model.DefaultStringOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.options.model.OptionPageProvider;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class NetworkOptionPageProvider
implements OptionPageProvider {
    public GPOptionGroup[] getOptionGroups(IGanttProject project, UIFacade uiFacade) {
        return project.getDocumentManager().getNetworkOptionGroups();
    }

    public String getPageID() {
        return "ftpexport";
    }

    public String toString() {
        return "FTP";
    }

    public boolean hasCustomComponent() {
        return true;
    }

    public Component buildPageComponent(IGanttProject project, final UIFacade uiFacade) {
        OptionsPageBuilder builder = new OptionsPageBuilder();
        builder.setI18N(new OptionsPageBuilder.I18N(){

            public String getPageTitle(String pageID) {
                return this.getValue("ftpexport");
            }

            public String getPageDescription(String pageID) {
                return this.getValue("settingsFTPExport");
            }

            public String getOptionGroupLabel(GPOptionGroup group) {
                return this.getValue("ftpexport");
            }

            public String getOptionLabel(GPOption option) {
                String id = option.getID();
                if ("directory-name".equals(id)) {
                    return this.getValue("ftpdirectory");
                }
                if ("password".equals(id)) {
                    return this.getValue("ftppwd");
                }
                if ("server-name".equals(id)) {
                    return this.getValue("ftpserver");
                }
                if ("user-name".equals(id)) {
                    return this.getValue("ftpuser");
                }
                return super.getOptionLabel(option);
            }
        });
        final GPOptionGroup ftpGroup = project.getDocumentManager().getNetworkOptionGroups()[0];
        final DefaultStringOption usernameOption = (DefaultStringOption)ftpGroup.getOption("user-name");
        final DefaultStringOption servernameOption = (DefaultStringOption)ftpGroup.getOption("server-name");
        final DefaultStringOption dirnameOption = (DefaultStringOption)ftpGroup.getOption("directory-name");
        final DefaultStringOption passwordOption = (DefaultStringOption)ftpGroup.getOption("password");
        final JComponent optionsPane = builder.buildPage(project.getDocumentManager().getNetworkOptionGroups(), this.getPageID());
        final AbstractAction testConnectionAction = new AbstractAction(){
            {
                this.putValue("Name", GanttLanguage.getInstance().getText("testFTPConnection"));
                this.setEnabled(NetworkOptionPageProvider.this.canEnableTestAction(ftpGroup));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                StringBuffer urlString = new StringBuffer();
                urlString.append("ftp://");
                urlString.append(usernameOption.getUncommitedValue() == null ? "" : usernameOption.getUncommitedValue());
                urlString.append(passwordOption.getUncommitedValue() == null ? "" : ":" + passwordOption.getUncommitedValue());
                urlString.append("@");
                urlString.append(servernameOption.getUncommitedValue());
                urlString.append("/");
                urlString.append(dirnameOption.getUncommitedValue());
                urlString.append("/");
                URL url = null;
                try {
                    url = new URL(urlString.toString() + "test.txt");
                    URLConnection urlc = url.openConnection();
                    OutputStream os = urlc.getOutputStream();
                    os.write("This is GanttProject +++ I was here!".getBytes());
                    os.close();
                    JOptionPane.showMessageDialog(optionsPane, GanttLanguage.getInstance().getText("successFTPConnection"), GanttLanguage.getInstance().getText("success"), 1);
                }
                catch (IOException e2) {
                    uiFacade.showErrorDialog(e2);
                }
            }
        };
        ChangeValueListener listener = new ChangeValueListener(){

            public void changeValue(ChangeValueEvent event) {
                testConnectionAction.setEnabled(NetworkOptionPageProvider.this.canEnableTestAction(ftpGroup));
            }
        };
        servernameOption.addChangeValueListener(listener);
        usernameOption.addChangeValueListener(listener);
        passwordOption.addChangeValueListener(listener);
        Box result = Box.createVerticalBox();
        result.add(optionsPane);
        result.add(new JButton(testConnectionAction));
        return result;
    }

    private boolean canEnableTestAction(GPOptionGroup ftpGroup) {
        DefaultStringOption usernameOption = (DefaultStringOption)ftpGroup.getOption("user-name");
        DefaultStringOption servernameOption = (DefaultStringOption)ftpGroup.getOption("server-name");
        DefaultStringOption passwordOption = (DefaultStringOption)ftpGroup.getOption("password");
        return servernameOption.getUncommitedValue() != null && usernameOption.getUncommitedValue() != null && passwordOption.getUncommitedValue() != null;
    }
}

