/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.taskproperties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.gui.ResourcesTableModel;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.taskproperties.CommonPanel;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import net.sourceforge.ganttproject.task.Task;
import org.jdesktop.swing.JXTable;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;

public class TaskAllocationsPanel
extends CommonPanel {
    private JPanel resourcesPanel;
    private ResourcesTableModel myResourcesTableModel;
    private JXTable resourcesTable;
    private final HumanResourceManager myHRManager;
    private JScrollPane resourcesScrollPane;
    private final RoleManager myRoleManager;
    private boolean onlyOneTask = false;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TaskAllocationsPanel(Task task, HumanResourceManager hrManager, RoleManager roleMgr, boolean onlyOneTask) {
        super(task);
        this.myHRManager = hrManager;
        this.myRoleManager = roleMgr;
        this.onlyOneTask = onlyOneTask;
    }

    public JPanel getComponent() {
        if (this.resourcesPanel == null) {
            this.constructResourcesPanel(this.getTask().getAssignmentCollection());
        }
        return this.resourcesPanel;
    }

    private void constructResourcesPanel(ResourceAssignmentCollection assignments) {
        this.resourcesPanel = new JPanel(new GridBagLayout());
        this.myResourcesTableModel = new ResourcesTableModel(assignments);
        this.resourcesTable = new JXTable((TableModel)this.myResourcesTableModel);
        this.setUpResourcesComboColumn((JTable)this.resourcesTable);
        this.setUpCoordinatorBooleanColumn((JTable)this.resourcesTable);
        this.setUpRolesComboColumn((JTable)this.resourcesTable);
        this.resourcesTable.setRowHeight(23);
        this.resourcesTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.resourcesTable.getColumnModel().getColumn(1).setPreferredWidth(240);
        this.resourcesTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.resourcesTable.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.resourcesTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.resourcesTable.setHighlighters(new HighlighterPipeline(new Highlighter[]{new Highlighter(new Color(255, 255, 255), null)}));
        this.resourcesScrollPane = new JScrollPane((Component)this.resourcesTable);
        this.resourcesScrollPane.setPreferredSize(new Dimension(500, 130));
        JPanel secondResourcesScrollPane = new JPanel();
        secondResourcesScrollPane.setBorder(new TitledBorder(new EtchedBorder(), GanttProject.correctLabel(this.getLanguage().getText("human"))));
        secondResourcesScrollPane.add(this.resourcesScrollPane);
        TestGanttRolloverButton bremove = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/delete_16.gif")));
        bremove.setToolTipText(GanttProject.getToolTip(this.getLanguage().getText("removeResources")));
        bremove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int[] selectedRow = TaskAllocationsPanel.this.resourcesTable.getSelectedRows();
                for (int i = 0; i < selectedRow.length; ++i) {
                    TaskAllocationsPanel.this.resourcesTable.getModel().setValueAt(null, selectedRow[i], 1);
                }
            }
        });
        secondResourcesScrollPane.add(bremove);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets.right = 15;
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        gbc.weighty = 0.0;
        JPanel commonFields = this.setupCommonFields(this.onlyOneTask);
        this.addUsingGBL(this.resourcesPanel, commonFields, gbc, 0, 0, 1, 1);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 8;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        this.resourcesPanel.add((Component)secondResourcesScrollPane, gbc);
    }

    public ResourcesTableModel getTableModel() {
        return this.myResourcesTableModel;
    }

    private void setUpCoordinatorBooleanColumn(JTable resourceTable) {
        TableColumn resourcesColumn = resourceTable.getColumnModel().getColumn(3);
        resourcesColumn.setCellRenderer(new BooleanRenderer());
    }

    private void setUpResourcesComboColumn(JTable resourceTable) {
        List resources = this.myHRManager.getResources();
        JComboBox comboBox = new JComboBox();
        for (int i = 0; i < resources.size(); ++i) {
            comboBox.addItem(resources.get(i));
        }
        TableColumn resourcesColumn = resourceTable.getColumnModel().getColumn(1);
        comboBox.setEditable(false);
        resourcesColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    private void setUpRolesComboColumn(JTable resourceTable) {
        Role[] roles = this.myRoleManager.getEnabledRoles();
        JComboBox<Role> comboBox = new JComboBox<Role>();
        for (int i = 0; i < roles.length; ++i) {
            Role role = roles[i];
            comboBox.addItem(role);
        }
        TableColumn rolesColumn = resourceTable.getColumnModel().getColumn(4);
        comboBox.setEditable(false);
        rolesColumn.setCellEditor(new DefaultCellEditor(comboBox));
        rolesColumn.setCellRenderer(new DefaultTableCellRenderer());
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (!value.getClass().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TaskAllocationsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                this.setSelected(false);
            } else {
                this.setSelected(value != null && (Boolean)value != false);
            }
            return this;
        }
    }
}

