/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.importer;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.filter.ExtensionBasedFileFilter;
import net.sourceforge.ganttproject.importer.Importer;
import net.sourceforge.ganttproject.importer.ImporterFromGanttFile;
import net.sourceforge.ganttproject.importer.ImporterFromTxtFile;

public abstract class ImporterFactory {
    private static FileFilter txtFilter = new ExtensionBasedFileFilter("txt", "Text files (.txt)");
    private static FileFilter mppFilter = new ExtensionBasedFileFilter("mpp|mpx|xml", "MsProject files (.mpp, .mpx, .xml)");
    private static FileFilter ganFilter = new ExtensionBasedFileFilter("xml|gan", "GanttProject files (.gan, .xml)");

    public static Importer createImporter(FileFilter fileFilter) {
        if (fileFilter == txtFilter) {
            return new ImporterFromTxtFile();
        }
        if (fileFilter == ganFilter) {
            return new ImporterFromGanttFile();
        }
        return null;
    }

    public static JFileChooser createFileChooser(GanttOptions options) {
        JFileChooser fc = new JFileChooser(options.getWorkingDir());
        FileFilter[] filefilters = fc.getChoosableFileFilters();
        for (int i = 0; i < filefilters.length; ++i) {
            fc.removeChoosableFileFilter(filefilters[i]);
        }
        fc.addChoosableFileFilter(ganFilter);
        fc.addChoosableFileFilter(mppFilter);
        fc.addChoosableFileFilter(txtFilter);
        return fc;
    }
}

