/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.ParsingContext;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.TaskManager;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;
import org.xml.sax.Attributes;

public class CustomPropertiesTagHandler
implements TagHandler,
ParsingListener {
    private TaskManager taskManager = null;
    private ParsingContext parsingContext = null;
    private List listStructure = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    public CustomPropertiesTagHandler(ParsingContext context, TaskManager taskManager) {
        this.taskManager = taskManager;
        this.parsingContext = context;
        this.listStructure = new ArrayList();
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
        if (qName.equals("customproperty")) {
            this.loadProperty(attrs);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    public void parsingStarted() {
    }

    public void parsingFinished() {
        Iterator it = this.listStructure.iterator();
        while (it.hasNext()) {
            CustomPropertiesStructure cps = (CustomPropertiesStructure)it.next();
            GanttTask task = this.taskManager.getTask(cps.taskID);
            CustomColumn cc = Mediator.getCustomColumnsStorage().getCustomColumnByID(cps.taskPropertyID);
            String valueStr = cps.value;
            Object value = null;
            Class cla = cc.getType();
            if (cla.equals(class$java$lang$String == null ? CustomPropertiesTagHandler.class$("java.lang.String") : class$java$lang$String)) {
                value = valueStr.toString();
            } else if (cla.equals(class$java$lang$Boolean == null ? CustomPropertiesTagHandler.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                value = Boolean.valueOf(valueStr);
            } else if (cla.equals(class$java$lang$Integer == null ? CustomPropertiesTagHandler.class$("java.lang.Integer") : class$java$lang$Integer)) {
                value = Integer.valueOf(valueStr);
            } else if (cla.equals(class$java$lang$Double == null ? CustomPropertiesTagHandler.class$("java.lang.Double") : class$java$lang$Double)) {
                value = Double.valueOf(valueStr);
            } else if ((class$java$util$GregorianCalendar == null ? CustomPropertiesTagHandler.class$("java.util.GregorianCalendar") : class$java$util$GregorianCalendar).isAssignableFrom(cla)) {
                try {
                    value = new GanttCalendar(DateParser.parse(valueStr));
                }
                catch (InvalidDateException e) {
                    e.printStackTrace();
                }
            }
            try {
                task.getCustomValues().setValue(cc.getName(), value);
            }
            catch (CustomColumnsException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadProperty(Attributes attrs) {
        if (attrs != null) {
            CustomPropertiesStructure cps = new CustomPropertiesStructure();
            cps.setTaskID(this.parsingContext.getTaskID());
            cps.setTaskPropertyID(attrs.getValue("taskproperty-id"));
            cps.setValue(attrs.getValue("value"));
            this.listStructure.add(cps);
        }
    }

    private class CustomPropertiesStructure {
        public int taskID;
        public String taskPropertyID = null;
        public String value = null;

        public void setTaskID(int taskID) {
            this.taskID = taskID;
        }

        public void setTaskPropertyID(String propertyID) {
            this.taskPropertyID = propertyID;
        }

        public void setValue(String val) {
            this.value = val;
        }
    }
}

