/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.TagHandler;
import org.xml.sax.Attributes;

public class DefaultWeekTagHandler
implements TagHandler {
    private GPCalendar myGPCalendar;
    private Calendar myCalendar = GregorianCalendar.getInstance(Locale.ENGLISH);
    private SimpleDateFormat myShortFormat = new SimpleDateFormat("EEE", Locale.ENGLISH);

    public DefaultWeekTagHandler(GPCalendar calendar) {
        this.myGPCalendar = calendar;
        for (int i = 1; i <= 7; ++i) {
            this.myGPCalendar.setWeekDayType(i, GPCalendar.DayType.WORKING);
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
        if ("default-week".equals(qName)) {
            this.loadCalendar(attrs);
        }
    }

    private void loadCalendar(Attributes attrs) {
        for (int i = 1; i <= 7; ++i) {
            String nextDayName = this.getShortDayName(i);
            String nextEncodedType = attrs.getValue(nextDayName);
            if (!"1".equals(nextEncodedType)) continue;
            this.myGPCalendar.setWeekDayType(i, GPCalendar.DayType.WEEKEND);
        }
    }

    private String getShortDayName(int i) {
        this.myCalendar.set(7, i);
        return this.myShortFormat.format(this.myCalendar.getTime()).toLowerCase();
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }
}

