/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.roles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RoleSet;
import net.sourceforge.ganttproject.roles.RoleSetImpl;

public class RoleManagerImpl
implements RoleManager {
    private final List myListeners = new ArrayList();
    String[] defaultRoles;
    private RoleSetImpl myProjectRoleSet = new RoleSetImpl(null, this);
    private ArrayList myRoleSets = new ArrayList();
    final RoleSetImpl SOFTWARE_DEVELOPMENT_ROLE_SET;
    final RoleSetImpl DEFAULT_ROLE_SET;

    public RoleManagerImpl() {
        GanttLanguage language = GanttLanguage.getInstance();
        this.SOFTWARE_DEVELOPMENT_ROLE_SET = new RoleSetImpl("SoftwareDevelopment", this);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resDeveloper"), 2);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resDocWriter"), 3);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resTester"), 4);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resGraphicDesigner"), 5);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resDocTranslator"), 6);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resPackager"), 7);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resAnalysis"), 8);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resWebDesigner"), 9);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.createRole(language.getText("resNoSpecificRole"), 10);
        this.DEFAULT_ROLE_SET = new RoleSetImpl("Default", this);
        this.DEFAULT_ROLE_SET.createRole(language.getText("resUndefined"), 0);
        this.DEFAULT_ROLE_SET.createRole(language.getText("resProjectManager"), 1);
        this.DEFAULT_ROLE_SET.setEnabled(true);
        this.clear();
        this.myRoleSets.add(this.DEFAULT_ROLE_SET);
        this.myRoleSets.add(this.SOFTWARE_DEVELOPMENT_ROLE_SET);
        this.myProjectRoleSet.setEnabled(true);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.setEnabled(false);
    }

    public void clear() {
        this.myProjectRoleSet = new RoleSetImpl(null, this);
        for (int i = 0; i < this.myRoleSets.size(); ++i) {
            RoleSet next = (RoleSet)this.myRoleSets.get(i);
            next.setEnabled(false);
        }
        this.myProjectRoleSet.setEnabled(true);
        this.DEFAULT_ROLE_SET.setEnabled(true);
        this.SOFTWARE_DEVELOPMENT_ROLE_SET.setEnabled(false);
    }

    public Role[] getProjectLevelRoles() {
        return this.myProjectRoleSet.getRoles();
    }

    public void add(int ID, String roleName) {
        this.myProjectRoleSet.createRole(roleName, ID);
    }

    public RoleSet[] getRoleSets() {
        return this.myRoleSets.toArray(new RoleSet[0]);
    }

    public RoleSet createRoleSet(String name) {
        RoleSetImpl result = new RoleSetImpl(name, this);
        this.myRoleSets.add(result);
        return result;
    }

    public RoleSet getProjectRoleSet() {
        return this.myProjectRoleSet;
    }

    public RoleSet getRoleSet(String rolesetName) {
        RoleSet result = null;
        RoleSet[] roleSets = this.getRoleSets();
        for (int i = 0; i < roleSets.length; ++i) {
            if (!roleSets[i].getName().equals(rolesetName)) continue;
            result = roleSets[i];
            break;
        }
        return result;
    }

    public Role[] getEnabledRoles() {
        ArrayList<Role> result = new ArrayList<Role>();
        RoleSet[] roleSets = this.getRoleSets();
        for (int i = 0; i < roleSets.length; ++i) {
            if (!roleSets[i].isEnabled()) continue;
            result.addAll(Arrays.asList(roleSets[i].getRoles()));
        }
        result.addAll(Arrays.asList(this.getProjectRoleSet().getRoles()));
        return result.toArray(new Role[0]);
    }

    public Role getDefaultRole() {
        return this.DEFAULT_ROLE_SET.findRole(0);
    }

    public void importData(RoleManager original) {
        RoleSet next;
        int i;
        this.myProjectRoleSet.importData(original.getProjectRoleSet());
        RoleSet[] originalRoleSets = original.getRoleSets();
        HashSet<String> thisNames = new HashSet<String>();
        for (i = 0; i < this.myRoleSets.size(); ++i) {
            next = (RoleSet)this.myRoleSets.get(i);
            thisNames.add(next.getName());
        }
        for (i = 0; i < originalRoleSets.length; ++i) {
            next = originalRoleSets[i];
            if (thisNames.contains(next.getName())) continue;
            this.myRoleSets.add(next);
        }
    }

    public void addRoleListener(RoleManager.Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeRoleListener(RoleManager.Listener listener) {
        this.myListeners.remove(listener);
    }

    void fireRolesChanged(RoleSet changedRoleSet) {
        RoleManager.RoleEvent event = new RoleManager.RoleEvent(this, changedRoleSet);
        for (int i = 0; i < this.myListeners.size(); ++i) {
            RoleManager.Listener next = (RoleManager.Listener)this.myListeners.get(i);
            next.rolesChanged(event);
        }
    }
}

