/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTaskRelationship;
import net.sourceforge.ganttproject.calendar.AlwaysWorkingTimeCalendarImpl;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.calendar.GPCalendarActivity;
import net.sourceforge.ganttproject.shape.ShapePaint;
import net.sourceforge.ganttproject.task.CustomColumnsValues;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.ResourceAssignmentCollection;
import net.sourceforge.ganttproject.task.ResourceAssignmentCollectionImpl;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskActivityImpl;
import net.sourceforge.ganttproject.task.TaskInfo;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerImpl;
import net.sourceforge.ganttproject.task.TaskMutator;
import net.sourceforge.ganttproject.task.algorithm.AlgorithmCollection;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import net.sourceforge.ganttproject.task.dependency.TaskDependencySlice;
import net.sourceforge.ganttproject.task.dependency.TaskDependencySliceAsDependant;
import net.sourceforge.ganttproject.task.dependency.TaskDependencySliceAsDependee;
import net.sourceforge.ganttproject.task.dependency.TaskDependencySliceImpl;
import net.sourceforge.ganttproject.task.hierarchy.TaskHierarchyItem;
import net.sourceforge.ganttproject.time.TimeUnit;

public class TaskImpl
implements Task {
    private int myID;
    private final TaskManagerImpl myManager;
    private String myName;
    private String myWebLink = new String("http://");
    private boolean isMilestone;
    boolean isProjectTask;
    private int myPriority;
    private GanttCalendar myStart;
    private GanttCalendar myEnd;
    private GanttCalendar myThird;
    private int myThirdDateConstraint;
    private int myCompletionPercentage;
    private TaskLength myLength;
    private List myActivities = new ArrayList();
    private boolean bExpand;
    private ResourceAssignmentCollectionImpl myAssignments;
    private TaskDependencySlice myDependencySlice;
    private TaskDependencySlice myDependencySliceAsDependant;
    private TaskDependencySlice myDependencySliceAsDependee;
    private boolean myEventsEnabled;
    private final TaskHierarchyItem myTaskHierarchyItem;
    private ShapePaint myShape;
    private Color myColor;
    private String myNotes;
    private MutatorImpl myMutator;
    private final CustomColumnsValues customValues;
    private boolean critical;
    public static final int NONE = 0;
    public static final int EARLIESTBEGIN = 1;
    private Exception myException;
    private TaskInfo myTaskInfo;
    private static final GPCalendar RESTLESS_CALENDAR;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected TaskImpl(TaskManager taskManager, int taskID) {
        this.myManager = (TaskManagerImpl)taskManager;
        if (taskID == -1) {
            this.myID = this.myManager.getMaxID();
            this.myManager.increaseMaxID();
        } else {
            if (this.myManager.getTask(taskID) != null) {
                throw new IllegalArgumentException("There is a task with ID=" + taskID + " already");
            }
            this.myID = taskID;
        }
        this.myAssignments = new ResourceAssignmentCollectionImpl(this, this.myManager.getConfig().getResourceManager());
        this.myDependencySlice = new TaskDependencySliceImpl(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependant = new TaskDependencySliceAsDependant(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependee = new TaskDependencySliceAsDependee(this, this.myManager.getDependencyCollection());
        this.myPriority = 1;
        this.myTaskHierarchyItem = this.myManager.getHierarchyManager().createItem(this);
        this.myNotes = "";
        this.bExpand = true;
        this.myColor = null;
        this.customValues = new CustomColumnsValues();
    }

    protected TaskImpl(TaskImpl copy, boolean isUnplugged) {
        this.myManager = copy.myManager;
        this.myTaskHierarchyItem = !isUnplugged ? this.myManager.getHierarchyManager().createItem(this) : null;
        this.myAssignments = new ResourceAssignmentCollectionImpl(this, this.myManager.getConfig().getResourceManager());
        this.myAssignments.importData(copy.getAssignmentCollection());
        this.myID = copy.myID;
        this.myName = copy.myName;
        this.myWebLink = copy.myWebLink;
        this.isMilestone = copy.isMilestone;
        this.isProjectTask = copy.isProjectTask;
        this.myPriority = copy.myPriority;
        this.myStart = copy.myStart;
        this.myEnd = copy.myEnd;
        this.myThird = copy.myThird;
        this.myThirdDateConstraint = copy.myThirdDateConstraint;
        this.myCompletionPercentage = copy.myCompletionPercentage;
        this.myLength = copy.myLength;
        this.myShape = copy.myShape;
        this.myColor = copy.myColor;
        this.myNotes = copy.myNotes;
        this.bExpand = copy.bExpand;
        this.myDependencySlice = new TaskDependencySliceImpl(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependant = new TaskDependencySliceAsDependant(this, this.myManager.getDependencyCollection());
        this.myDependencySliceAsDependee = new TaskDependencySliceAsDependee(this, this.myManager.getDependencyCollection());
        this.customValues = (CustomColumnsValues)copy.getCustomValues().clone();
        this.recalculateActivities();
    }

    public Task unpluggedClone() {
        TaskImpl result = new TaskImpl(this, true){

            public boolean isSupertask() {
                return false;
            }
        };
        return result;
    }

    public TaskMutator createMutator() {
        if (this.myMutator != null) {
            throw new RuntimeException("Two mutators have been requested for task=" + this.getName(), this.myException);
        }
        this.myMutator = new MutatorImpl();
        this.myException = new Exception();
        return this.myMutator;
    }

    public TaskMutator createMutatorFixingDuration() {
        if (this.myMutator != null) {
            throw new RuntimeException("Two mutators have been requested for task=" + this.getName(), this.myException);
        }
        this.myMutator = new MutatorImpl(){

            public void setStart(GanttCalendar start) {
                super.setStart(start);
                TaskImpl.this.myEnd = null;
            }
        };
        this.myException = new Exception();
        return this.myMutator;
    }

    public int getTaskID() {
        return this.myID;
    }

    public String getName() {
        return this.myName;
    }

    public String getWebLink() {
        return this.myWebLink;
    }

    public boolean isMilestone() {
        return this.isMilestone;
    }

    public int getPriority() {
        return this.myPriority;
    }

    public GanttCalendar getStart() {
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            return this.myMutator.getStart();
        }
        return this.myStart;
    }

    public GanttCalendar getEnd() {
        GanttCalendar result = null;
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            result = this.myMutator.getEnd();
        }
        if (result == null) {
            if (this.myEnd == null) {
                this.myEnd = this.calculateEnd();
            }
            result = this.myEnd;
        }
        return result;
    }

    GanttCalendar calculateEnd() {
        GanttCalendar result = this.getStart().Clone();
        Date newEnd = this.shiftDate(result.getTime(), this.getDuration().getTimeUnit(), this.getDuration().getLength());
        result.setTime(newEnd);
        return result;
    }

    public GanttCalendar getThird() {
        if (this.myMutator != null && this.myMutator.myIsolationLevel == 0) {
            return this.myMutator.getThird();
        }
        return this.myThird;
    }

    public int getThirdDateConstraint() {
        return this.myThirdDateConstraint;
    }

    public TaskActivity[] getActivities() {
        List activities;
        List list = activities = this.myMutator == null ? null : this.myMutator.getActivities();
        if (activities == null) {
            activities = this.myActivities;
        }
        return activities.toArray(new TaskActivity[activities.size()]);
    }

    public TaskLength getDuration() {
        return this.myMutator != null && this.myMutator.myIsolationLevel == 0 ? this.myMutator.getDuration() : this.myLength;
    }

    public int getCompletionPercentage() {
        return this.myMutator != null && this.myMutator.myIsolationLevel == 0 ? this.myMutator.getCompletionPercentage() : this.myCompletionPercentage;
    }

    public boolean getExpand() {
        return this.bExpand;
    }

    public ShapePaint getShape() {
        return this.myShape;
    }

    public Color getColor() {
        Color result = this.myColor;
        if (result == null) {
            result = this.isMilestone() || this.getNestedTasks().length > 0 ? Color.BLACK : this.myManager.getConfig().getDefaultColor();
        }
        return result;
    }

    public String getNotes() {
        return this.myNotes;
    }

    public GanttTaskRelationship[] getPredecessors() {
        return new GanttTaskRelationship[0];
    }

    public GanttTaskRelationship[] getSuccessors() {
        return new GanttTaskRelationship[0];
    }

    public ResourceAssignment[] getAssignments() {
        return this.myAssignments.getAssignments();
    }

    public ResourceAssignmentCollection getAssignmentCollection() {
        return this.myAssignments;
    }

    public Task getSupertask() {
        TaskHierarchyItem container = this.myTaskHierarchyItem.getContainerItem();
        return container.getTask();
    }

    public Task[] getNestedTasks() {
        TaskHierarchyItem[] nestedItems = this.myTaskHierarchyItem.getNestedItems();
        Task[] result = new Task[nestedItems.length];
        for (int i = 0; i < nestedItems.length; ++i) {
            result[i] = nestedItems[i].getTask();
        }
        return result;
    }

    public void move(Task targetSupertask) {
        TaskImpl supertaskImpl = (TaskImpl)targetSupertask;
        TaskHierarchyItem targetItem = supertaskImpl.myTaskHierarchyItem;
        this.myTaskHierarchyItem.delete();
        targetItem.addNestedItem(this.myTaskHierarchyItem);
        this.myManager.onTaskMoved(this);
    }

    public void delete() {
        this.getDependencies().clear();
        this.getAssignmentCollection().clear();
    }

    public TaskDependencySlice getDependencies() {
        return this.myDependencySlice;
    }

    public TaskDependencySlice getDependenciesAsDependant() {
        return this.myDependencySliceAsDependant;
    }

    public TaskDependencySlice getDependenciesAsDependee() {
        return this.myDependencySliceAsDependee;
    }

    public TaskManager getManager() {
        return this.myManager;
    }

    protected void setTaskIDHack(int taskID) {
        this.myID = taskID;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setWebLink(String webLink) {
        this.myWebLink = webLink;
    }

    public void setMilestone(boolean milestone) {
        this.isMilestone = milestone;
    }

    public void setPriority(int priority) {
        this.myPriority = priority;
    }

    public void setStart(GanttCalendar start) {
        Date closestWorkingStart = this.myManager.findClosestWorkingTime(start.getTime());
        start.setTime(closestWorkingStart);
        GanttCalendar oldStart = this.myStart == null ? null : this.myStart.Clone();
        this.myStart = start;
        GanttCalendar oldEnd = this.getEnd();
        this.recalculateActivities();
    }

    private void adjustNestedTasks() {
        try {
            if (!$assertionsDisabled && this.myManager == null) {
                throw new AssertionError();
            }
            AlgorithmCollection algorithmCollection = this.myManager.getAlgorithmCollection();
            if (algorithmCollection != null) {
                algorithmCollection.getAdjustTaskBoundsAlgorithm().adjustNestedTasks(this);
            }
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
    }

    public boolean isSupertask() {
        return this.myManager.getTaskHierarchy().hasNestedTasks(this);
    }

    public void setEnd(GanttCalendar end) {
        GanttCalendar oldFinish = this.myEnd == null ? null : this.myEnd.Clone();
        this.myEnd = end;
        this.recalculateActivities();
    }

    public void setThirdDate(GanttCalendar third) {
        GanttCalendar oldThird = this.myThird == null ? null : this.myThird.Clone();
        this.myThird = third;
    }

    public void setThirdDateConstraint(int thirdDateConstraint) {
        this.myThirdDateConstraint = thirdDateConstraint;
    }

    public void shift(TaskLength shift) {
        float unitCount = shift.getLength(this.myLength.getTimeUnit());
        if (unitCount != 0.0f) {
            Task resultTask = this.shift(unitCount);
            GanttCalendar oldStart = this.myStart;
            GanttCalendar oldEnd = this.myEnd;
            this.myStart = resultTask.getStart();
            this.myLength = resultTask.getDuration();
            this.myEnd = resultTask.getEnd();
            if (this.areEventsEnabled()) {
                this.myManager.fireTaskScheduleChanged(this, oldStart, oldEnd);
            }
            this.recalculateActivities();
        }
    }

    public Task shift(float unitCount) {
        Task clone = this.unpluggedClone();
        if (unitCount > 0.0f) {
            TaskLength length = this.myManager.createLength(this.myLength.getTimeUnit(), unitCount);
            Date shiftedDate = this.shiftDate(this.myStart.getTime(), length.getTimeUnit(), length.getLength(), RESTLESS_CALENDAR);
            clone.setStart(new GanttCalendar(shiftedDate));
            clone.setDuration(this.myLength);
        } else {
            Date newStart = this.shiftDate(clone.getStart().getTime(), clone.getDuration().getTimeUnit(), (long)unitCount);
            clone.setStart(new GanttCalendar(newStart));
            clone.setDuration(this.myLength);
        }
        return clone;
    }

    public void setDuration(TaskLength length) {
        if (!$assertionsDisabled && length.getLength() <= 0L) {
            throw new AssertionError();
        }
        this.myLength = length;
        this.myEnd = null;
        this.recalculateActivities();
    }

    private Date shiftDate(Date input, TimeUnit timeUnit, long length) {
        return this.shiftDate(input, timeUnit, length, this.myManager.getConfig().getCalendar());
    }

    private Date shiftDate(Date input, TimeUnit timeUnit, long length, GPCalendar calendar) {
        Date result;
        List activities = calendar.getActivities(input, timeUnit, length);
        if (activities.isEmpty()) {
            throw new RuntimeException("Can't set length=" + length + " start=" + input);
        }
        if (length >= 0L) {
            GPCalendarActivity lastActivity = (GPCalendarActivity)activities.get(activities.size() - 1);
            result = lastActivity.getEnd();
        } else {
            GPCalendarActivity firstActivity = (GPCalendarActivity)activities.get(0);
            result = firstActivity.getStart();
        }
        return result;
    }

    public TaskLength translateDuration(TaskLength duration) {
        return this.myManager.createLength(this.myLength.getTimeUnit(), this.translateDurationValue(duration));
    }

    private float translateDurationValue(TaskLength duration) {
        if (this.myLength.getTimeUnit().equals(duration.getTimeUnit())) {
            return duration.getValue();
        }
        if (this.myLength.getTimeUnit().isConstructedFrom(duration.getTimeUnit())) {
            return duration.getValue() / (float)this.myLength.getTimeUnit().getAtomCount(duration.getTimeUnit());
        }
        if (duration.getTimeUnit().isConstructedFrom(this.myLength.getTimeUnit())) {
            return duration.getValue() * (float)duration.getTimeUnit().getAtomCount(this.myLength.getTimeUnit());
        }
        throw new RuntimeException("Can't transalte duration=" + duration + " into units=" + this.myLength.getTimeUnit());
    }

    private void recalculateActivities() {
        if (this.myLength == null || this.myManager == null) {
            return;
        }
        this.recalculateActivities(this.myActivities, this.myStart.getTime(), this.getEnd().getTime());
        int length = 0;
        for (int i = 0; i < this.myActivities.size(); ++i) {
            TaskActivity next = (TaskActivity)this.myActivities.get(i);
            if (!(next.getIntensity() > 0.0f)) continue;
            length = (int)((float)length + next.getDuration().getLength(this.getDuration().getTimeUnit()));
        }
        this.myLength = this.getManager().createLength(this.myLength.getTimeUnit(), length);
    }

    private void recalculateActivities(List output, Date startDate, Date endDate) {
        GPCalendar calendar = this.myManager.getConfig().getCalendar();
        List activities = calendar.getActivities(startDate, endDate);
        output.clear();
        for (int i = 0; i < activities.size(); ++i) {
            TaskActivityImpl nextTaskActivity;
            GPCalendarActivity nextCalendarActivity = (GPCalendarActivity)activities.get(i);
            if (nextCalendarActivity.isWorkingTime()) {
                nextTaskActivity = new TaskActivityImpl(this, nextCalendarActivity.getStart(), nextCalendarActivity.getEnd());
            } else {
                if (i <= 0 || i + 1 >= activities.size()) continue;
                nextTaskActivity = new TaskActivityImpl(this, nextCalendarActivity.getStart(), nextCalendarActivity.getEnd(), 0.0f);
            }
            output.add(nextTaskActivity);
        }
    }

    public void setCompletionPercentage(int percentage) {
        int oldPercentage = this.myCompletionPercentage;
        this.myCompletionPercentage = percentage;
        if (oldPercentage != this.myCompletionPercentage) {
            ProgressEventSender progressEventSender = new ProgressEventSender();
            progressEventSender.enable();
            progressEventSender.fireEvent();
        }
    }

    public void setShape(ShapePaint shape) {
        this.myShape = shape;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void setNotes(String notes) {
        this.myNotes = notes;
    }

    public void setExpand(boolean expand) {
        this.bExpand = expand;
    }

    public void addNotes(String notes) {
        this.myNotes = this.myNotes + notes;
    }

    protected void enableEvents(boolean enabled) {
        this.myEventsEnabled = enabled;
    }

    protected boolean areEventsEnabled() {
        return this.myEventsEnabled;
    }

    public boolean shapeDefined() {
        return this.myShape != null;
    }

    public boolean colorDefined() {
        return this.myColor != null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isUnplugged() {
        return this.myTaskHierarchyItem == null;
    }

    public CustomColumnsValues getCustomValues() {
        return this.customValues;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void applyThirdDateConstraint() {
        TaskLength length = this.getDuration();
        if (this.getThird() != null) {
            switch (this.getThirdDateConstraint()) {
                case 1: {
                    if (!this.getThird().after(this.getStart())) break;
                    int difference = this.getThird().diff(this.getStart());
                    GanttCalendar _start = this.getStart().newAdd(difference);
                    GanttCalendar _end = this.getEnd().newAdd(difference);
                    this.setEnd(_end);
                    this.setStart(_start);
                    this.setDuration(length);
                }
            }
        }
    }

    public TaskInfo getTaskInfo() {
        return this.myTaskInfo;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        this.myTaskInfo = taskInfo;
    }

    public boolean isProjectTask() {
        return this.isProjectTask;
    }

    public void setProjectTask(boolean projectTask) {
        this.isProjectTask = projectTask;
    }

    static {
        $assertionsDisabled = !TaskImpl.class.desiredAssertionStatus();
        RESTLESS_CALENDAR = new AlwaysWorkingTimeCalendarImpl();
    }

    private class MutatorImpl
    implements TaskMutator {
        private EventSender myPropertiesEventSender;
        private EventSender myProgressEventSender;
        private FieldChange myCompletionPercentageChange;
        private FieldChange myStartChange;
        private FieldChange myEndChange;
        private FieldChange myThirdChange;
        private DurationChange myDurationChange;
        private List myActivities;
        private final List myCommands;
        private int myIsolationLevel;
        private TaskInfo myTaskInfo;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MutatorImpl() {
            this.myPropertiesEventSender = new PropertiesEventSender();
            this.myProgressEventSender = new ProgressEventSender();
            this.myCommands = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            try {
                GanttCalendar end;
                boolean fireChanges = false;
                if (this.myStartChange != null) {
                    GanttCalendar start = this.getStart();
                    TaskImpl.this.setStart(start);
                }
                if (this.myDurationChange != null) {
                    TaskLength duration = this.getDuration();
                    TaskImpl.this.setDuration(duration);
                    this.myEndChange = null;
                }
                if (this.myCompletionPercentageChange != null) {
                    int newValue = this.getCompletionPercentage();
                    TaskImpl.this.setCompletionPercentage(newValue);
                }
                if (this.myEndChange != null && (end = this.getEnd()).getTime().compareTo(TaskImpl.this.getStart().getTime()) > 0) {
                    TaskImpl.this.setEnd(end);
                }
                if (this.myThirdChange != null) {
                    GanttCalendar third = this.getThird();
                    TaskImpl.this.setThirdDate(third);
                }
                for (int i = 0; i < this.myCommands.size(); ++i) {
                    Runnable next = (Runnable)this.myCommands.get(i);
                    next.run();
                }
                this.myCommands.clear();
                this.myPropertiesEventSender.fireEvent();
                this.myProgressEventSender.fireEvent();
            }
            finally {
                TaskImpl.this.myMutator = null;
            }
            if (this.myStartChange != null && TaskImpl.this.isSupertask()) {
                TaskImpl.this.adjustNestedTasks();
            }
            if ((this.myStartChange != null || this.myEndChange != null || this.myDurationChange != null) && TaskImpl.this.areEventsEnabled()) {
                GanttCalendar oldStart = (GanttCalendar)(this.myStartChange == null ? TaskImpl.this.getStart() : this.myStartChange.myOldValue);
                GanttCalendar oldEnd = (GanttCalendar)(this.myEndChange == null ? TaskImpl.this.getEnd() : this.myEndChange.myOldValue);
                TaskImpl.this.myManager.fireTaskScheduleChanged(TaskImpl.this, oldStart, oldEnd);
            }
        }

        public GanttCalendar getThird() {
            return this.myThirdChange == null ? TaskImpl.this.myThird : (GanttCalendar)this.myThirdChange.myFieldValue;
        }

        public List getActivities() {
            if (this.myActivities == null && this.myStartChange != null || this.myDurationChange != null) {
                this.myActivities = new ArrayList();
                TaskImpl.this.recalculateActivities(this.myActivities, this.getStart().getTime(), TaskImpl.this.getEnd().getTime());
            }
            return this.myActivities;
        }

        public void setName(String name) {
            this.myCommands.add(new Runnable(this, name){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$name = val$name;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setName(this.val$name);
                }
            });
        }

        public void setProjectTask(boolean projectTask) {
            this.myCommands.add(new Runnable(this, projectTask){
                private final /* synthetic */ boolean val$projectTask;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$projectTask = val$projectTask;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setProjectTask(this.val$projectTask);
                }
            });
        }

        public void setMilestone(boolean milestone) {
            this.myCommands.add(new Runnable(this, milestone){
                private final /* synthetic */ boolean val$milestone;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$milestone = val$milestone;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setMilestone(this.val$milestone);
                }
            });
        }

        public void setPriority(int priority) {
            this.myCommands.add(new Runnable(this, priority){
                private final /* synthetic */ int val$priority;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$priority = val$priority;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setPriority(this.val$priority);
                }
            });
        }

        public void setStart(GanttCalendar start) {
            if (!$assertionsDisabled && start == null) {
                throw new AssertionError();
            }
            GanttCalendar currentStart = this.getStart();
            if (currentStart != null && start.equals(currentStart)) {
                return;
            }
            if (this.myStartChange == null) {
                this.myStartChange = new FieldChange();
                this.myStartChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myStartChange.setOldValue(TaskImpl.this.myStart);
            this.myStartChange.setValue(start);
            this.myActivities = null;
        }

        public void setEnd(GanttCalendar end) {
            if (this.myEndChange == null) {
                this.myEndChange = new FieldChange();
                this.myEndChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myEndChange.setOldValue(TaskImpl.this.myEnd);
            this.myEndChange.setValue(end);
            this.myActivities = null;
        }

        public void setThird(GanttCalendar third, int thirdDateConstraint) {
            this.myCommands.add(new Runnable(this, thirdDateConstraint){
                private final /* synthetic */ int val$thirdDateConstraint;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$thirdDateConstraint = val$thirdDateConstraint;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setThirdDateConstraint(this.val$thirdDateConstraint);
                }
            });
            if (this.myThirdChange == null) {
                this.myThirdChange = new FieldChange();
                this.myThirdChange.myEventSender = this.myPropertiesEventSender;
            }
            this.myThirdChange.setValue(third);
            this.myActivities = null;
        }

        public void setDuration(TaskLength length) {
            if (this.myDurationChange == null) {
                this.myDurationChange = new DurationChange();
                this.myDurationChange.myEventSender = this.myPropertiesEventSender;
                this.myDurationChange.setValue(length);
            } else {
                TaskLength currentLength = (TaskLength)this.myDurationChange.myFieldValue;
                if (currentLength.getLength() - length.getLength() == 0L) {
                    return;
                }
            }
            TaskLength prevLength = (TaskLength)this.myDurationChange.myFieldValue;
            Date prevEnd = null;
            this.myDurationChange.setValue(length);
            Date shifted = prevEnd == null ? TaskImpl.this.shiftDate(this.getStart().getTime(), length.getTimeUnit(), length.getLength()) : TaskImpl.this.shiftDate(prevEnd, length.getTimeUnit(), length.getLength() - prevLength.getLength());
            GanttCalendar newEnd = new GanttCalendar(shifted);
            this.setEnd(newEnd);
            this.myActivities = null;
        }

        public void setExpand(boolean expand) {
            this.myCommands.add(new Runnable(this, expand){
                private final /* synthetic */ boolean val$expand;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$expand = val$expand;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setExpand(this.val$expand);
                }
            });
        }

        public void setCompletionPercentage(int percentage) {
            if (this.myCompletionPercentageChange == null) {
                this.myCompletionPercentageChange = new FieldChange();
                this.myCompletionPercentageChange.myEventSender = this.myProgressEventSender;
            }
            this.myCompletionPercentageChange.setValue(new Integer(percentage));
        }

        public void setCritical(boolean critical) {
            this.myCommands.add(new Runnable(this, critical){
                private final /* synthetic */ boolean val$critical;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$critical = val$critical;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setCritical(this.val$critical);
                }
            });
        }

        public void setShape(ShapePaint shape) {
            this.myCommands.add(new Runnable(this, shape){
                private final /* synthetic */ ShapePaint val$shape;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$shape = val$shape;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setShape(this.val$shape);
                }
            });
        }

        public void setColor(Color color) {
            this.myCommands.add(new Runnable(this, color){
                private final /* synthetic */ Color val$color;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$color = val$color;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setColor(this.val$color);
                }
            });
        }

        public void setNotes(String notes) {
            this.myCommands.add(new Runnable(this, notes){
                private final /* synthetic */ String val$notes;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$notes = val$notes;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).setNotes(this.val$notes);
                }
            });
        }

        public void addNotes(String notes) {
            this.myCommands.add(new Runnable(this, notes){
                private final /* synthetic */ String val$notes;
                private final /* synthetic */ MutatorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$notes = val$notes;
                }

                public void run() {
                    MutatorImpl.access$1100(this.this$1).addNotes(this.val$notes);
                }
            });
        }

        public int getCompletionPercentage() {
            return this.myCompletionPercentageChange == null ? TaskImpl.this.myCompletionPercentage : (Integer)this.myCompletionPercentageChange.myFieldValue;
        }

        GanttCalendar getStart() {
            return this.myStartChange == null ? TaskImpl.this.myStart : (GanttCalendar)this.myStartChange.myFieldValue;
        }

        GanttCalendar getEnd() {
            return this.myEndChange == null ? null : (GanttCalendar)this.myEndChange.myFieldValue;
        }

        TaskLength getDuration() {
            return this.myDurationChange == null ? TaskImpl.this.myLength : (TaskLength)this.myDurationChange.myFieldValue;
        }

        public void shift(float unitCount) {
            Task result = this.getPrecomputedShift(unitCount);
            if (result == null) {
                result = TaskImpl.this.shift(unitCount);
                this.cachePrecomputedShift(result, unitCount);
            }
            this.setStart(result.getStart());
            this.setDuration(result.getDuration());
            this.setEnd(result.getEnd());
        }

        public void shift(TaskLength shift) {
            TaskImpl.this.shift(shift);
        }

        public void setIsolationLevel(int level) {
            this.myIsolationLevel = level;
        }

        private void cachePrecomputedShift(Task result, float unitCount) {
        }

        private Task getPrecomputedShift(float unitCount) {
            return null;
        }

        public TaskInfo getTaskInfo() {
            return this.myTaskInfo;
        }

        public void setTaskInfo(TaskInfo taskInfo) {
            this.myTaskInfo = taskInfo;
        }

        static /* synthetic */ TaskImpl access$1100(MutatorImpl x0) {
            return x0.TaskImpl.this;
        }

        static {
            $assertionsDisabled = !(class$net$sourceforge$ganttproject$task$TaskImpl == null ? (class$net$sourceforge$ganttproject$task$TaskImpl = TaskImpl.class$("net.sourceforge.ganttproject.task.TaskImpl")) : class$net$sourceforge$ganttproject$task$TaskImpl).desiredAssertionStatus();
        }
    }

    private static class DurationChange
    extends FieldChange {
        private int myMinLength = 0;
        private List myDates;

        private DurationChange() {
        }

        Date getCachedDate(int length) {
            if (this.myDates == null) {
                return null;
            }
            int index = length - this.myMinLength;
            if (index < 0 || index >= this.myDates.size()) {
                return null;
            }
            return (Date)this.myDates.get(index);
        }

        void cacheDate(Date date, int length) {
            int index;
            if (this.myDates == null) {
                this.myDates = new ArrayList();
            }
            for (index = length - this.myMinLength; index <= -1; ++index) {
                this.myDates.add(0, null);
            }
            while (index > this.myDates.size()) {
                this.myDates.add(null);
            }
            if (index == -1) {
                this.myDates.add(0, date);
            } else if (index == this.myDates.size()) {
                this.myDates.add(date);
            } else {
                this.myDates.set(index, date);
            }
        }
    }

    private static class FieldChange {
        String myFieldName;
        Object myFieldValue;
        Object myOldValue;
        EventSender myEventSender;

        private FieldChange() {
        }

        void setValue(Object newValue) {
            this.myFieldValue = newValue;
            this.myEventSender.enable();
        }

        public void setOldValue(Object oldValue) {
            this.myOldValue = oldValue;
        }
    }

    private class PropertiesEventSender
    implements EventSender {
        private boolean myEnabled;

        private PropertiesEventSender() {
        }

        public void fireEvent() {
            if (this.myEnabled) {
                TaskImpl.this.myManager.fireTaskPropertiesChanged(TaskImpl.this);
            }
            this.myEnabled = false;
        }

        public void enable() {
            this.myEnabled = true;
        }
    }

    private class ProgressEventSender
    implements EventSender {
        private boolean myEnabled;

        private ProgressEventSender() {
        }

        public void fireEvent() {
            if (this.myEnabled) {
                TaskImpl.this.myManager.fireTaskProgressChanged(TaskImpl.this);
            }
            this.myEnabled = false;
        }

        public void enable() {
            this.myEnabled = true;
        }
    }

    private static interface EventSender {
        public void enable();

        public void fireEvent();
    }
}

