/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.algorithm;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.sourceforge.ganttproject.task.Task;

public class ProjectBoundsAlgorithm {
    public Result getBounds(Collection tasks) {
        Date lowerBound = null;
        Date upperBound = null;
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            Task next = (Task)it.next();
            Date start = next.getStart().getTime();
            Date end = next.getEnd().getTime();
            if (lowerBound == null || lowerBound.after(start)) {
                lowerBound = start;
            }
            if (upperBound != null && !upperBound.before(end)) continue;
            upperBound = end;
        }
        return new Result(lowerBound, upperBound);
    }

    public static class Result {
        public final Date lowerBound;
        public final Date upperBound;

        private Result(Date lowerBound, Date upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }
    }
}

