/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time.gregorian;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnitText;
import net.sourceforge.ganttproject.time.gregorian.CachingTextFormatter;

public class MonthTextFormatter
extends CachingTextFormatter
implements TextFormatter {
    private SimpleDateFormat myLongFormat;
    private SimpleDateFormat myMediumFormat;
    private SimpleDateFormat myShortFormat;

    public MonthTextFormatter() {
        this.initFormats();
    }

    protected TimeUnitText createTimeUnitText(Date adjustedLeft) {
        String longText = MessageFormat.format("{0}", this.myLongFormat.format(adjustedLeft));
        String mediumText = MessageFormat.format("{0}", this.myMediumFormat.format(adjustedLeft));
        String shortText = MessageFormat.format("{0}", this.myShortFormat.format(adjustedLeft));
        TimeUnitText result = new TimeUnitText(longText, mediumText, shortText);
        return result;
    }

    private void initFormats() {
        this.myLongFormat = GanttLanguage.getInstance().createDateFormat("MMMM yyyy");
        this.myMediumFormat = GanttLanguage.getInstance().createDateFormat("MMM - yy");
        this.myShortFormat = GanttLanguage.getInstance().createDateFormat("MM - yy");
    }

    public void languageChanged(GanttLanguage.Event event) {
        super.languageChanged(event);
        this.initFormats();
    }
}

