/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.DOMKeyEvent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

public class BridgeEventSupport
implements SVGConstants {
    private BridgeEventSupport() {
    }

    public static void addGVTListener(BridgeContext ctx, Document doc) {
        EventDispatcher dispatcher;
        UserAgent ua = ctx.getUserAgent();
        if (ua != null && (dispatcher = ua.getEventDispatcher()) != null) {
            Listener listener = new Listener(ctx, ua);
            dispatcher.addGraphicsNodeMouseListener(listener);
            dispatcher.addGraphicsNodeKeyListener(listener);
            GVTUnloadListener l = new GVTUnloadListener(dispatcher, listener);
            EventTarget target = (EventTarget)((Object)doc);
            target.addEventListener("SVGUnload", l, false);
            ctx.storeEventListener(target, "SVGUnload", l, false);
        }
    }

    protected static class Listener
    implements GraphicsNodeMouseListener,
    GraphicsNodeKeyListener {
        protected BridgeContext context;
        protected UserAgent ua;
        protected Element lastTargetElement;
        protected boolean isDown;

        public Listener(BridgeContext ctx, UserAgent u) {
            this.context = ctx;
            this.ua = u;
        }

        public void keyPressed(GraphicsNodeKeyEvent evt) {
            if (!this.isDown) {
                this.isDown = true;
                this.dispatchKeyEvent("keydown", evt);
            }
        }

        public void keyReleased(GraphicsNodeKeyEvent evt) {
            this.dispatchKeyEvent("keyup", evt);
            this.isDown = false;
        }

        public void keyTyped(GraphicsNodeKeyEvent evt) {
            this.dispatchKeyEvent("keypress", evt);
        }

        protected void dispatchKeyEvent(String eventType, GraphicsNodeKeyEvent evt) {
            Element targetElement = (Element)((Object)this.context.getFocusManager().getCurrentEventTarget());
            if (targetElement == null) {
                return;
            }
            DocumentEvent d = (DocumentEvent)((Object)targetElement.getOwnerDocument());
            DOMKeyEvent keyEvt = (DOMKeyEvent)d.createEvent("KeyEvents");
            keyEvt.initKeyEvent(eventType, true, true, evt.isControlDown(), evt.isAltDown(), evt.isShiftDown(), evt.isMetaDown(), evt.getKeyCode(), (int)evt.getKeyChar(), null);
            try {
                ((EventTarget)((Object)targetElement)).dispatchEvent((Event)keyEvt);
            }
            catch (RuntimeException e) {
                this.ua.displayError(e);
            }
        }

        public void mouseClicked(GraphicsNodeMouseEvent evt) {
            this.dispatchMouseEvent("click", evt, true);
        }

        public void mousePressed(GraphicsNodeMouseEvent evt) {
            this.dispatchMouseEvent("mousedown", evt, true);
        }

        public void mouseReleased(GraphicsNodeMouseEvent evt) {
            this.dispatchMouseEvent("mouseup", evt, true);
        }

        public void mouseEntered(GraphicsNodeMouseEvent evt) {
            this.dispatchMouseEvent("mouseover", evt, true);
        }

        public void mouseExited(GraphicsNodeMouseEvent evt) {
            Point clientXY = this.getClientMouseLocation(evt.getPoint2D());
            GraphicsNode node = evt.getGraphicsNode();
            Element targetElement = this.getEventTarget(node, clientXY);
            if (this.lastTargetElement != null) {
                this.dispatchMouseEvent("mouseout", this.lastTargetElement, targetElement, clientXY, evt, true);
            }
        }

        public void mouseDragged(GraphicsNodeMouseEvent evt) {
            this.dispatchMouseEvent("mousemove", evt, false);
        }

        public void mouseMoved(GraphicsNodeMouseEvent evt) {
            Point clientXY = this.getClientMouseLocation(evt.getPoint2D());
            GraphicsNode node = evt.getGraphicsNode();
            Element targetElement = this.getEventTarget(node, clientXY);
            if (this.lastTargetElement != targetElement) {
                if (this.lastTargetElement != null) {
                    this.dispatchMouseEvent("mouseout", this.lastTargetElement, targetElement, clientXY, evt, true);
                }
                if (targetElement != null) {
                    this.dispatchMouseEvent("mouseover", targetElement, this.lastTargetElement, clientXY, evt, true);
                }
            }
            this.dispatchMouseEvent("mousemove", targetElement, null, clientXY, evt, false);
        }

        protected void dispatchMouseEvent(String eventType, GraphicsNodeMouseEvent evt, boolean cancelable) {
            Point clientXY = this.getClientMouseLocation(evt.getPoint2D());
            GraphicsNode node = evt.getGraphicsNode();
            Element targetElement = this.getEventTarget(node, clientXY);
            Element relatedElement = this.getRelatedElement(evt);
            this.dispatchMouseEvent(eventType, targetElement, relatedElement, clientXY, evt, cancelable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseEvent(String eventType, Element targetElement, Element relatedElement, Point clientXY, GraphicsNodeMouseEvent evt, boolean cancelable) {
            if (targetElement == null) {
                return;
            }
            short button = this.getButton(evt);
            Point screenXY = evt.getScreenPoint();
            DocumentEvent d = (DocumentEvent)((Object)targetElement.getOwnerDocument());
            MouseEvent mouseEvt = (MouseEvent)d.createEvent("MouseEvents");
            mouseEvt.initMouseEvent(eventType, true, cancelable, null, evt.getClickCount(), screenXY.x, screenXY.y, clientXY.x, clientXY.y, evt.isControlDown(), evt.isAltDown(), evt.isShiftDown(), evt.isMetaDown(), button, (EventTarget)((Object)relatedElement));
            try {
                try {
                    ((EventTarget)((Object)targetElement)).dispatchEvent(mouseEvt);
                }
                catch (RuntimeException e) {
                    this.ua.displayError(e);
                    Object var13_12 = null;
                    this.lastTargetElement = targetElement;
                }
                Object var13_11 = null;
                this.lastTargetElement = targetElement;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.lastTargetElement = targetElement;
                throw throwable;
            }
        }

        protected Element getRelatedElement(GraphicsNodeMouseEvent evt) {
            GraphicsNode relatedNode = evt.getRelatedNode();
            Element relatedElement = null;
            if (relatedNode != null) {
                relatedElement = this.context.getElement(relatedNode);
            }
            return relatedElement;
        }

        protected short getButton(GraphicsNodeMouseEvent evt) {
            int button = 1;
            if ((0x10 & evt.getModifiers()) != 0) {
                button = 0;
            } else if ((4 & evt.getModifiers()) != 0) {
                button = 2;
            }
            return (short)button;
        }

        protected Point getClientMouseLocation(Point2D coords) {
            AffineTransform transform = this.ua.getTransform();
            Point2D p = coords;
            if (transform != null && !transform.isIdentity()) {
                p = transform.transform(coords, null);
            }
            return new Point((int)Math.floor(coords.getX()), (int)Math.floor(coords.getY()));
        }

        protected Element getEventTarget(GraphicsNode node, Point2D coords) {
            Element target = this.context.getElement(node);
            if (target != null && node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                List list = textNode.getTextRuns();
                try {
                    node.getGlobalTransform().createInverse().transform(coords, coords);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
                if (list != null) {
                    int i = 0;
                    while (i < list.size()) {
                        Object delimiter;
                        float y;
                        float x;
                        StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
                        AttributedCharacterIterator aci = run.getACI();
                        TextSpanLayout layout = run.getLayout();
                        TextHit textHit = layout.hitTestChar(x = (float)coords.getX(), y = (float)coords.getY());
                        if (textHit != null && layout.getBounds2D().contains(x, y) && (delimiter = aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER)) instanceof Element) {
                            return (Element)delimiter;
                        }
                        ++i;
                    }
                }
            }
            return target;
        }
    }

    protected static class GVTUnloadListener
    implements EventListener {
        protected EventDispatcher dispatcher;
        protected Listener listener;

        public GVTUnloadListener(EventDispatcher dispatcher, Listener listener) {
            this.dispatcher = dispatcher;
            this.listener = listener;
        }

        public void handleEvent(Event evt) {
            this.dispatcher.removeGraphicsNodeMouseListener(this.listener);
            this.dispatcher.removeGraphicsNodeKeyListener(this.listener);
            evt.getTarget().removeEventListener("SVGUnload", this, false);
        }
    }
}

