/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.svg.DomExtension;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.DoublyIndexedTable;
import org.apache.batik.util.Service;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtensibleSVGDOMImplementation
extends SVGDOMImplementation {
    protected static final DOMImplementation DOM_IMPLEMENTATION = new ExtensibleSVGDOMImplementation();
    protected DoublyIndexedTable customFactories;
    protected List customValueManagers;
    protected List customShorthandManagers;
    protected static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$dom$svg$DomExtension;

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    public ExtensibleSVGDOMImplementation() {
        Iterator iter = ExtensibleSVGDOMImplementation.getDomExtensions().iterator();
        while (iter.hasNext()) {
            DomExtension de = (DomExtension)iter.next();
            de.registerTags(this);
        }
    }

    public void registerCustomElementFactory(String namespaceURI, String localName, SVGDOMImplementation.ElementFactory factory) {
        if (this.customFactories == null) {
            this.customFactories = new DoublyIndexedTable();
        }
        this.customFactories.put((Object)namespaceURI, (Object)localName, (Object)factory);
    }

    public void registerCustomCSSValueManager(ValueManager vm) {
        if (this.customValueManagers == null) {
            this.customValueManagers = new LinkedList();
        }
        this.customValueManagers.add(vm);
    }

    public void registerCustomCSSShorthandManager(ShorthandManager sm) {
        if (this.customShorthandManagers == null) {
            this.customShorthandManagers = new LinkedList();
        }
        this.customShorthandManagers.add(sm);
    }

    public CSSEngine createCSSEngine(SVGOMDocument doc, CSSContext ctx) {
        ShorthandManager[] sms;
        ValueManager[] vms;
        Parser p;
        if (this.customValueManagers == null && this.customShorthandManagers == null) {
            return super.createCSSEngine(doc, ctx);
        }
        String pn = XMLResourceDescriptor.getCSSParserClassName();
        try {
            p = (Parser)Class.forName(pn).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{pn}));
        }
        catch (InstantiationException e) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{pn}));
        }
        catch (IllegalAccessException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        ExtendedParser ep = ExtendedParserWrapper.wrap((Parser)p);
        if (this.customValueManagers == null) {
            vms = new ValueManager[]{};
        } else {
            vms = new ValueManager[this.customValueManagers.size()];
            Iterator it = this.customValueManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                vms[i++] = (ValueManager)it.next();
            }
        }
        if (this.customShorthandManagers == null) {
            sms = new ShorthandManager[]{};
        } else {
            sms = new ShorthandManager[this.customShorthandManagers.size()];
            Iterator it = this.customShorthandManagers.iterator();
            int i = 0;
            while (it.hasNext()) {
                sms[i++] = (ShorthandManager)it.next();
            }
        }
        URL durl = doc.getURLObject();
        SVGCSSEngine result = new SVGCSSEngine((Document)doc, durl, ep, vms, sms, ctx);
        URL url = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (url != null) {
            InputSource is = new InputSource(url.toString());
            result.setUserAgentStyleSheet(result.parseStyleSheet(is, url, "all"));
        }
        doc.setCSSEngine((CSSEngine)result);
        return result;
    }

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        if ("http://www.w3.org/2000/svg".equals(namespaceURI)) {
            String name = DOMUtilities.getLocalName((String)qualifiedName);
            SVGDOMImplementation.ElementFactory ef = (SVGDOMImplementation.ElementFactory)this.factories.get((Object)name);
            if (ef == null) {
                throw document.createDOMException((short)8, "invalid.element", new Object[]{namespaceURI, qualifiedName});
            }
            return ef.create(DOMUtilities.getPrefix((String)qualifiedName), (Document)document);
        }
        if (namespaceURI != null) {
            String name;
            SVGDOMImplementation.ElementFactory cef;
            if (this.customFactories != null && (cef = (SVGDOMImplementation.ElementFactory)this.customFactories.get((Object)namespaceURI, (Object)(name = DOMUtilities.getLocalName((String)qualifiedName)))) != null) {
                return cef.create(DOMUtilities.getPrefix((String)qualifiedName), (Document)document);
            }
            return new GenericElementNS(namespaceURI.intern(), qualifiedName.intern(), document);
        }
        return new GenericElement(qualifiedName.intern(), document);
    }

    protected static synchronized List getDomExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        Iterator iter = Service.providers(class$org$apache$batik$dom$svg$DomExtension == null ? (class$org$apache$batik$dom$svg$DomExtension = ExtensibleSVGDOMImplementation.class$("org.apache.batik.dom.svg.DomExtension")) : class$org$apache$batik$dom$svg$DomExtension);
        block0: while (iter.hasNext()) {
            DomExtension lde;
            DomExtension de = (DomExtension)iter.next();
            float priority = de.getPriority();
            ListIterator<DomExtension> li = extensions.listIterator();
            do {
                if (li.hasNext()) continue;
                li.add(de);
                continue block0;
            } while (!((lde = (DomExtension)li.next()).getPriority() > priority));
            li.previous();
            li.add(de);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

