/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.msproject;

import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.Priority;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.RelationList;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TimeUnit;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;

public abstract class GanttMPXJOpen {
    private GanttTree2 m_tasks;
    private GanttProject m_project;
    private HashMap m_taskMap = new HashMap();
    private HashMap m_resourceMap = new HashMap();
    private Locale m_mpxImportLocale = Locale.ENGLISH;
    private static final MPXDuration MILESTONE_DURATION;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GanttMPXJOpen(GanttTree2 tasks, GanttProject project, Locale mpxLocale) {
        this.m_tasks = tasks;
        this.m_project = project;
        this.m_mpxImportLocale = mpxLocale;
    }

    public GanttMPXJOpen(GanttTree2 tasks, GanttProject project) {
        this.m_tasks = tasks;
        this.m_project = project;
    }

    public boolean load(String filename) throws MPXException {
        return this.load(new File(filename));
    }

    public abstract boolean load(File var1) throws MPXException;

    public abstract boolean load(InputStream var1) throws MPXException;

    protected boolean load(MPXFile mpx) throws MPXException {
        this.processResources(mpx);
        try {
            this.processTasks(mpx);
        }
        catch (Exception e) {
            throw new MPXException(e.getMessage(), e);
        }
        this.processRelationships(mpx);
        this.processResourceAssignments(mpx);
        return true;
    }

    private void processResources(MPXFile mpx) {
        HumanResourceManager hrm = (HumanResourceManager)this.m_project.getHumanResourceManager();
        LinkedList resources = mpx.getAllResources();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (resource.getName() == null) continue;
            HumanResource people = hrm.newHumanResource();
            people.setName(resource.getName());
            people.setMail(resource.getEmailAddress());
            hrm.add((ProjectResource)people);
            this.m_resourceMap.put(resource.getID(), new Integer(people.getId()));
        }
    }

    private void processTasks(MPXFile mpx) throws Exception {
        TaskManager tm = this.m_project.getTaskManager();
        MPXCalendar cal = mpx.getBaseCalendar("Standard");
        LinkedList tasks = mpx.getChildTasks();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            this.processTask(tm, cal, (Task)iter.next(), null);
        }
    }

    private void processTask(TaskManager tm, MPXCalendar defaultCalendar, Task task, DefaultMutableTreeNode node) throws Exception {
        MPXDuration duration;
        MPXCalendar taskCalendar = task.getCalendar();
        MPXCalendar cal = taskCalendar != null ? taskCalendar : defaultCalendar;
        boolean milestone = task.getMilestoneValue();
        if (milestone) {
            duration = MILESTONE_DURATION;
        } else {
            Date taskStart = task.getStart();
            Date taskFinish = task.getFinish();
            duration = taskStart != null && taskFinish != null ? task.getDuration() : task.getDuration();
        }
        GanttTask gtask = tm.createTask();
        gtask.setCompletionPercentage((int)task.getPercentageCompleteValue());
        gtask.setMilestone(milestone);
        gtask.setName(task.getName() == null ? "-" : task.getName());
        gtask.setNotes(task.getNotes());
        Priority prio = task.getPriority();
        if (prio != null) {
            int p;
            int priority = prio.getValue();
            switch (priority) {
                case 700: 
                case 800: 
                case 900: {
                    p = 2;
                    break;
                }
                case 100: 
                case 200: 
                case 300: {
                    p = 0;
                    break;
                }
                default: {
                    p = 1;
                }
            }
            gtask.setPriority(p);
        }
        gtask.setWebLink(task.getHyperlink());
        Date taskStart = task.getStart();
        if (!$assertionsDisabled && taskStart == null) {
            throw new AssertionError((Object)("Task=" + task + " has null start"));
        }
        gtask.setStart(new GanttCalendar(taskStart));
        gtask.setDuration(tm.createLength((long)Math.ceil(duration.convertUnits(TimeUnit.DAYS).getDuration())));
        tm.registerTask((net.sourceforge.ganttproject.task.Task)gtask);
        this.m_tasks.addObject((Object)gtask, (MutableTreeNode)((TaskNode)node), -1);
        this.m_taskMap.put(task.getID(), new Integer(gtask.getTaskID()));
        LinkedList children = task.getChildTasks();
        if (children.size() != 0) {
            node = this.m_tasks.getNode(gtask.getTaskID());
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.processTask(tm, defaultCalendar, (Task)iter.next(), node);
            }
        }
    }

    private void processRelationships(MPXFile mpx) {
        TaskManager tm = this.m_project.getTaskManager();
        Iterator taskIter = mpx.getAllTasks().iterator();
        while (taskIter.hasNext()) {
            RelationList rels;
            Task task = (Task)taskIter.next();
            int gTaskNumber1 = this.mapTaskNumber(task.getID());
            if (gTaskNumber1 == -1 || (rels = (RelationList)task.getPredecessors()) == null) continue;
            Iterator relIter = rels.iterator();
            while (relIter.hasNext()) {
                int gConstraintType;
                Relation rel = (Relation)relIter.next();
                int gTaskNumber2 = this.mapTaskNumber(new Integer(rel.getTaskIDValue()));
                if (gTaskNumber2 == -1) continue;
                GanttTask gTask1 = tm.getTask(gTaskNumber1);
                GanttTask gTask2 = tm.getTask(gTaskNumber2);
                switch (rel.getType().getType()) {
                    case 0: {
                        gConstraintType = 3;
                        break;
                    }
                    case 2: {
                        gConstraintType = 4;
                        break;
                    }
                    case 3: {
                        gConstraintType = 1;
                        break;
                    }
                    default: {
                        gConstraintType = 2;
                    }
                }
                try {
                    TaskDependency gTaskDependency = tm.getDependencyCollection().createDependency((net.sourceforge.ganttproject.task.Task)gTask1, (net.sourceforge.ganttproject.task.Task)gTask2, tm.createConstraint(gConstraintType));
                    gTaskDependency.setConstraint(tm.createConstraint(gConstraintType));
                }
                catch (TaskDependencyException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void processResourceAssignments(MPXFile mpx) {
        TaskManager tm = this.m_project.getTaskManager();
        HumanResourceManager hrm = (HumanResourceManager)this.m_project.getHumanResourceManager();
        LinkedList assignments = mpx.getAllResourceAssignments();
        Iterator iter = assignments.iterator();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            int gTaskID = this.mapTaskNumber(assignment.getTask().getID());
            int gResourceID = this.mapResourceNumber(assignment.getResource().getID());
            if (gTaskID == -1 || gResourceID == -1) continue;
            GanttTask gTask = tm.getTask(gTaskID);
            ProjectResource gResource = hrm.getById(gResourceID);
            net.sourceforge.ganttproject.task.ResourceAssignment gAssignment = gTask.getAssignmentCollection().addAssignment(gResource);
            gAssignment.setLoad((float)assignment.getUnitsValue());
            gAssignment.setCoordinator(false);
            if (!(gResource instanceof HumanResource)) continue;
            gAssignment.setRoleForAssignment(((HumanResource)gResource).getRole());
        }
    }

    private int mapTaskNumber(Integer taskID) {
        int result = -1;
        Integer taskNumber = (Integer)this.m_taskMap.get(taskID);
        if (taskNumber != null) {
            result = taskNumber;
        }
        return result;
    }

    private int mapResourceNumber(Integer resourceID) {
        int result = -1;
        Integer resourceNumber = (Integer)this.m_resourceMap.get(resourceID);
        if (resourceNumber != null) {
            result = resourceNumber;
        }
        return result;
    }

    static {
        $assertionsDisabled = !GanttMPXJOpen.class.desiredAssertionStatus();
        MILESTONE_DURATION = MPXDuration.getInstance((int)1, (TimeUnit)TimeUnit.DAYS);
    }
}

