/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.sf.memoranda.DefaultEventNotifier;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventNotificationListener;
import net.sf.memoranda.EventsManager;

public class EventsScheduler {
    static Vector _timers = new Vector();
    static Vector _listeners = new Vector();
    static Timer changeDateTimer = new Timer();

    public static void init() {
        EventsScheduler.cancelAll();
        Vector vector = (Vector)EventsManager.getActiveEvents();
        _timers = new Vector();
        System.out.println("----------");
        for (int i = 0; i < vector.size(); ++i) {
            Event event = (Event)vector.get(i);
            Date date = event.getTime();
            System.out.println(Calendar.getInstance().getTime());
            if (!date.after(Calendar.getInstance().getTime())) continue;
            EventTimer eventTimer = new EventTimer(event);
            eventTimer.schedule((TimerTask)new NotifyTask(eventTimer), event.getTime());
            _timers.add(eventTimer);
            System.out.println(event.getTimeString());
        }
        System.out.println("----------");
        Date date = EventsScheduler.getMidnight();
        changeDateTimer.schedule(new TimerTask(){

            public void run() {
                EventsScheduler.init();
                this.cancel();
            }
        }, date);
        EventsScheduler.notifyChanged();
    }

    public static void cancelAll() {
        for (int i = 0; i < _timers.size(); ++i) {
            EventTimer eventTimer = (EventTimer)_timers.get(i);
            eventTimer.cancel();
        }
    }

    public static Vector getScheduledEvents() {
        Vector<Event> vector = new Vector<Event>();
        for (int i = 0; i < _timers.size(); ++i) {
            vector.add(((EventTimer)_timers.get(i)).getEvent());
        }
        return vector;
    }

    public static Event getFirstScheduledEvent() {
        if (!EventsScheduler.isEventScheduled()) {
            return null;
        }
        Event event = ((EventTimer)_timers.get(0)).getEvent();
        for (int i = 1; i < _timers.size(); ++i) {
            Event event2 = ((EventTimer)_timers.get(i)).getEvent();
            if (!event2.getTime().before(event.getTime())) continue;
            event = event2;
        }
        return event;
    }

    public static void addListener(EventNotificationListener eventNotificationListener) {
        _listeners.add(eventNotificationListener);
    }

    public static boolean isEventScheduled() {
        return _timers.size() > 0;
    }

    private static void notifyListeners(Event event) {
        for (int i = 0; i < _listeners.size(); ++i) {
            ((EventNotificationListener)_listeners.get(i)).eventIsOccured(event);
        }
    }

    private static void notifyChanged() {
        for (int i = 0; i < _listeners.size(); ++i) {
            ((EventNotificationListener)_listeners.get(i)).eventsChanged();
        }
    }

    private static Date getMidnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    static {
        EventsScheduler.addListener(new DefaultEventNotifier());
    }

    static class EventTimer
    extends Timer {
        Event _event;

        public EventTimer(Event event) {
            this._event = event;
        }

        public Event getEvent() {
            return this._event;
        }
    }

    static class NotifyTask
    extends TimerTask {
        EventTimer _timer;

        public NotifyTask(EventTimer eventTimer) {
            this._timer = eventTimer;
        }

        public void run() {
            this._timer.cancel();
            _timers.remove(this._timer);
            EventsScheduler.notifyListeners(this._timer.getEvent());
            EventsScheduler.notifyChanged();
        }
    }
}

