/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Calendar;
import java.util.Collection;
import java.util.Vector;
import net.sf.memoranda.Project;
import net.sf.memoranda.Task;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;

public class TaskImpl
implements Task,
Comparable {
    private Element _element = null;
    private TaskList _tl = null;

    public TaskImpl(Element element, TaskList taskList) {
        this._element = element;
        this._tl = taskList;
    }

    public Element getContent() {
        return this._element;
    }

    public CalendarDate getStartDate() {
        return new CalendarDate(this._element.getAttribute("startDate").getValue());
    }

    public void setStartDate(CalendarDate calendarDate) {
        this.setAttr("startDate", calendarDate.toString());
    }

    public CalendarDate getEndDate() {
        String string = this._element.getAttribute("endDate").getValue();
        if (string != "") {
            return new CalendarDate(this._element.getAttribute("endDate").getValue());
        }
        Task task = this.getParentTask();
        if (task != null) {
            return task.getEndDate();
        }
        Project project = this._tl.getProject();
        if (project.getEndDate() != null) {
            return project.getEndDate();
        }
        return this.getStartDate();
    }

    public void setEndDate(CalendarDate calendarDate) {
        if (calendarDate == null) {
            this.setAttr("endDate", "");
        }
        this.setAttr("endDate", calendarDate.toString());
    }

    public long getEffort() {
        Attribute attribute = this._element.getAttribute("effort");
        if (attribute == null) {
            return 0L;
        }
        try {
            return Long.parseLong(attribute.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setEffort(long l) {
        this.setAttr("effort", String.valueOf(l));
    }

    public Task getParentTask() {
        Element element;
        ParentNode parentNode = this._element.getParent();
        if (parentNode instanceof Element && (element = (Element)parentNode).getLocalName().equalsIgnoreCase("task")) {
            return new TaskImpl(element, this._tl);
        }
        return null;
    }

    public String getParentId() {
        Task task = this.getParentTask();
        if (task != null) {
            return task.getID();
        }
        return null;
    }

    public String getDescription() {
        Element element = this._element.getFirstChildElement("description");
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public void setDescription(String string) {
        Element element = this._element.getFirstChildElement("description");
        if (element == null) {
            element = new Element("description");
            element.appendChild(string);
            this._element.appendChild((Node)element);
        } else {
            element.removeChildren();
            element.appendChild(string);
        }
    }

    public int getStatus(CalendarDate calendarDate) {
        CalendarDate calendarDate2 = this.getStartDate();
        CalendarDate calendarDate3 = this.getEndDate();
        if (this.isFrozen()) {
            return 4;
        }
        if (this.isCompleted()) {
            return 2;
        }
        if (calendarDate.inPeriod(calendarDate2, calendarDate3)) {
            if (calendarDate.equals(calendarDate3)) {
                return 7;
            }
            return 1;
        }
        if (calendarDate.before(calendarDate2)) {
            return 0;
        }
        if (calendarDate2.after(calendarDate3)) {
            return 1;
        }
        return 5;
    }

    private boolean isFrozen() {
        return this._element.getAttribute("frozen") != null;
    }

    private boolean isCompleted() {
        return this.getProgress() == 100;
    }

    public String getID() {
        return this._element.getAttribute("id").getValue();
    }

    public String getText() {
        return this._element.getFirstChildElement("text").getValue();
    }

    public String toString() {
        return this.getText();
    }

    public void setText(String string) {
        this._element.getFirstChildElement("text").removeChildren();
        this._element.getFirstChildElement("text").appendChild(string);
    }

    public void freeze() {
        this.setAttr("frozen", "yes");
    }

    public void unfreeze() {
        if (this.isFrozen()) {
            this._element.removeAttribute(new Attribute("frozen", "yes"));
        }
    }

    public Collection getDependsFrom() {
        Vector<Task> vector = new Vector<Task>();
        Elements elements = this._element.getChildElements("dependsFrom");
        for (int i = 0; i < elements.size(); ++i) {
            String string = elements.get(i).getAttribute("idRef").getValue();
            Task task = this._tl.getTask(string);
            if (task == null) continue;
            vector.add(task);
        }
        return vector;
    }

    public void addDependsFrom(Task task) {
        Element element = new Element("dependsFrom");
        element.addAttribute(new Attribute("idRef", task.getID()));
        this._element.appendChild((Node)element);
    }

    public void removeDependsFrom(Task task) {
        Elements elements = this._element.getChildElements("dependsFrom");
        for (int i = 0; i < elements.size(); ++i) {
            String string = elements.get(i).getAttribute("idRef").getValue();
            if (!string.equals(task.getID())) continue;
            this._element.removeChild((Node)elements.get(i));
            return;
        }
    }

    public int getProgress() {
        return new Integer(this._element.getAttribute("progress").getValue());
    }

    public void setProgress(int n) {
        if (n >= 0 && n <= 100) {
            this.setAttr("progress", new Integer(n).toString());
        }
    }

    public int getPriority() {
        Attribute attribute = this._element.getAttribute("priority");
        if (attribute == null) {
            return 2;
        }
        return new Integer(attribute.getValue());
    }

    public void setPriority(int n) {
        this.setAttr("priority", String.valueOf(n));
    }

    private void setAttr(String string, String string2) {
        Attribute attribute = this._element.getAttribute(string);
        if (attribute == null) {
            this._element.addAttribute(new Attribute(string, string2));
        } else {
            attribute.setValue(string2);
        }
    }

    private long calcTaskRate(CalendarDate calendarDate) {
        Calendar calendar = this.getEndDate().getCalendar();
        Calendar calendar2 = calendarDate.getCalendar();
        int n = calendar.get(1) * 365 + calendar.get(6) - (calendar2.get(1) * 365 + calendar2.get(6));
        if (n < 0) {
            return -1L;
        }
        return (100 - this.getProgress()) / (n + 1) * (this.getPriority() + 1);
    }

    public long getRate() {
        return -1L * this.calcTaskRate(CurrentDate.get());
    }

    public int compareTo(Object object) {
        Task task = (Task)object;
        if (this.getRate() > task.getRate()) {
            return 1;
        }
        if (this.getRate() < task.getRate()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof Task && ((Task)object).getID().equals(this.getID());
    }

    public Collection getSubTasks() {
        Elements elements = this._element.getChildElements("task");
        return this.convertToTaskObjects(elements);
    }

    private Collection convertToTaskObjects(Elements elements) {
        Vector<TaskImpl> vector = new Vector<TaskImpl>();
        for (int i = 0; i < elements.size(); ++i) {
            TaskImpl taskImpl = new TaskImpl(elements.get(i), this._tl);
            vector.add(taskImpl);
        }
        return vector;
    }

    public Task getSubTask(String string) {
        Elements elements = this._element.getChildElements("task");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("id").getValue().equals(string)) continue;
            return new TaskImpl(elements.get(i), this._tl);
        }
        return null;
    }

    public boolean hasSubTasks(String string) {
        Elements elements = this._element.getChildElements("task");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("id").getValue().equals(string)) continue;
            return true;
        }
        return false;
    }
}

