/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExportFilter
extends FileFilter {
    public static final String RTF = "RTF";
    public static final String HTML = "HTML";
    public static final String XHTML = "XHTML";
    public static final String ZIP = "ZIP";
    String _type = "";

    public ExportFilter(String string) {
        this._type = string;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = ExportFilter.getExtension(file);
        if (this._type.equals(RTF)) {
            return string.equals("rtf");
        }
        if (this._type.equals(ZIP)) {
            return string.equals("zip");
        }
        if (this._type.equals(XHTML)) {
            return string.equals("xhtml") || string.equals("xml");
        }
        return string.startsWith("htm");
    }

    public String getDescription() {
        if (this._type.equals(RTF)) {
            return "Rich Text Format (*.rtf)";
        }
        if (this._type.equals(ZIP)) {
            return "ZIP archives (*.zip)";
        }
        if (this._type.equals(XHTML)) {
            return "XHTML files (*.xhtml, *.xml)";
        }
        return "HTML files (*.html, *.htm)";
    }

    private static String getExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }
}

